//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/****************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/

/*! \file cnv_environment.cpp   
    Implementation file for the dotXSI environment classes
*/
#include "stdafx.h"
#include "cnv_environment.h"
#include <xsi_application.h>
#include <xsi_property.h>
#include <xsi_parameter.h>
#include <xsi_time.h>
#include <xsi_project.h>
#include <xsi_scene.h>
#include <xsi_model.h>
#include <xsi_sceneitem.h>
#include <Scene.h>
#include <Model.h>
#include <Ambience.h>
#include "cmdstubs.h"


/****************************************************************************************
CEnvironmentFromXSI
****************************************************************************************/

CEnvironmentFromXSI::CEnvironmentFromXSI() {};

CEnvironmentFromXSI::~CEnvironmentFromXSI() {};

wchar_t *CEnvironmentFromXSI::GetClassID() {	return L"CEnvironmentFromXSI";};

CStatus CEnvironmentFromXSI::Execute(CdotXSIConverter *in_pContext) 
{
	CStatus			status = CStatus::OK;
	CTime			time;
	Model			l_Root = in_pContext->scene().GetRoot();

	// set the root CREF in the FTK as user data for easy retrieval
	in_pContext->ftkscene()->Root()->AttachUserData(_SI_TEXT("CREF"), in_pContext->AddCRef(l_Root));

	// Fill up the ambient color from XSI
	CString		l_tmpString;
	CSIBCColorf	l_Color;

	l_tmpString = l_Root.GetName() + L".AmbientLighting.ambience.red";
	l_Color.m_fR = COMMANDS::GetValue(l_tmpString, CValue(time.GetTime()));
	l_tmpString = l_Root.GetName() + L".AmbientLighting.ambience.green";
	l_Color.m_fG = COMMANDS::GetValue(l_tmpString, CValue(time.GetTime()));
	l_tmpString = l_Root.GetName() + L".AmbientLighting.ambience.blue";
	l_Color.m_fB = COMMANDS::GetValue(l_tmpString, CValue(time.GetTime()));

	in_pContext->ftkscene()->Ambience()->SetColor(l_Color);

	return status;
};

/****************************************************************************************
CEnvironmentToXSI
****************************************************************************************/

CEnvironmentToXSI::CEnvironmentToXSI() {};

CEnvironmentToXSI::~CEnvironmentToXSI() {};

wchar_t *CEnvironmentToXSI::GetClassID() {	return L"CEnvironmentToXSI";};

CStatus CEnvironmentToXSI::Execute(CdotXSIConverter *in_pContext) 
{
	CStatus			status = CStatus::OK;
	CTime			time;
	Model			l_Root = in_pContext->scene().GetRoot();

	// set the root CREF in the FTK as user data for easy retrieval
	in_pContext->ftkscene()->Root()->AttachUserData(_SI_TEXT("CREF"), in_pContext->AddCRef(l_Root));

	// Fill up the ambient color in XSI
	CString		l_tmpString;
	CSIBCColorf	l_Color;

	l_Color = in_pContext->ftkscene()->Ambience()->GetColor();

	l_tmpString = l_Root.GetName() + L".AmbientLighting.ambience.red";
	COMMANDS::SetValue(l_tmpString, CValue(l_Color.m_fR), CValue(time.GetTime()));
	l_tmpString = l_Root.GetName() + L".AmbientLighting.ambience.green";
	COMMANDS::SetValue(l_tmpString, CValue(l_Color.m_fG), CValue(time.GetTime()));
	l_tmpString = l_Root.GetName() + L".AmbientLighting.ambience.blue";
	COMMANDS::SetValue(l_tmpString, CValue(l_Color.m_fB), CValue(time.GetTime()));


	return status;
};



