//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/****************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/

/*! \file cnv_environment_anim.cpp   
    Implementation file for the dotXSI environment animation classes
*/
#include "stdafx.h"
#include "cnv_environment_anim.h"
#include <xsi_application.h>
#include <xsi_property.h>
#include <xsi_parameter.h>
#include <xsi_model.h>
#include <Scene.h>
#include <Model.h>
#include <Ambience.h>
#include "../FTKUtil.h"
#include "cmdstubs.h"


/****************************************************************************************
CEnvironmentAnimationFromXSI
****************************************************************************************/

CEnvironmentAnimationFromXSI::CEnvironmentAnimationFromXSI() 
{
	m_pAnimationPlotter = NULL;
};

CEnvironmentAnimationFromXSI::~CEnvironmentAnimationFromXSI() {};

wchar_t *CEnvironmentAnimationFromXSI::GetClassID() {	return L"CEnvironmentAnimationFromXSI";};

CStatus CEnvironmentAnimationFromXSI::Execute(CdotXSIConverter *in_pContext) 
{
	CStatus			status = CStatus::OK;
	Model			l_Root = in_pContext->scene().GetRoot();

	CRefArray l_Properties = l_Root.GetProperties();
	Property l_AmbientLighting = l_Properties.GetItem(L"Ambient Lighting");

	if (l_AmbientLighting.IsValid())
	{
		Parameter l_Ambience = l_AmbientLighting.GetParameter(L"ambience");
		
		if (l_Ambience.IsValid())
		{
			Parameter l_ColorParameter = l_Ambience.GetParameter(L"red");
			if (l_ColorParameter.IsValid())
			{
				FTKUParameterAnimationFromXSI(in_pContext->ftkscene()->Ambience(), CSLFCurve::SI_COLOR_R, l_ColorParameter, m_pAnimationPlotter);
			}

			l_ColorParameter = l_Ambience.GetParameter(L"green");
			if (l_ColorParameter.IsValid())
			{
				FTKUParameterAnimationFromXSI(in_pContext->ftkscene()->Ambience(), CSLFCurve::SI_COLOR_G, l_ColorParameter, m_pAnimationPlotter);
			}

			l_ColorParameter = l_Ambience.GetParameter(L"blue");
			if (l_ColorParameter.IsValid())
			{
				FTKUParameterAnimationFromXSI(in_pContext->ftkscene()->Ambience(), CSLFCurve::SI_COLOR_B, l_ColorParameter, m_pAnimationPlotter);
			}
		}
	}

	return status;
};

CAnimationPlotter *CEnvironmentAnimationFromXSI::GetAnimationPlotter()
{
	return m_pAnimationPlotter;
}

void CEnvironmentAnimationFromXSI::SetAnimationPlotter(CAnimationPlotter *in_pAnimationPlotter)
{
	m_pAnimationPlotter = in_pAnimationPlotter;
}



/****************************************************************************************
CEnvironmentAnimationToXSI
****************************************************************************************/

CEnvironmentAnimationToXSI::CEnvironmentAnimationToXSI() {};

CEnvironmentAnimationToXSI::~CEnvironmentAnimationToXSI() {};

wchar_t *CEnvironmentAnimationToXSI::GetClassID() {	return L"CEnvironmentAnimationToXSI";};

CStatus CEnvironmentAnimationToXSI::Execute(CdotXSIConverter *in_pContext) 
{
	CStatus			status = CStatus::OK;
	Model			l_Root = in_pContext->scene().GetRoot();

	CRefArray l_Properties = l_Root.GetProperties();
	Property l_AmbientLighting = l_Properties.GetItem(L"Ambient Lighting");

	if (in_pContext->ftkscene()->Ambience() && l_AmbientLighting.IsValid() && in_pContext->ftkscene()->Ambience()->GetFCurveCount())
	{
		CParameterRefArray l_Parameters = l_AmbientLighting.GetParameters();
		Parameter l_Ambience = l_Parameters.GetItem(L"ambience");
		
		if (l_Ambience.IsValid())
		{
			CSLFCurve** l_ppFTKFCurve = in_pContext->ftkscene()->Ambience()->FCurves();
			LONG l_nFTKFCurveCount = in_pContext->ftkscene()->Ambience()->GetFCurveCount();

			for (LONG loop = 0; loop < l_nFTKFCurveCount; loop++)
			{
				FTKUParameterAnimationToXSI(l_ppFTKFCurve[loop], l_Parameters);
			}
		}
	}

	return status;
};



