//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file cnv_hierarchyelementinfo.cpp
/*!
	implementation file for hierarchy element information and filtering related classes
*/

#include "stdafx.h"
#include "cmdstubs.h"
#include "cnv_hierarchyelementinfo.h"
#include "plugin_stub.h"
#include "xsi_x3dobject.h"
#include "xsi_model.h"

#include <xsi_envelope.h>
#include <xsi_envelopeweight.h>
#include <xsi_geometryaccessor.h>
#include <XSIMesh.h>


/**************************************************************************************
CHierarchyElementInfoFromXSI
**************************************************************************************/
CHierarchyElementInfoFromXSI::CHierarchyElementInfoFromXSI(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype) {};

CHierarchyElementInfoFromXSI::~CHierarchyElementInfoFromXSI() {};

CStatus CHierarchyElementInfoFromXSI::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;

	if (*io_pXSIModel && in_pInfo)
	{
		ProjectItem l_XSIProjectItem = (ProjectItem)*io_pXSIModel;

		// try to find it in the m_CryExportNodesToExport list and if it's there, set it's selection to BRANCH_ROOT
		int loop;

		bool selected = false;
		short auxiliaryFileType = 0;
		for (loop = 0; loop < m_CryExportNodesToExport.GetCount(); loop++)
		{
			if (m_CryExportNodesToExport.GetItem(loop) == l_XSIProjectItem)
			{
				X3DObject l_CryExportNode(m_CryExportNodesToExport.GetItem(loop));

				in_pInfo->SetSelectionState(CHierarchyElementInfo::BRANCH_ROOT);
				in_pInfo->SetCryFiletype(GetCryExportNodeExportFiletype(l_CryExportNode));
				selected = true;
				auxiliaryFileType = GetCryExportNodeExportFiletype(l_CryExportNode);
				break;
			}
		}
		
		if ( in_pInfo->GetParent()
				  && ( (in_pInfo->GetParent()->GetSelectionState() != CHierarchyElementInfo::SINGLE)
				       && (in_pInfo->GetParent()->GetSelectionState() != CHierarchyElementInfo::UNSELECTED) ) )
		{
			in_pInfo->SetSelectionState(CHierarchyElementInfo::BRANCH_NODE);
			in_pInfo->SetCryFiletype(in_pInfo->GetParent()->GetCryFiletype());
			selected = true;
			auxiliaryFileType = in_pInfo->GetParent()->GetCryFiletype();
		}

		// If the object was selected, also remember the names of auxiliary nodes to export.
		if (selected)
			AddBonesToAuxiliaryList(in_pContext, io_pXSIModel, io_pFTKModel, auxiliaryFileType);
	}

	return status;
}

void CHierarchyElementInfoFromXSI::SetCryExportNodesToExport(CRefArray &in_CryExportNodesToExport)
{
	m_CryExportNodesToExport = in_CryExportNodesToExport;
}

CRefArray& CHierarchyElementInfoFromXSI::GetAuxiliaryNodesToExport()
{
	return m_AuxiliaryNodesToExport;
}

std::vector<short>& CHierarchyElementInfoFromXSI::GetAuxiliaryNodeFileTypes()
{
	return m_AuxiliaryNodeFileTypes;
}

void CHierarchyElementInfoFromXSI::AddBonesToAuxiliaryList(CdotXSIConverter *in_pContext, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel, short auxiliaryFileType)
{
	X3DObject XSIModel = (X3DObject) *io_pXSIModel;
	SceneItem XSISceneItem = (SceneItem)XSIModel;

	// validate some SDK objects
	if ( !XSISceneItem.IsValid()  )
		return;

	for (int envelopeIndex = 0, envelopeCount = XSISceneItem.GetEnvelopes().GetCount(); envelopeIndex < envelopeCount; ++envelopeIndex)
	{
		Envelope envelope(XSISceneItem.GetEnvelopes()[envelopeIndex]);
		CRefArray deformers = envelope.GetDeformers();
		for (int j = 0; j < deformers.GetCount(); ++j)
			m_AuxiliaryNodeFileTypes.push_back(auxiliaryFileType);
		m_AuxiliaryNodesToExport += deformers;

		for (int deformerIndex = 0, deformerCount = deformers.GetCount(); deformerIndex < deformerCount; ++deformerIndex)
		{
			CRef bone(deformers[deformerIndex]);

			if (bone.IsA(siX3DObjectID))
			{
				static const wchar_t* auxiliaryExtensions[] = {L"_Phys", L"_Phys_ParentFrame", 0};

				for (int i = 0; auxiliaryExtensions[i]; ++i)
				{
					X3DObject xobj(bone);
					CString name = xobj.GetName();
					CString auxName = name + CString(auxiliaryExtensions[i]);
					CStringArray emptyArray;
					CRefArray aux = in_pContext->scene().GetRoot().FindChildren(auxName, L"", emptyArray, true);
					for (int j = 0; j < aux.GetCount(); ++j)
						m_AuxiliaryNodeFileTypes.push_back(auxiliaryFileType);
					m_AuxiliaryNodesToExport += aux;
				}
			}
		}
	}
}

wchar_t *CHierarchyElementInfoFromXSI::GetClassID(){return L"CHierarchyElementInfoFromXSI";}

/**************************************************************************************
CAuxiliaryHierarchyElementInfoFromXSI
**************************************************************************************/
CAuxiliaryHierarchyElementInfoFromXSI::CAuxiliaryHierarchyElementInfoFromXSI(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype) {};

CAuxiliaryHierarchyElementInfoFromXSI::~CAuxiliaryHierarchyElementInfoFromXSI() {};

CStatus CAuxiliaryHierarchyElementInfoFromXSI::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;

	if (*io_pXSIModel && in_pInfo)
	{
		ProjectItem l_XSIProjectItem = (ProjectItem)*io_pXSIModel;

		// try to find it in the m_AuxiliaryNodesToExport list and if it's there, set it's selection to BRANCH_ROOT
		int loop;

		for (loop = 0; loop < m_AuxiliaryNodesToExport.GetCount(); loop++)
		{
			if (m_AuxiliaryNodesToExport.GetItem(loop) == l_XSIProjectItem)
			{
				short fileType = (*m_AuxiliaryNodeFileTypes)[loop];

				// Check whether the parent of this item is also in the export list.
				bool isRoot = true;

				ProjectItem l_XSIParentProjectItem = (ProjectItem)in_XSIParent;
				std::string test = l_XSIParentProjectItem.GetName().GetAsciiString();
				for (int i = 0, count = m_AuxiliaryNodesToExport.GetCount(); i < count; ++i)
				{
					if (m_AuxiliaryNodesToExport.GetItem(i) == l_XSIParentProjectItem)
						isRoot = false;
				}

				in_pInfo->SetSelectionState(isRoot ? CHierarchyElementInfo::BRANCH_ROOT : CHierarchyElementInfo::BRANCH_NODE);
				in_pInfo->SetCryFiletype(fileType);

				break;
			}
		}
	}

	return status;
}

void CAuxiliaryHierarchyElementInfoFromXSI::SetAuxiliaryNodesToExport(CRefArray &in_AuxiliaryNodesToExport, std::vector<short> &in_AuxiliaryNodeFileTypes)
{
	m_AuxiliaryNodesToExport = in_AuxiliaryNodesToExport;
	m_AuxiliaryNodeFileTypes = &in_AuxiliaryNodeFileTypes;
}

wchar_t *CAuxiliaryHierarchyElementInfoFromXSI::GetClassID(){return L"CAuxiliaryHierarchyElementInfoFromXSI";}

/**************************************************************************************
CHierarchyUpdateFTKModel
**************************************************************************************/
CHierarchyUpdateFTKModel::CHierarchyUpdateFTKModel(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype) {};

CHierarchyUpdateFTKModel::~CHierarchyUpdateFTKModel() {};

CStatus CHierarchyUpdateFTKModel::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;

	if (*io_pXSIModel && in_pInfo)
	{
		in_pInfo->SetFTKModel((CSLModel *)*io_pFTKModel);
	}

	return status;
}

wchar_t *CHierarchyUpdateFTKModel::GetClassID(){return L"CHierarchyUpdateFTKModel";}


