//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file cnv_hierarchyelementinfo.h
/*!
	definition file for hierarchy element info related classes
*/

#ifndef CNV_HIERARCHYELEMENTINFO_H
#define CNV_HIERARCHYELEMENTINFO_H


#include "Crosswalk/dotXSIConverterCallback.h"
#include "cnv_hierarchytraversal.h"
#include "Crosswalk/dotXSIConverter.h"
#include <vector>

//! class CHierarchyElementInfo
/*!
    class used to hold hierarchy element extra information used to specify if
	an element should be exported or not.
*/
class CHierarchyElementInfo
{
public:
	enum ESelectionState
	{
		UNSELECTED,
		SINGLE,
		BRANCH_ROOT,
		BRANCH_NODE,
	};

//! Default constructor
	CHierarchyElementInfo()
	{
		m_SelectionState = UNSELECTED;
		m_pNext = NULL;
		m_pParent = NULL;
		m_pFTKModel = NULL;
		m_CryFiletype = CRY_FILE_TYPE_NONE;
	}

//! Default destructor
	virtual ~CHierarchyElementInfo() {};

//! Sets the export state
/*!
	\param in_SelectionState the selection state
*/
	void SetSelectionState(ESelectionState in_SelectionState) { m_SelectionState = in_SelectionState; };

//! Returns the export state of an element (should this element be exported or not).
/*!
	\return CHierarchyElementInfo the export state
*/
	ESelectionState GetSelectionState() { return m_SelectionState; }

//! Sets the next CHierarchyElementInfo element in the list
/*!
	\param in_pNext the next CHierarchyElementInfo element in the list
*/
	void SetNext(CHierarchyElementInfo* in_pNext) { m_pNext = in_pNext; }

//! Returns the next CHierarchyElementInfo element in the list. Ordered in hierarchy parssing order.
/*!
	\return CHierarchyElementInfo pointer on the next element in the list
*/
	CHierarchyElementInfo* GetNext() { return m_pNext; }

//! Sets the parent CHierarchyElementInfo of the current element info
/*!
	\param in_pParent the parent CHierarchyElementInfo of the current element info
*/
	void SetParent(CHierarchyElementInfo* in_pParent) { m_pParent = in_pParent; }

//! Returns the parent CHierarchyElementInfo of this element.
/*!
	\return CHierarchyElementInfo pointer on the next parent's element info
*/
	CHierarchyElementInfo* GetParent() { return m_pParent; }

//! Sets the next FTK Model in the list
/*!
	\param in_pModel the next FTK Model in the list
*/
	void SetFTKModel(CSLModel* in_pModel) { m_pFTKModel = in_pModel; }

//! Returns the next FTK Model in the list. Ordered in hierarchy parssing order.
/*!
	\return CHierarchyElementInfo pointer on the next element in the list
*/
	CSLModel* GetFTKModel() { return m_pFTKModel; }

	void SetCryFiletype(short in_CryFiletype) { m_CryFiletype = in_CryFiletype; };
	short GetCryFiletype() {return m_CryFiletype;};

private:
	ESelectionState			m_SelectionState;
	CHierarchyElementInfo*	m_pNext;			// Next element in the list ordered in hierarchy parssing order.
	CHierarchyElementInfo*	m_pParent;			// element info of the parent element in the hierarchy
	CSLModel*				m_pFTKModel;		// the FTK model on this node
	short					m_CryFiletype;
};

//! class CHierarchyElementInfoFromXSI
/*!
    class that implements the pre processing task who fill the hierarchy element information
	required for export filter based on selected for example.
*/
class CHierarchyElementInfoFromXSI : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CHierarchyElementInfoFromXSI(short in_CryFiletype);

//! Default destructor
	virtual ~CHierarchyElementInfoFromXSI();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute( CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);


//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();

	void SetCryExportNodesToExport(CRefArray &in_CryExportNodesToExport);
	CRefArray& GetAuxiliaryNodesToExport();
	std::vector<short>& GetAuxiliaryNodeFileTypes();

private:

	void AddBonesToAuxiliaryList(CdotXSIConverter *in_pContext, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel, short auxiliaryFileType);

	CRefArray m_CryExportNodesToExport;
	CRefArray m_AuxiliaryNodesToExport;
	std::vector<short> m_AuxiliaryNodeFileTypes;
};

class CAuxiliaryHierarchyElementInfoFromXSI : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CAuxiliaryHierarchyElementInfoFromXSI(short in_CryFiletype);

//! Default destructor
	virtual ~CAuxiliaryHierarchyElementInfoFromXSI();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute( CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);


//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();

	void SetAuxiliaryNodesToExport(CRefArray &in_AuxiliaryNodesToExport, std::vector<short> &in_AuxiliaryNodeFileTypes);

private:

	CRefArray m_AuxiliaryNodesToExport;
	std::vector<short>* m_AuxiliaryNodeFileTypes;
};

//! class CHierarchyUpdateFTKModel
/*!
    class that implements the pre processing task who fill the hierarchy element information
	required for export filter based on selected for example.
*/
class CHierarchyUpdateFTKModel : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CHierarchyUpdateFTKModel(short in_CryFiletype);

//! Default destructor
	virtual ~CHierarchyUpdateFTKModel();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute( CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);


//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};

#endif // CNV_HIERARCHYELEMENTINFO_H
