//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file cnv_hierarchytraversal.h
/*!
	definition file for the hierarchy traverser callbacks
*/

#ifndef CNV_HIERARCHYTRAVERSAL_H
#define CNV_HIERARCHYTRAVERSAL_H



#include "Crosswalk/dotXSIConverterCallback.h"
#include "Crosswalk/dotXSIConverter.h"

//! class CHierarchyTraverserCallback
/*!
    base class for callbacks used in the hierarchy traversers
*/
class CHierarchyTraverserCallback
{
public:

//! Default constructor
	CHierarchyTraverserCallback(short in_CryFiletype);

//! Default destructor
	virtual ~CHierarchyTraverserCallback();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param in_pInfo the current Hierarchy Element Info
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();

	short GetCryFiletype() { return m_CryFiletype; };

private:
	short m_CryFiletype;
};

//! class CXSIHierarchyTraverser
/*!
    hierarchy traverser for XSI
*/
class CXSIHierarchyTraverser : public CdotXSIConverterCallback
{
public:
	enum ETraverserMode
	{
		SELECTED,
		ALL
	};

//! Default constructor
	CXSIHierarchyTraverser();

//! Default destructor
	virtual ~CXSIHierarchyTraverser();

//! Executes the callback
/*!
	\param in_pContext The converter context to be used in the execution
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	CSIBCArray<CHierarchyTraverserCallback*> &callbacks();

//! Returns the traverser mode
/*!
	\return CHierarchyElementInfoList* pointer on the hierarchy element info root node
*/
	ETraverserMode GetTraverserMode() { return m_eTraverserMode; }

	void SetTraverserMode( ETraverserMode in_eTraverserMode ) { m_eTraverserMode = in_eTraverserMode; }

private:

//! makes a traversal of the XSI scene and calls all callbacks on each model
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	CStatus Traverse(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

	CSIBCArray<CHierarchyTraverserCallback*>	m_CallbackList;

	ETraverserMode								m_eTraverserMode;

	CRef m_SubRoot;
};

//! class CFTKHierarchyTraverser
/*!
    hierarchy traverser for XSI
*/
class CFTKHierarchyTraverser : public CdotXSIConverterCallback
{
public:

//! Default constructor
	CFTKHierarchyTraverser();

//! Default destructor
	virtual ~CFTKHierarchyTraverser();

//! Executes the callback
/*!
	\param in_pContext The converter context to be used in the execution
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	CSIBCArray<CHierarchyTraverserCallback*> &callbacks();



private:

//! makes a traversal of the XSI scene and calls all callbacks on each model
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param in_pInfo the current Hierarchy Element Info
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	CStatus Traverse(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

	CSIBCArray<CHierarchyTraverserCallback*>	m_CallbackList;
};


//! class CSimpleXSILogging
/*!
    class definition for a simple XSI logging hierarchy traverser callback
*/
class CSimpleXSILogging : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CSimpleXSILogging(short in_CryFiletype);

//! Default destructor
	virtual ~CSimpleXSILogging();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};

//! class CSimpleFTKLogging
/*!
    class definition for a simple FTK logging hierarchy traverser callback
*/
class CSimpleFTKLogging : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CSimpleFTKLogging(short in_CryFiletype);

//! Default destructor
	virtual ~CSimpleFTKLogging();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};


#endif // CNV_HIERARCHYTRAVERSAL_H
