//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file cnv_ik.cpp
/*!
	implementation file for IK conversion
*/

#include "stdafx.h"
#include "cnv_ik.h"
#include <IK.h>
#include <IKRoot.h>
#include <IKJoint.h>
#include <IKEffector.h>
#include <cmdstubs.h>
#include <xsi_chainbone.h>
#include <xsi_chaineffector.h>
#include <xsi_chainelement.h>
#include <xsi_chainroot.h>
#include <xsi_joint.h>
#include <xsi_siobject.h>
#include <xsi_actionsource.h>
#include <xsi_clip.h>
#include <xsi_material.h>
#include <xsi_sceneitem.h>
#include <xsi_shader.h>
#include <xsi_source.h>
#include <xsi_property.h>
#include "plugin_stub.h"

/**************************************************************************************
CIKFromXSI
**************************************************************************************/
CIKFromXSI::CIKFromXSI(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype) {};

CIKFromXSI::~CIKFromXSI() {};

CStatus CIKFromXSI::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;
	X3DObject XSIModel = (X3DObject) *io_pXSIModel;

	// CHAIN ROOT 
	if(wcscmp(XSIModel.GetType().GetWideString(), L"root") == 0)
	{
		CSLModel	*l_pParent = (CSLModel *) in_pFTKParent;
		ChainRoot	l_Root = (ChainRoot) XSIModel;
		CSLModel	*l_pNewIKRoot = l_pParent->AddIKRoot();

		*io_pFTKModel = l_pNewIKRoot;
		l_pNewIKRoot->AttachUserData("CREF", in_pContext->AddCRef(*io_pXSIModel));
		
		// parameters
		// no parameters for root

		// Attempt to connect the effector, this will work if the effector exists
		ChainEffector l_Effector = l_Root.GetEffector();
		CSLModel* l_pXSIEffector = in_pContext->FindModelByCRef(in_pContext->ftkscene()->Root(), l_Effector);
		if(l_pXSIEffector)
		{
			CSLIKEffector *l_pEffectorPrim = (CSLIKEffector *) l_pXSIEffector->Primitive();
			l_pEffectorPrim->ConnectRoot(l_pNewIKRoot);		
			((CSLIKRoot*) l_pNewIKRoot->Primitive())->ConnectEffector(l_pXSIEffector);
		}
	}	
	// CHAIN BONE
	else if(wcscmp(XSIModel.GetType().GetWideString(), L"bone") == 0)
	{
		CSLModel	*l_pParent = (CSLModel *) in_pFTKParent;
		ChainBone	l_Bone = (ChainBone) XSIModel;
		CSLModel	*l_pNewIKJoint = l_pParent->AddIKJoint();
		
		*io_pFTKModel = l_pNewIKJoint;
		l_pNewIKJoint->AttachUserData("CREF", in_pContext->AddCRef(*io_pXSIModel));

		CSLIKJoint *l_pJoint = (CSLIKJoint*) l_pNewIKJoint->Primitive();

		// joint and bone parameters
		CParameterRefArray l_BoneParams = l_Bone.GetParameters();
		CParameterRefArray l_JointParams = l_Bone.GetJoint().GetParameters();

		l_pJoint->SetLength(l_BoneParams.GetValue(L"length", 0));
		{
			 CSIBCVector3D l_vector(in_pContext->AngleToFTK(l_JointParams.GetValue(L"prefrotx", 0), false), 
						in_pContext->AngleToFTK(l_JointParams.GetValue(L"prefroty", 0), false), 
						in_pContext->AngleToFTK(l_JointParams.GetValue(L"prefrotz", 0), false));
			 l_pJoint->SetPreferredRotation(l_vector);
		}

		l_pJoint->SetPseudoRoot(l_JointParams.GetValue(L"pseudoroot_active", 0));
		l_pJoint->SetRotationLimitActivation(l_JointParams.GetValue(L"rotlim_active", 0));
		{
			CSIBCVector3D l_vector(in_pContext->AngleToFTK(l_JointParams.GetValue(L"rotminx", 0), false), 
					       in_pContext->AngleToFTK(l_JointParams.GetValue(L"rotminy", 0), false), 
					       in_pContext->AngleToFTK(l_JointParams.GetValue(L"rotminz", 0), false));
			l_pJoint->SetRotationLimitMaximum(l_vector);
		}

		{
			CSIBCVector3D l_vector(in_pContext->AngleToFTK(l_JointParams.GetValue(L"rotmaxx", 0), false), 
					       in_pContext->AngleToFTK(l_JointParams.GetValue(L"rotmaxy", 0), false), 
					       in_pContext->AngleToFTK(l_JointParams.GetValue(L"rotmaxz", 0), false));
			l_pJoint->SetRotationLimitMinimum(l_vector);
		}

		l_pJoint->SetSolverType( (CSLIKJoint::EJointSolverType) ((int)l_JointParams.GetValue(L"chntype", 0)));
		l_pJoint->SetStiffness( l_JointParams.GetValue(L"stiffness", 0));
		l_pJoint->SetStiffnessActivation( l_JointParams.GetValue(L"stiffness_active", 0));
			
		LONG Format = in_pContext->exportproperty().GetParameterValue (L"format");

		if((Format != DOTXSI_FORMAT_5_0) && (Format != DOTXSI_FORMAT_5_0_BINARY))
		{
			CSLIKResolutionPlane* l_pResPlane = l_pJoint->CreateResolutionPlane();
			l_pResPlane->SetResolutionPlaneType((CSLIKResolutionPlane::EIKResPlaneType) ((int) l_JointParams.GetValue(L"resplane", 0)));
			l_pResPlane->SetRoll(in_pContext->AngleToFTK(l_JointParams.GetValue(L"roll", 0), false));

			l_pResPlane->SetPrefRotXAsRoll(l_JointParams.GetValue(L"prefrotx_as_roll", 0));
			{
				CSIBCVector3D l_vector(l_JointParams.GetValue(L"upx", 0), l_JointParams.GetValue(L"upy", 0), l_JointParams.GetValue(L"upz", 0));
				l_pResPlane->SetUpVector(l_vector);
			}
			l_pResPlane->SetUpVectorRelativeToRoot(l_JointParams.GetValue(L"upvct_relroot", 0));
			{
				CSIBCVector3D l_vector(in_pContext->AngleToFTK(l_JointParams.GetValue(L"prefx", 0), false), 
						       in_pContext->AngleToFTK(l_JointParams.GetValue(L"prefy", 0), false), 
						       in_pContext->AngleToFTK(l_JointParams.GetValue(L"prefz", 0), false));
				l_pResPlane->SetPreferredRotation(l_vector);
			}
			l_pResPlane->SetPreferredRotationRelativeToRoot(l_JointParams.GetValue(L"pref_relroot", 0));
		}		

	}	
	// CHAIN EFFECTOR
	else if(wcscmp(XSIModel.GetType().GetWideString(), L"eff") == 0)
	{
		CSLModel		*l_pParent = (CSLModel *) in_pFTKParent;
		ChainEffector	l_Effector = (ChainEffector) XSIModel;
		CSLModel		*l_pNewIKEffector = NULL;

		l_pNewIKEffector = l_pParent->AddIKEffector();
		
		*io_pFTKModel = l_pNewIKEffector;
		l_pNewIKEffector->AttachUserData("CREF", in_pContext->AddCRef(*io_pXSIModel));

		// Attempt to connect the effector, this will work if the root already exists
		ChainRoot l_Root = l_Effector.GetRoot();
		CSLModel* l_pXSIRoot = in_pContext->FindModelByCRef(in_pContext->ftkscene()->Root(), l_Root);
		if(l_pXSIRoot)
		{
			CSLIKEffector *l_pEffectorPrim = (CSLIKEffector *) l_pNewIKEffector->Primitive();

			ChainBone l_FirstBone = l_Root.GetBones()[0];
			l_pEffectorPrim->SetRotationFlag(XSI::COMMANDS::GetValue(l_FirstBone.GetFullName() + L".chain.effori", 0));
			l_pEffectorPrim->ConnectRoot(l_pXSIRoot);
			((CSLIKRoot*) l_pXSIRoot->Primitive())->ConnectEffector(l_pNewIKEffector);
		}
	}

	return status;
}

wchar_t *CIKFromXSI::GetClassID(){return L"CIKFromXSI";}

/**************************************************************************************
CIKToXSI
**************************************************************************************/
CIKToXSI::CIKToXSI(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype) {};

CIKToXSI::~CIKToXSI() {};

CStatus CIKToXSI::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;

	static double lastX,lastY,lastZ;

	if (*io_pFTKModel)
	{
		CSLModel *l_pFTKModel = (CSLModel *)(*io_pFTKModel);

		if (l_pFTKModel->Primitive() && l_pFTKModel->Primitive()->Type() == CSLTemplate::SI_IK_ROOT)
		{
			CSLIKRoot* l_pIKRoot = (CSLIKRoot*)l_pFTKModel->Primitive();

			X3DObject	l_XSIParent = (X3DObject) in_XSIParent;
	
			CString l_Name;
			l_Name.PutAsciiString(l_pFTKModel->GetName());

			ChainRoot l_ChainRoot;

			CSLModel*	l_pFirstJoint = l_pIKRoot->GetJointList()[0];
			CSLIKJoint*	l_pFirstJointPrim = (CSLIKJoint *) l_pFirstJoint->Primitive();
			
			// compute the vector based on the preferred rotation 
			MATH::CVector3 l_BoneDirection(0,0,1);
			CSIBCVector3D l_PrefRot = l_pFirstJointPrim->GetPreferredRotation();
			MATH::CTransformation l_BoneTransformation;

			l_BoneTransformation.SetRotationFromXYZAngles(MATH::CVector3(
				in_pContext->AngleFromFTK(l_PrefRot.m_fX, true), 
				in_pContext->AngleFromFTK(l_PrefRot.m_fY, true), 
				in_pContext->AngleFromFTK(l_PrefRot.m_fZ, true)));

			l_BoneDirection.MulByTransformationInPlace(l_BoneTransformation);
			lastX = l_BoneDirection.GetX();
			lastY = l_BoneDirection.GetY();
			lastZ = l_BoneDirection.GetZ();
		
/* not sure if this is better, but if there are any artifacts try it out
			if(l_pFirstJointPrim->GetSolverType() == CSLIKJoint::SI_2D)
			{
				_XSI_CALL(l_XSIParent.Add2DChain(MATH::CVector3(0,0,0), l_BoneDirection, MATH::CVector3(0,1,0),si2DChainNormalRadian, l_Name, l_ChainRoot), L"Failed to add a Mesh object");
			}
			else if(l_pFirstJointPrim->GetSolverType() == CSLIKJoint::SI_3D)
			{
				_XSI_CALL(l_XSIParent.Add3DChain(MATH::CVector3(0,0,0), l_BoneDirection, MATH::CVector3(0,1,0),l_Name, l_ChainRoot), L"Failed to add a Mesh object");
			}
*/ 
			_XSI_CALL(l_XSIParent.Add3DChain(MATH::CVector3(0,0,0), l_BoneDirection, MATH::CVector3(0,1,0),l_Name, l_ChainRoot), L"Failed to add an IK chain");

			CString l_JointName;
			l_JointName.PutAsciiString(l_pFirstJointPrim->GetName());
			ChainBone l_FirstBone = l_ChainRoot.GetBones()[0];
			l_FirstBone.PutName(l_JointName);

			*io_pXSIModel = l_ChainRoot;
			l_pFTKModel->AttachUserData("CREF", in_pContext->AddCRef(l_ChainRoot));
		}
		else if (l_pFTKModel->Primitive() && l_pFTKModel->Primitive()->Type() == CSLTemplate::SI_IK_JOINT)
		{
			CSLIKJoint* l_pIKJoint = (CSLIKJoint*)l_pFTKModel->Primitive();

			X3DObject	l_XSIParent = (X3DObject) in_XSIParent;
	
			CString l_Name;
			l_Name.PutAsciiString(l_pFTKModel->GetName());

			ChainBone l_ChainBone;

			// check and see if there is a chain bone with the same name already
			CSIBCUserData *l_pUserData = l_pIKJoint->GetRoot()->FindUserData("CREF");
			if(l_pUserData)
			{
				ChainRoot l_ChainRoot = (ChainRoot) *((CRef*) l_pUserData->GetData());
				if(l_ChainRoot.IsValid())
				{
					int loop;
					CRefArray l_Bones = l_ChainRoot.GetBones();
					for(loop = 0; loop < l_Bones.GetCount(); loop++)
					{
						ChainBone l_Bone = (ChainBone) l_Bones[loop];
						if(l_Bone.GetName() == l_Name)
						{
							l_ChainBone = l_Bone;
							break;
						}
					}

					if(l_ChainBone.IsValid() == false)
					{
						// compute the vector based on the preferred rotation 
						MATH::CVector3 l_BoneDirection(0,0,1);
						CSIBCVector3D l_PrefRot = l_pIKJoint->GetPreferredRotation();
						MATH::CTransformation l_BoneTransformation;

						l_BoneTransformation.SetRotationFromXYZAngles(MATH::CVector3(
							in_pContext->AngleFromFTK(l_PrefRot.m_fX, true), 
							in_pContext->AngleFromFTK(l_PrefRot.m_fY, true), 
							in_pContext->AngleFromFTK(l_PrefRot.m_fZ, true)));
			
						l_BoneDirection.MulByTransformationInPlace(l_BoneTransformation);
						l_BoneDirection.AddInPlace(MATH::CVector3(lastX,lastY,lastZ));

						lastX = l_BoneDirection.GetX();
						lastY = l_BoneDirection.GetY();
						lastZ = l_BoneDirection.GetZ();

						l_ChainRoot.AddBone( l_BoneDirection, siChainBoneBallJoint, l_Name, l_ChainBone);
					}

					*io_pXSIModel = l_ChainBone;
					l_pFTKModel->AttachUserData("CREF", in_pContext->AddCRef(l_ChainBone));

					// parameters
					CParameterRefArray l_BoneParams = l_ChainBone.GetParameters();
					CParameterRefArray l_JointParams = l_ChainBone.GetJoint().GetParameters();

					l_JointParams.PutValue(L"chntype", CValue(l_pIKJoint->GetSolverType()), 0);
					l_BoneParams.PutValue(L"length", CValue(l_pIKJoint->GetLength()));

					CSIBCVector3D	l_FTKVector;

					CSLIKResolutionPlane* l_pResPlane = l_pIKJoint->GetResolutionPlane();
					if(l_pResPlane)
					{
						l_JointParams.PutValue(L"resplane", CValue(l_pResPlane->GetResolutionPlaneType()), 0);
						l_JointParams.PutValue(L"roll", CValue(in_pContext->AngleFromFTK(l_pResPlane->GetRoll(), false)), 0);
						l_JointParams.PutValue(L"prefrotx_as_roll", CValue(l_pResPlane->GetPrefRotXAsRoll()), 0);

						l_FTKVector = l_pResPlane->GetUpVector();
						l_JointParams.PutValue(L"upx", CValue(l_FTKVector.m_fX), 0);
						l_JointParams.PutValue(L"upy", CValue(l_FTKVector.m_fY), 0);
						l_JointParams.PutValue(L"upz", CValue(l_FTKVector.m_fZ), 0);


						l_JointParams.PutValue(L"upvct_relroot", CValue(l_pResPlane->GetUpVectorRelativeToRoot()), 0);

						l_FTKVector = l_pResPlane->GetPreferredRotation();
						l_JointParams.PutValue(L"prefx", CValue(in_pContext->AngleFromFTK(l_FTKVector.m_fX, false)), 0);
						l_JointParams.PutValue(L"prefy", CValue(in_pContext->AngleFromFTK(l_FTKVector.m_fY, false)), 0);
						l_JointParams.PutValue(L"prefz", CValue(in_pContext->AngleFromFTK(l_FTKVector.m_fZ, false)), 0);
						l_JointParams.PutValue(L"pref_relroot", CValue(l_pResPlane->GetPreferredRotationRelativeToRoot()), 0);
					}

					l_FTKVector = l_pIKJoint->GetPreferredRotation();
					l_JointParams.PutValue(L"prefrotx", CValue(in_pContext->AngleFromFTK(l_FTKVector.m_fX, false)), 0);
					l_JointParams.PutValue(L"prefroty", CValue(in_pContext->AngleFromFTK(l_FTKVector.m_fY, false)), 0);
					l_JointParams.PutValue(L"prefrotZ", CValue(in_pContext->AngleFromFTK(l_FTKVector.m_fZ, false)), 0);

					l_JointParams.PutValue(L"pseudoroot_active", CValue(l_pIKJoint->GetPseudoRoot()), 0);
					l_JointParams.PutValue(L"rotlim_active", CValue(l_pIKJoint->GetRotationLimitActivation()), 0);

					l_FTKVector = l_pIKJoint->GetRotationLimitMaximum();
					l_JointParams.PutValue(L"rotminx", CValue(in_pContext->AngleFromFTK(l_FTKVector.m_fX, false)), 0);
					l_JointParams.PutValue(L"rotminy", CValue(in_pContext->AngleFromFTK(l_FTKVector.m_fY, false)), 0);
					l_JointParams.PutValue(L"rotminz", CValue(in_pContext->AngleFromFTK(l_FTKVector.m_fZ, false)), 0);

					l_FTKVector = l_pIKJoint->GetRotationLimitMinimum();
					l_JointParams.PutValue(L"rotmaxx", CValue(in_pContext->AngleFromFTK(l_FTKVector.m_fX, false)), 0);
					l_JointParams.PutValue(L"rotmaxy", CValue(in_pContext->AngleFromFTK(l_FTKVector.m_fY, false)), 0);
					l_JointParams.PutValue(L"rotmaxz", CValue(in_pContext->AngleFromFTK(l_FTKVector.m_fZ, false)), 0);

					l_JointParams.PutValue(L"stiffness", CValue(l_pIKJoint->GetStiffness()), 0);
					l_JointParams.PutValue(L"stiffness_active", CValue(l_pIKJoint->GetStiffnessActivation()), 0);

				}
			}
		}
		else if (l_pFTKModel->Primitive() && l_pFTKModel->Primitive()->Type() == CSLTemplate::SI_IK_EFFECTOR)
		{
			CSLIKEffector* l_pIKEffector = (CSLIKEffector*)l_pFTKModel->Primitive();

			X3DObject	l_XSIParent = (X3DObject) in_XSIParent;
	
			CString l_Name;
			l_Name.PutAsciiString(l_pFTKModel->GetName());

			ChainEffector l_ChainEffector;

			// check and see if there is a chain effector with the same name already
			CSIBCUserData *l_pUserData = l_pIKEffector->GetRoot()->FindUserData("CREF");
			if(l_pUserData)
			{
				ChainRoot l_ChainRoot = (ChainRoot) *((CRef*) l_pUserData->GetData());
				if(l_ChainRoot.IsValid())
				{
					l_ChainEffector = l_ChainRoot.GetEffector();

					ChainBone l_FirstBone = l_ChainRoot.GetBones()[0];
					XSI::COMMANDS::SetValue(l_FirstBone.GetFullName() + L".chain.effori", l_pIKEffector->GetRotationFlag(), 0);

					*io_pXSIModel = l_ChainEffector;
					l_pFTKModel->AttachUserData("CREF", in_pContext->AddCRef(l_ChainEffector));
				}
			}
		}
	}
	return status;
}

wchar_t *CIKToXSI::GetClassID(){return L"CIKToXSI";}

/**************************************************************************************
CActivateXSIIK
**************************************************************************************/
CActivateXSIIK::CActivateXSIIK(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype) {};

CActivateXSIIK::~CActivateXSIIK() {};

CStatus CActivateXSIIK::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;

	ChainBone l_ChainBone = (ChainBone) *io_pXSIModel;

	// mute the IK
	Property l_ChainProperty = l_ChainBone.GetProperties().GetItem(L"Kinematic Chain");
	if(l_ChainProperty.IsValid())
	{
		l_ChainProperty.PutParameterValue(L"muteikop", CValue(false));
	}

	return status;
}

wchar_t *CActivateXSIIK::GetClassID(){return L"CActivateXSIIK";}

/**************************************************************************************
CDeactivateXSIIK
**************************************************************************************/
CDeactivateXSIIK::CDeactivateXSIIK(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype) {};

CDeactivateXSIIK::~CDeactivateXSIIK() {};

CStatus CDeactivateXSIIK::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;

	ChainBone l_ChainBone = (ChainBone) *io_pXSIModel;

	// mute the IK
	Property l_ChainProperty = l_ChainBone.GetProperties().GetItem(L"Kinematic Chain");
	if(l_ChainProperty.IsValid())
	{
		l_ChainProperty.PutParameterValue(L"muteikop", CValue(true));
	}

	return status;
}

wchar_t *CDeactivateXSIIK::GetClassID(){return L"CDeactivateXSIIK";}
