//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file cnv_image.h
/*!
	definition file for image classes
*/

#ifndef CNV_IMAGE_H
#define CNV_IMAGE_H



#include "Crosswalk/dotXSIConverterCallback.h"
#include "cnv_hierarchytraversal.h"
#include "Crosswalk/dotXSIConverter.h"

//! class CXSIImageLibraryFromXSI
/*!
    definition for the conversion of image libraries from XSI
*/
class CXSIImageLibraryFromXSI : public CdotXSIConverterCallback
{
public:

//! Default constructor
	CXSIImageLibraryFromXSI();

//! Default destructor
	virtual ~CXSIImageLibraryFromXSI();

//! Executes the callback
/*!
	\param in_pContext The converter context to be used in the execution
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};

//! class CXSIImageLibraryFromXSI_RemoveUnused
/*!
    definition for the cleanup of unused image in the library
*/
class CXSIImageLibraryFromXSI_RemoveUnused : public CdotXSIConverterCallback
{
public:

//! Default constructor
	CXSIImageLibraryFromXSI_RemoveUnused();

//! Default destructor
	virtual ~CXSIImageLibraryFromXSI_RemoveUnused();

//! Executes the callback
/*!
	\param in_pContext The converter context to be used in the execution
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};

//! class CXSIImageFromXSI
/*!
    definition for the conversion of image clips from XSI
*/
class CXSIImageFromXSI : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CXSIImageFromXSI(short in_CryFiletype);

//! Default destructor
	virtual ~CXSIImageFromXSI();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute( CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};


//! class CXSIImageLibraryToXSI
/*!
    definition for the conversion of image libraries to XSI
*/
class CXSIImageLibraryToXSI : public CdotXSIConverterCallback
{
public:

//! Default constructor
	CXSIImageLibraryToXSI();

//! Default destructor
	virtual ~CXSIImageLibraryToXSI();

//! Executes the callback
/*!
	\param in_pContext The converter context to be used in the execution
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};

//! class CXSIImageToXSI
/*!
    definition for the conversion of image clips to XSI
*/
class CXSIImageToXSI : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CXSIImageToXSI(short in_CryFiletype);

//! Default destructor
	virtual ~CXSIImageToXSI();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute( CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};


#endif // CNV_IMAGE_H
