//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/****************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/

/*! \file cnv_info.h   
    Definition file for the dotXSI info classes
*/

#ifndef CNV_SCENEINFO_H_
#define CNV_SCENEINFO_H_

#include "Crosswalk/dotXSIConverterCallback.h"
#include "Crosswalk/dotXSIConverter.h"
#include <xsi_progressbar.h>

//! Class CSceneInfoFromXSI
/*!
    This is the class that implements setting the dotXSI information of the FTK content
*/
class CSceneInfoFromXSI : public CdotXSIConverterCallback
{
public:

//! Default constructor
	CSceneInfoFromXSI();

//! Default destructor
	virtual ~CSceneInfoFromXSI();

//! Executes the callback
/*!
	\param in_pContext The converter context to be used in the execution
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};

//! Class CSceneInfoToXSI
/*!
    This is the class that implements setting the dotXSI information of the FTK content
*/
class CSceneInfoToXSI : public CdotXSIConverterCallback
{
public:

//! Default constructor
	CSceneInfoToXSI();

//! Default destructor
	virtual ~CSceneInfoToXSI();

//! Executes the callback
/*!
	\param in_pContext The converter context to be used in the execution
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};

//! class CProcessTimer
/*!
    definition for a timer class
*/
class CProcessTimer : public CdotXSIConverterCallback
{
public:

//! Default constructor
/*!
	\param in_pMessage the message to print on execute
*/
	CProcessTimer(wchar_t *in_pMessage);

//! Default destructor
	virtual ~CProcessTimer();

//! Executes the callback
/*!
	\param in_pContext The converter context to be used in the execution
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();


//! resets the timer
/*!
	\return void
*/
	static void	Reset();

//! resets the tasks
/*!
	\return void
*/
	static void	ResetTasks();

//! show a subtitle on the progressbar
/*!
	\param CString The subtitle
	\return void
*/
	void ShowSubtitle ( CString in_Subtitle );

private:

	CString				m_Message;
	static LONG			m_start;
	static LONG			m_current;
	static LONG			m_lasttime;
	static LONG			m_NumberOfTasks;
	static LONG			m_CurrentTask;
	static ProgressBar	m_ProgressBar;
	static bool			m_Interactive;

};




#endif CNV_SCENEINFO_H_