//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file cnv_instance.h
/*!
	definition file for instance related classes
*/

#ifndef CNV_INSTANCE_H
#define CNV_INSTANCE_H


#include "Crosswalk/dotXSIConverterCallback.h"
#include "cnv_hierarchytraversal.h"
#include "Crosswalk/dotXSIConverter.h"


//! class CInstanceFromXSI
/*!
    class definition the callback that populate a INSTANCE model from XSI
*/
class CInstanceFromXSI : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CInstanceFromXSI(short in_CryFiletype);

//! Default destructor
	virtual ~CInstanceFromXSI();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute( CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};

//! class CInstanceToXSI
/*!
    class definition the callback that populate a INSTANCE model to XSI
*/
class CInstanceToXSI : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CInstanceToXSI(short in_CryFiletype);

//! Default destructor
	virtual ~CInstanceToXSI();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute( CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};

//! class CUnresolvedInstanceToXSI
/*!
    class definition the callback that populate a INSTANCE model to XSI
*/
class CUnresolvedInstanceToXSI : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CUnresolvedInstanceToXSI(short in_CryFiletype);

//! Default destructor
	virtual ~CUnresolvedInstanceToXSI();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute( CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};

#endif // CNV_INSTANCE_H
