//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file cnv_material_anim.cpp
/*!
	implementation file for material animation classes
*/

#include "stdafx.h"
#include "cnv_material_anim.h"
#include "cnv_custompset_anim.h"
#include <xsi_material.h>
#include <xsi_shader.h>

#include <MaterialLibrary.h>
#include <XSIMaterial.h>
#include <XSIShader.h>
#include "../FTKUtil.h"
#include "cmdstubs.h"

/**************************************************************************************
CMaterialLibraryAnimationFromXSI
**************************************************************************************/
CMaterialLibraryAnimationFromXSI::CMaterialLibraryAnimationFromXSI() 
{
	m_pAnimationPlotter = NULL;
};

CMaterialLibraryAnimationFromXSI::~CMaterialLibraryAnimationFromXSI() {};

CStatus CMaterialLibraryAnimationFromXSI::Execute(CdotXSIConverter *in_pContext)
{
	CStatus status = CStatus::OK;
	CSLMaterialLibrary *l_pFTKMaterialLibrary = in_pContext->ftkscene()->GetMaterialLibrary();
	CSLBaseMaterial** l_ppFTKMaterialList = l_pFTKMaterialLibrary->GetMaterialList();
	LONG l_nFTKMaterialCount = l_pFTKMaterialLibrary->GetMaterialCount();

	for (LONG loop = 0; loop < l_nFTKMaterialCount; loop++)
	{
		if (l_ppFTKMaterialList[loop]->Type() == CSLTemplate::XSI_MATERIAL)
		{
			CSLXSIMaterial* l_pFTKMaterial = (CSLXSIMaterial*)l_ppFTKMaterialList[loop];
			CSLTemplate* l_pFTKMaterialTempalte = l_pFTKMaterial;

			Material l_XSIMaterial;
			
			CSIBCUserData *l_pUserData = l_pFTKMaterial->FindUserData("CREF");
			if(l_pUserData)
			{
				CRef *l_pCRef = (CRef*)(l_pUserData->GetData());
				l_XSIMaterial = (Material) *l_pCRef;

				// grab it's custom psets animation
				CCustomPSetAnimationFromXSI l_CustomPSetAnimationConverter(CRY_FILE_TYPE_NONE);
				_XSI_CALL(l_CustomPSetAnimationConverter.Execute(in_pContext, CRef(), NULL, NULL, l_pCRef, &l_pFTKMaterialTempalte), L"Failed to convert custom pset animation");

				for(LONG loop2 = 0; loop2 < l_pFTKMaterial->GetShaderCount(); loop2++)
				{
					CSLXSIShader *l_pFTKShader = l_pFTKMaterial->GetShaderList()[loop2];
					CSLTemplate* l_pFTKShaderTempalte = l_pFTKShader;

					l_pUserData = l_pFTKShader->FindUserData("CREF");

					if(l_pUserData)
					{
						l_pCRef = (CRef*)(l_pUserData->GetData());
						Shader l_XSIShader = (Shader) *l_pCRef;

						// grab it's custom psets animation
						_XSI_CALL(l_CustomPSetAnimationConverter.Execute(in_pContext, CRef(), NULL, NULL, l_pCRef, &l_pFTKShaderTempalte), L"Failed to convert custom pset animation");

						CRefArray l_Parameters = l_XSIShader.GetParameters();

						for(LONG loop3 = 0; loop3 < l_Parameters.GetCount(); loop3 ++)
						{
							Parameter	l_Parameter = l_Parameters.GetItem(loop3);

							LONG		l_ParamCount = 1;
							CRefArray	l_SubParameterCollection;
							Parameter	l_CurrentParameter = l_Parameter;
							bool		l_bIsCompound = FALSE;


							// check if we are dealing with a compound parameter
							// NOTE: we only support one level of nesting here
							if(l_Parameter.IsA(siCompoundParameterID))
							{
								l_bIsCompound = TRUE;
								l_SubParameterCollection = l_Parameter.GetParameters();
								l_ParamCount = l_SubParameterCollection.GetCount();
							}

							for(LONG loop4 = 0; loop4 < l_ParamCount; loop4++)
							{
								CString l_ParameterName = l_Parameter.GetScriptName();

								if(l_bIsCompound)
								{
									l_CurrentParameter = l_SubParameterCollection.GetItem(loop4);
									l_ParameterName += CString(L".");
									l_ParameterName += l_CurrentParameter.GetScriptName();
								}

								const char *l_pTemp = l_ParameterName.GetAsciiString();

								FTKUParameterAnimationFromXSI(l_pFTKShader, CSLFCurve::SI_PARAMETER, l_CurrentParameter, m_pAnimationPlotter, l_ParameterName);
							}
						}
					}
				}
			}
		}
	}

	return status;
}

wchar_t *CMaterialLibraryAnimationFromXSI::GetClassID(){return L"CMaterialLibraryAnimationFromXSI";}

CAnimationPlotter *CMaterialLibraryAnimationFromXSI::GetAnimationPlotter()
{
	return m_pAnimationPlotter;
}

void CMaterialLibraryAnimationFromXSI::SetAnimationPlotter(CAnimationPlotter *in_pAnimationPlotter)
{
	m_pAnimationPlotter = in_pAnimationPlotter;
}



/**************************************************************************************
CMaterialLibraryAnimationToXSI
**************************************************************************************/
CMaterialLibraryAnimationToXSI::CMaterialLibraryAnimationToXSI() {};

CMaterialLibraryAnimationToXSI::~CMaterialLibraryAnimationToXSI() {};

CStatus CMaterialLibraryAnimationToXSI::Execute(CdotXSIConverter *in_pContext)
{
	CStatus status = CStatus::OK;

	CSLMaterialLibrary *l_pFTKMaterialLibrary = in_pContext->ftkscene()->GetMaterialLibrary();
	CSLBaseMaterial** l_ppFTKMaterialList = l_pFTKMaterialLibrary->GetMaterialList();
	LONG l_nFTKMaterialCount = l_pFTKMaterialLibrary->GetMaterialCount();

	for (LONG loop = 0; loop < l_nFTKMaterialCount; loop++)
	{
		if (l_ppFTKMaterialList[loop]->Type() == CSLTemplate::XSI_MATERIAL)
		{
			CSLXSIMaterial* l_pFTKMaterial = (CSLXSIMaterial*)l_ppFTKMaterialList[loop];
			CSLTemplate* l_pFTKMaterialTempalte = l_pFTKMaterial;

			Material l_XSIMaterial;
			
			CSIBCUserData *l_pUserData = l_pFTKMaterial->FindUserData("CREF");
			if(l_pUserData)
			{
				CRef *l_pCRef = (CRef*)(l_pUserData->GetData());
				l_XSIMaterial = (Material) *l_pCRef;

				// grab it's custom psets animation
				CCustomPSetAnimationToXSI l_CustomPSetAnimationConverter(CRY_FILE_TYPE_NONE);
				_XSI_CALL(l_CustomPSetAnimationConverter.Execute(in_pContext, CRef(), NULL, NULL, l_pCRef, &l_pFTKMaterialTempalte), L"Failed to convert custom pset animation");

				for(LONG loop2 = 0; loop2 < l_pFTKMaterial->GetShaderCount(); loop2++)
				{
					CSLXSIShader* l_pFTKShader = l_pFTKMaterial->GetShaderList()[loop2];
					CSLTemplate* l_pFTKShaderTempalte = l_pFTKShader;

					l_pUserData = l_pFTKShader->FindUserData("CREF");
					if(l_pUserData && l_pFTKShader->GetFCurveCount())
					{
						l_pCRef = (CRef*)(l_pUserData->GetData());
						Shader l_XSIShader = (Shader) *l_pCRef;

						// grab it's custom psets animation
						_XSI_CALL(l_CustomPSetAnimationConverter.Execute(in_pContext, CRef(), NULL, NULL, l_pCRef, &l_pFTKShaderTempalte), L"Failed to convert custom pset animation");

						CSLFCurve** l_ppFCurve = l_pFTKShader->FCurves();
						LONG l_nFCurveCount = l_pFTKShader->GetFCurveCount();
						CParameterRefArray l_Parameters = l_XSIShader.GetParameters();

						for (LONG loop3 = 0; loop3 < l_nFCurveCount; loop3++)
						{
							FTKUParameterAnimationToXSI(l_ppFCurve[loop3], l_Parameters);
						}
					}
				}
			}
		}
	}

	return status;
}

wchar_t *CMaterialLibraryAnimationToXSI::GetClassID(){return L"CMaterialLibraryAnimationToXSI";}

