//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file cnv_material_anim.h
/*!
	definition file for material animation classes
*/

#ifndef CNV_MATERIAL_ANIM_H
#define CNV_MATERIAL_ANIM_H

#include "Crosswalk/dotXSIConverterCallback.h"
#include "cnv_hierarchytraversal.h"
#include "Crosswalk/dotXSIConverter.h"
#include "cnv_plottedanimation.h"

//! class CMaterialLibraryAnimationFromXSI
/*!
    callback that implements getting material libraries animation from XSI
*/
class CMaterialLibraryAnimationFromXSI : public CdotXSIConverterCallback
{
public:

//! Default constructor
	CMaterialLibraryAnimationFromXSI();

//! Default destructor
	virtual ~CMaterialLibraryAnimationFromXSI();

//! Executes the callback
/*!
	\param in_pContext The converter context to be used in the execution
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();


//! Get the instance of CAnimationPlotter to collect animation to be plotted
/*!
	\return CAnimationPlotter* the instance of animation plotter
*/
	CAnimationPlotter *GetAnimationPlotter();

	
//! Set the instance of CAnimationPlotter to collect animation to be plotted
/*!
	\param in_pAnimationPlotter the instance of animation plotter
	\return void
*/
	void SetAnimationPlotter(CAnimationPlotter *in_pAnimationPlotter);

private:

	CAnimationPlotter	*m_pAnimationPlotter;
};

//! class CMaterialLibraryAnimationToXSI
/*!
    class that implements putting material library animation in XSI
*/
class CMaterialLibraryAnimationToXSI : public CdotXSIConverterCallback
{
public:

//! Default constructor
	CMaterialLibraryAnimationToXSI();

//! Default destructor
	virtual ~CMaterialLibraryAnimationToXSI();

//! Executes the callback
/*!
	\param in_pContext The converter context to be used in the execution
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};

#endif // CNV_MATERIAL_ANIM_H
