//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file cnv_mesh_cluster.cpp
/*!
	Mesh cluster conversion classes
*/

#include "stdafx.h"
#include "cnv_mesh_cluster.h"
#include "cnv_custompset.h"
#include <xsi_polygonmesh.h>
#include <xsi_geometryaccessor.h>
#include <xsi_meshbuilder.h>
#include <XSIMesh.h>
#include <XSIShape.h>
#include <xsi_x3dobject.h>
#include <xsi_time.h>
#include <xsi_primitive.h>
#include <xsi_cluster.h>
#include <Model.h>
#include <XSISubComponentAttributeList.h>
#include <XSIVertexList.h>
#include <MaterialLibrary.h>
#include <Material.h>
#include <xsi_material.h>
#include <XSIPolygonList.h>
#include <XSITriangleList.h>
#include <GlobalMaterial.h>
#include <Cluster.h>
#include <xsi_clusterpropertybuilder.h>


/**************************************************************************************
CMeshClusterFromXSI
**************************************************************************************/
CMeshClusterFromXSI::CMeshClusterFromXSI(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype)
{
	m_CryFiletype = in_CryFiletype;
};

CMeshClusterFromXSI::~CMeshClusterFromXSI() {};

CStatus CMeshClusterFromXSI::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;

	LONG loop;

	X3DObject l_XSIModel = (X3DObject) *io_pXSIModel;

	if(wcscmp(l_XSIModel.GetType().GetWideString(), L"polymsh") == 0)
	{
		CSLModel		*l_pFTKModel = (CSLModel *) *io_pFTKModel;

		if (l_pFTKModel)
		{
			CSLXSIMesh		*l_pFTKMesh = (CSLXSIMesh *) l_pFTKModel->Primitive();
			PolygonMesh		l_XSIMesh = (PolygonMesh) l_XSIModel.GetActivePrimitive().GetGeometry();

			CSIBCUserData *l_pUserData = l_pFTKMesh->FindUserData("GEOMETRYACCESSOR");
			if(l_pUserData)
			{
				CRef *l_pCRef = (CRef*)(l_pUserData->GetData());
				CGeometryAccessor l_XSIGeometryAccessor = (CGeometryAccessor) *l_pCRef;

				if (l_XSIGeometryAccessor.IsValid())
				{
					// export the clusters
					CRefArray l_XSIClusters = l_XSIGeometryAccessor.GetClusters(siClusterVertexType);

					for (loop = 0; loop < l_XSIClusters.GetCount(); loop++)
					{
						Cluster l_XSICluster = (Cluster)l_XSIClusters.GetItem(loop);

						CString l_XSIClusterName = l_XSICluster.GetName();

						CSLCluster* l_pFTKCluster = l_pFTKModel->AddCluster();

						// set the type of the cluster
						l_pFTKCluster->GetClusterInfo()->SetClusterType(CSLXSIClusterInfo::SI_VERTEX);

						// set the name of the new cluster
						l_pFTKCluster->SetName((char*)l_XSIClusterName.GetAsciiString());

						// the weighting type is always "average" in XSI
						l_pFTKCluster->SetWeightingType(CSLCluster::SI_AVERAGE);

						// set the cluster elements
						CBitArray l_XSIClusterElemDesc;
						l_XSICluster.GetGeometryElementFlags(l_XSIClusterElemDesc);

						CSLCluster::CSLIntArray* l_pFTKClusterElems = l_pFTKCluster->GetVertexIndicesList();
						l_pFTKClusterElems->Reserve(l_XSIClusterElemDesc.GetTrueCount());

						LONG loop2 = 0;
						LONG idx = 0;

						while( l_XSIClusterElemDesc.GetNextTrueBit( idx ) )
						{
							(*l_pFTKClusterElems)[loop2] = idx;
							loop2++;
						}

						// set the cluster center
						CRef l_XSIClusterCenter = l_XSICluster.GetCenterReference();

						if (l_XSIClusterCenter.IsValid())
						{
							CSLModel* l_pFTKClusterCenter = in_pContext->FindModelByCRef(NULL,l_XSIClusterCenter);

							if (l_pFTKClusterCenter)
							{
								l_pFTKCluster->SetCenter(l_pFTKClusterCenter);
							}
						}

						// grab it's custom psets
						CCustomPSetFromXSI l_CustomPSetConverter(m_CryFiletype);
						CRef l_ClusterCRef = l_XSICluster;
						CSLTemplate *l_pClusterTemplate = (CSLTemplate*) l_pFTKCluster;
						_XSI_CALL(l_CustomPSetConverter.Execute(in_pContext, in_XSIParent, in_pFTKParent, NULL, &l_ClusterCRef, &l_pClusterTemplate), L"Failed to convert custom pset");
					}

					// export the polygon clusters
					l_XSIClusters = l_XSIGeometryAccessor.GetClusters(siClusterPolygonType);

					for (loop = 0; loop < l_XSIClusters.GetCount(); loop++)
					{
						Cluster l_XSICluster = (Cluster)l_XSIClusters.GetItem(loop);

						CString l_XSIClusterName = l_XSICluster.GetName();

						CSLCluster* l_pFTKCluster = l_pFTKModel->AddCluster();

						// set the type of the cluster
						l_pFTKCluster->GetClusterInfo()->SetClusterType(CSLXSIClusterInfo::SI_POLYGON);

						// set the name of the new cluster
						l_pFTKCluster->SetName((char*)l_XSIClusterName.GetAsciiString());

						// the weighting type is always "average" in XSI
						l_pFTKCluster->SetWeightingType(CSLCluster::SI_AVERAGE);

						// set the cluster elements
						CBitArray l_XSIClusterElemDesc;
						l_XSICluster.GetGeometryElementFlags(l_XSIClusterElemDesc);

						CSLCluster::CSLIntArray* l_pFTKClusterElems = l_pFTKCluster->GetVertexIndicesList();
						l_pFTKClusterElems->Reserve(l_XSIClusterElemDesc.GetTrueCount());

						LONG loop2 = 0;
						LONG idx = 0;

						while( l_XSIClusterElemDesc.GetNextTrueBit( idx ) )
						{
							(*l_pFTKClusterElems)[loop2] = idx;
							loop2++;
						}

						// set the cluster center
						CRef l_XSIClusterCenter = l_XSICluster.GetCenterReference();

						if (l_XSIClusterCenter.IsValid())
						{
							CSLModel* l_pFTKClusterCenter = in_pContext->FindModelByCRef(NULL,l_XSIClusterCenter);

							if (l_pFTKClusterCenter)
							{
								l_pFTKCluster->SetCenter(l_pFTKClusterCenter);
							}
						}

						// grab it's custom psets
						CCustomPSetFromXSI l_CustomPSetConverter(m_CryFiletype);
						CRef l_ClusterCRef = l_XSICluster;
						CSLTemplate *l_pClusterTemplate = (CSLTemplate*) l_pFTKCluster;
						_XSI_CALL(l_CustomPSetConverter.Execute(in_pContext, in_XSIParent, in_pFTKParent, NULL, &l_ClusterCRef, &l_pClusterTemplate), L"Failed to convert custom pset");
					}

					*io_pFTKModel = l_pFTKModel;
				}
			}
		}
	}

	return status;
}

wchar_t *CMeshClusterFromXSI::GetClassID(){return L"CMeshClusterFromXSI";}

/**************************************************************************************
CMeshClusterToXSI
**************************************************************************************/
CMeshClusterToXSI::CMeshClusterToXSI(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype)
{
	m_CryFiletype = in_CryFiletype;
};

CMeshClusterToXSI::~CMeshClusterToXSI() {};

CStatus CMeshClusterToXSI::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;
	LONG loop, loop2;

	if (*io_pFTKModel)
	{
		CSLModel *l_pFTKModel = (CSLModel *)(*io_pFTKModel);

		if (l_pFTKModel->Primitive() && l_pFTKModel->Primitive()->Type() == CSLTemplate::XSI_MESH)
		{
			CSIBCUserData *l_pUserData = l_pFTKModel->FindUserData("CREF");
			if(l_pUserData)
			{
				CRef *l_pCRef = (CRef*)(l_pUserData->GetData());
				X3DObject l_XSIX3DObject = (X3DObject) *l_pCRef;

				if (l_XSIX3DObject.IsValid())
				{
					PolygonMesh	l_XSIMesh = l_XSIX3DObject.GetActivePrimitive().GetGeometry(); 

					// IF there exists an index list, and IF there are the right number of indices in the list
					// THEN we'll use the lovely index list. Otherwise, we won't.
					// this boolean represents whether we'll use index lists or not
					CSLXSIMesh* l_pFTKMesh = (CSLXSIMesh*)l_pFTKModel->Primitive();
					bool bPolyClusterSupport = true;
					for (loop = 0; bPolyClusterSupport && loop < l_pFTKMesh->GetXSIPolygonListCount(); loop++)
					{
						// grab poly list stuff
						CSLXSIPolygonList *l_pFTKPolygonList = l_pFTKMesh->XSIPolygonLists()[loop];
						ULONG l_polyCount = l_pFTKPolygonList->GetPolygonCount();

						// set up the index list
						CSLXSIIndexList *l_pFTKIndexList = l_pFTKPolygonList->GetIndexList();
						if (!l_pFTKIndexList) {
							// index list not found
							bPolyClusterSupport = false;
							break;
						}
						int l_indexListCount = l_pFTKIndexList->GetCount();
						bPolyClusterSupport = (l_indexListCount == l_polyCount);
					}

					LONG l_nClusterCount = l_pFTKModel->GetClusterCount();

					for (loop = 0; loop < l_pFTKModel->GetClusterCount(); loop++)
					{
						CSLCluster* l_pFTKCluster = l_pFTKModel->GetClusterList()[loop];

						CString l_XSIClusterName;
						l_XSIClusterName.PutAsciiString(l_pFTKCluster->GetName());

						// see if a cluster with the same name already exist
						CRefArray l_XSIClusters = l_XSIMesh.GetClusters();
						Cluster l_XSICluster;

						l_XSICluster = l_XSIClusters.GetItem(l_XSIClusterName);

						// if a cluster with the same name does not already exist
						// or if it has a different number of elements
						// create a new one
						if ( !l_XSICluster.IsValid() || !(l_XSICluster.GetElements().GetCount() == l_pFTKCluster->GetVertexIndicesCount()) )
						{
							CLongArray l_XSIVertexIndicies;

							l_XSIVertexIndicies.Resize(l_pFTKCluster->GetVertexIndicesCount());

							int *l_pFTKVertexIndices = l_pFTKCluster->GetVertexIndicesListPtr();

							for (loop2 = 0; loop2 < l_pFTKCluster->GetVertexIndicesCount(); loop2++)
							{
								l_XSIVertexIndicies[loop2] = l_pFTKVertexIndices[loop2];
							}
							
							// check for type of cluster - currently we only support vertex, and polygon (only if theres the index lists for matching)
							if (bPolyClusterSupport && l_pFTKCluster->GetClusterInfo()->GetClusterType() == CSLXSIClusterInfo::SI_POLYGON) {
								l_XSIMesh.AddCluster(L"poly", l_XSIClusterName, l_XSIVertexIndicies, l_XSICluster);

								// set the material for this cluster
								bool isFound = false;
								for (loop2 = 0; !isFound && loop2 < l_pFTKMesh->GetXSIPolygonListCount(); loop2++)
								{
									// look in each poly list for the material
									CSLXSIPolygonList *l_pFTKPolygonList = l_pFTKMesh->XSIPolygonLists()[loop2];

									Material l_XSIMaterial;
									CSLBaseMaterial* l_pFTKMaterial = l_pFTKPolygonList->GetMaterial();

									// grab the material
									if (l_pFTKMaterial)
									{
										CSIBCUserData *l_pUserData = l_pFTKMaterial->FindUserData("CREF");
										if(l_pUserData)
										{
											CRef *l_pCRef = (CRef*)(l_pUserData->GetData());
											l_XSIMaterial = (Material) *l_pCRef;

											if (l_XSIMaterial.IsValid())
											{
												// we can order via indexlists, then do so
												CSLXSIIndexList::CSLIntArray *l_pFTKIndexArray = NULL;
												CSLXSIIndexList *l_pFTKIndexList = l_pFTKPolygonList->GetIndexList();
												l_pFTKIndexArray = l_pFTKIndexList->GetIndexArray();
												LONG* l_pTempIndices = new LONG[l_pFTKPolygonList->GetPolygonCount()];

												// generate the correct indices for the polygon
												for (int loop3 = 0; loop3 < l_pFTKPolygonList->GetPolygonCount(); loop3++)
												{
													l_pTempIndices[loop3] = (*l_pFTKIndexArray)[loop3];
												}

												if (l_pFTKPolygonList->GetPolygonCount() > 0)
												{
													// do not add a cluster/material if it's using the global material.
													if (l_pFTKMaterial != l_pFTKModel->GlobalMaterial()->GetMaterial())
													{
														// find the material
														for (int loop4 = 0; !isFound && loop4 < l_pFTKPolygonList->GetPolygonCount(); loop4++)
															if (l_XSIVertexIndicies[0] == l_pTempIndices[loop4])
															{
																isFound = true;
																l_XSICluster.SetMaterial(l_XSIMaterial);
															}
													}
												}

												delete [] l_pTempIndices;
											}
										}
									}
								}
							}
							else if (l_pFTKCluster->GetClusterInfo()->GetClusterType() == CSLXSIClusterInfo::SI_VERTEX)
								// only import if its a vertex cluster
								l_XSIMesh.AddCluster(L"pnt", l_XSIClusterName, l_XSIVertexIndicies, l_XSICluster);
						}

						// set the cluster center
						if (l_XSICluster.IsValid() && l_pFTKCluster->GetCenter())
						{
							CSLModel* l_pFTKClusterCenter = l_pFTKCluster->GetCenter();

							CSIBCUserData *l_pUserData = l_pFTKClusterCenter->FindUserData("CREF");
							if(l_pUserData)
							{
								CRef *l_pCRef = (CRef*)(l_pUserData->GetData());
								X3DObject l_XSIClusterCenter = (X3DObject) *l_pCRef;

								l_XSICluster.PutCenterReference(l_XSIClusterCenter);
							}
						}

						// grab it's custom psets
						if (l_XSICluster.IsValid())
						{
							CCustomPSetToXSI l_CustomPSetConverter(m_CryFiletype);
							CRef l_ClusterCRef = l_XSICluster;
							CSLTemplate *l_pClusterTemplate = (CSLTemplate*) l_pFTKCluster;
							_XSI_CALL(l_CustomPSetConverter.Execute(in_pContext, in_XSIParent, in_pFTKParent, NULL, &l_ClusterCRef, &l_pClusterTemplate), L"Failed to convert custom pset");
						}

					}
				}
			}
		}
	}

	return status;
}

wchar_t *CMeshClusterToXSI::GetClassID(){return L"CMeshClusterToXSI";}

