//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file cnv_mesh_cluster.h
/*!
	Mesh cluster conversion classes
*/

#ifndef CNV_MESH_CLUSTER_H
#define CNV_MESH_CLUSTER_H


#include "Crosswalk/dotXSIConverterCallback.h"
#include "Crosswalk/dotXSIConverter.h"
#include "cnv_hierarchytraversal.h"

//! class CMeshClusterFromXSI
/*!
    class ton convert a mesh from XSI to the FTK
*/
class CMeshClusterFromXSI : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CMeshClusterFromXSI(short in_CryFiletype);

//! Default destructor
	virtual ~CMeshClusterFromXSI();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute( CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();

private:
	short m_CryFiletype;
};

//! class CMeshClusterToXSI
/*!
    class ton convert a mesh from the FTK to XSI
*/
class CMeshClusterToXSI : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CMeshClusterToXSI(short in_CryFiletype);

//! Default destructor
	virtual ~CMeshClusterToXSI();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute( CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();

private:
	short m_CryFiletype;
};

#endif // CNV_MESH_CLUSTER_H
