#include "stdafx.h"
#include "Crosswalk/dotXSIConverter.h"
#include "plugin_stub.h"
#include <xsi_application.h>
#include <xsi_context.h>
#include <xsi_menu.h>
#include <xsi_property.h>
#include <xsi_model.h>
#include <xsi_command.h>
#include <xsi_argument.h>
#include <xsi_ppglayout.h>
#include <xsi_time.h>
#include <xsi_parameter.h>
#include <xsi_ppgeventcontext.h>
#include <xsi_selection.h>
#include <xsi_uitoolkit.h>
#include <xsi_griddata.h>
#include <xsi_color.h> 

#include <xsi_material.h>
#include <xsi_shader.h>
#include <xsi_kinematics.h>
#include <xsi_imageclip.h>
#include <xsi_actionsource.h>
#include <xsi_mixer.h>
#include <xsi_materiallibrary.h>
#include <xsi_preferences.h>
#include <xsi_null.h>
#include <xsi_geometry.h>
#include <xsi_primitive.h>
#include <xsi_polygonmesh.h>
#include <xsi_geometryaccessor.h>

// Modules
#include "Crosswalk/Modules/cnv_dotXSI_IO.h"
#include "Crosswalk/Modules/cnv_COLLADA_IO.h"
#include "Crosswalk/Modules/cnv_info.h"
#include "Crosswalk/Modules/cnv_environment.h"
#include "Crosswalk/Modules/cnv_hierarchytraversal.h"
#include "Crosswalk/Modules/cnv_model.h"
#include "Crosswalk/Modules/cnv_null.h"
#include "Crosswalk/Modules/cnv_modelinfo.h"
#include "Crosswalk/Modules/cnv_camera.h"
#include "Crosswalk/Modules/cnv_custompset.h"
#include "Crosswalk/Modules/cnv_material.h"
#include "Crosswalk/Modules/cnv_image.h"
#include "Crosswalk/Modules/cnv_instance.h"
#include "Crosswalk/Modules/cnv_mesh.h"
#include "Crosswalk/Modules/cnv_mesh_clusterprop.h"
#include "Crosswalk/Modules/cnv_mesh_cluster.h"
#include "Crosswalk/Modules/cnv_light.h"
#include "Crosswalk/Modules/cnv_camera_anim.h"
#include "Crosswalk/Modules/cnv_custompset_anim.h"
#include "Crosswalk/Modules/cnv_environment_anim.h"
#include "Crosswalk/Modules/cnv_material_anim.h"
#include "Crosswalk/Modules/cnv_light_anim.h"
#include "Crosswalk/Modules/cnv_modelinfo_anim.h"
#include "Crosswalk/Modules/cnv_image_anim.h"
#include "Crosswalk/Modules/cnv_mixer.h"
#include "Crosswalk/Modules/cnv_userdatablob.h"
#include "Crosswalk/Modules/cnv_plottedanimation.h"
#include "Crosswalk/Modules/cnv_envelope.h"
#include "Crosswalk/Modules/cnv_shapeanimation.h"
#include "Crosswalk/Modules/cnv_hierarchyelementinfo.h"
#include "Crosswalk/Modules/cnv_ik.h"

#include <commdlg.h>

#include "check.h"
#include "rc.h"
#include "helper.h"

#include "Properties.h"

/****************************************************************************************
XSI plugin Command definition functions
****************************************************************************************/
_XSI_EXTERN_ CStatus CryExportCrosswalk_Init( const CRef& in_context )
{
	CStatus status = CStatus::OK;
	Context ctx(in_context);
	Command cmd(ctx.GetSource());

	cmd.EnableReturnValue( true ) ; 

	// See xsi_command.h and xsi_argument.h for further
	// attributes you may wish to set. For example Command.PutTooltip(),
	// and ArgumentArray.AddWithHandler()	

	Application app;

	// Configure this code based on the number of arguments
	// you want.  You can also specific default values for these arguments.

	ArgumentArray args = cmd.GetArguments();
	args.Add( L"arg0", L"\0" );

	return status;
}

/****************************************************************************************
XSI plugin menu event functions
****************************************************************************************/
_XSI_EXTERN_ CStatus CryExport_Execute( CRef& in_ref )
{
	CStatus status = CStatus::OK;
	Application app;

	Property prop = app.GetActiveSceneRoot().GetProperties().GetItem( L"CryExportCrosswalkOptions" ) ;

	if (!prop.IsValid())
	{
		prop = app.GetActiveSceneRoot().AddProperty( L"CryExportCrosswalkOptions" ) ;
	}

	// Let's build our label for the property page
	wchar_t l_wLabel[1024];
	swprintf(l_wLabel,
#ifdef unix
		sizeof(l_wLabel),
		L"Crosswalk Export v%ls build %s %s",
#else
		L"Crosswalk Export v%s build %S %S",
#endif
		TOOL_VERSION, __DATE__, __TIME__);

	XSI::COMMANDS::InspectObj(L"CryExportCrosswalkOptions",CValue(),l_wLabel,(LONG)siRecycle,false);

	return status;
}

_XSI_EXTERN_ CStatus CryExport_Init( CRef& in_ref )
{
	CStatus status = CStatus::OK;

	Context ctxt = in_ref;
	Menu menu = ctxt.GetSource();

	CStatus st;
	MenuItem item;

	// Here we add our menu item in the export menu
	menu.AddCallbackItem(L"CryExport", L"CryExport_Execute", item);

	return status;
}

_XSI_EXTERN_ CStatus CryExportAll_Execute( CRef& in_ref )
{
	CStatus status = CStatus::OK;
	Application app;

	Property prop = app.GetActiveSceneRoot().GetProperties().GetItem( L"CryExportCrosswalkOptions" ) ;

	if (!prop.IsValid())
	{
		prop = app.GetActiveSceneRoot().AddProperty( L"CryExportCrosswalkOptions" ) ;
	}

	CValue			retValue;
	CValueArray		args(1);

	/////////////////////////////////////////////////////////////////////////
	// Update the filenames
	/////////////////////////////////////////////////////////////////////////
	CValue l_Value;
	CString l_FolderPath = GetExportPath();
	l_FolderPath += L"\\";

	Scene l_Scene = app.GetActiveProject().GetActiveScene();
	CString l_FullFilename = l_Scene.GetParameterValue(L"Filename");
	CStringArray l_FullFilenameSplit = l_FullFilename.Split( L"\\");
	const char *l_pFilename = l_FullFilenameSplit[l_FullFilenameSplit.GetCount()-1].GetAsciiString();

	CString l_Filename = l_FolderPath;

	if (l_pFilename && strlen(l_pFilename) > 4)
	{
		char *l_pTemp = _strdup(l_pFilename);
		CString l_Temp;
		l_pTemp[strlen(l_pTemp)-4] = NULL;

		l_Temp.PutAsciiString(l_pTemp);

		l_Filename += l_Temp;
		l_Filename += L".dae";
	}

	prop.PutParameterValue(L"Filename", l_Filename);

	// For the sake of simplicity here the command takes an CryExportCrosswalkOptions property
	// as its only parameter
	args[0] = prop.GetFullName();
	prop.PutParameterValue(L"Type",(short)EXPORT_ALL);

	if (Diagnostics(false))
	{
		app.ExecuteCommand(L"CryExportCrosswalk", args, retValue);
		RunResourceCompiler(l_Filename, true);
	}

	return status;
}

_XSI_EXTERN_ CStatus CryExportCrosswalk_Execute( CRef& in_context )
{
	CStatus status = CStatus::OK;
	Application app;
	Context ctxt(in_context);
	int loop;

	UnhideAllClusters();

	/* NO IK PRESERVATION
	bool l_bPreserveIK;
	*/
	CAnimationPlotter *l_pAnimationPlotter = NULL;
	CMaterialLibraryFromXSI *l_pMatLibConverter = NULL;

	// Access the arguments to the command
	CValueArray		args = ctxt.GetAttribute( L"Arguments" );
	CString			argName(args[0]);
	debugprintf(L"Cry Crosswalk Export - Using %s\n", argName.GetWideString());

	// Create our converter and export
	CdotXSIConverter converter;

	// Set the export property here
	_XSI_CALL(converter.SetExportProperty(argName), L"Failed to set export properties");

	CProcessTimer::ResetTasks();

	Property exportProp = converter.exportproperty();
	LONG l_lFormat = exportProp.GetParameterValue(L"Format");
	converter.SetFormat(l_lFormat);

	short l_lType = exportProp.GetParameterValue(L"Type");

	l_CryExportNodesToExport.Clear();

	if (l_lType == EXPORT_SUBSET)
	{
		CString l_StringCryExportNodeList = exportProp.GetParameterValue(L"CryExportNodeList");

		if (l_StringCryExportNodeList.Length() == 0)
		{
			app.LogMessage(L"You must specify the CryExportNode(s) - Export Subset was canceled", siErrorMsg);
			return CStatus::Fail;
		}
		else
		{
			CStringArray l_SplitList = l_StringCryExportNodeList.Split(L";");

			if (!l_SplitList.GetCount())
			{
				app.LogMessage(L"You must select a CryExportNode(s) - Export Subset was canceled", siErrorMsg);
				return CStatus::Fail;
			}

			for (loop = 0; loop < l_SplitList.GetCount(); loop++)
			{
				CString l_CryExportNodeName = l_SplitList[loop];
				CStringArray l_CryExportNodeNameSplit = l_CryExportNodeName.Split(L":");

				if (l_CryExportNodeNameSplit.GetCount() == 1)
				{
					X3DObject l_Object = GetCryExportNodeByName(l_SplitList[loop]);
					l_CryExportNodesToExport.Add(l_Object);

					// set the ExportFiletype to the Filetype
					CustomProperty l_Properties(l_Object.GetProperties().GetItem(L"ExportProperties"));
					l_Properties.PutParameterValue(L"ExportFiletype", GetCryExportNodeFiletype(l_Object));
				}
				else
				{
					short l_ExportFiletype = 0;
					X3DObject l_Object = GetCryExportNodeByName(l_CryExportNodeNameSplit[0]);

					// check if the next entry is the same node with CAF or ANM type
					if (loop+1 < l_SplitList.GetCount())
					{
						CString l_CryExportNodeName2 = l_SplitList[loop+1];
						CStringArray l_CryExportNode2NameSplit = l_CryExportNodeName2.Split(L":");

						if (l_CryExportNodeNameSplit.GetCount() > 1)
						{
							if (l_CryExportNode2NameSplit[0] == l_CryExportNodeNameSplit[0])
							{
								// we found two, set the ExportFiletype to CHR and CAF or CGA and ANM
								if (l_CryExportNode2NameSplit[1] == L"CHR" || l_CryExportNode2NameSplit[1] == L"CAF")
									l_ExportFiletype = CRY_FILE_TYPE_CHR|CRY_FILE_TYPE_CAF;
								else if (l_CryExportNode2NameSplit[1] == L"CGA" || l_CryExportNode2NameSplit[1] == L"ANM")
									l_ExportFiletype = CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_ANM;
							}
						}
					}

					// set the ExportFiletype to the filetype specified in the string
					if (l_CryExportNodeNameSplit[1] == L"CHR")
					{
						l_ExportFiletype |= CRY_FILE_TYPE_CHR;
					}

					// set the ExportFiletype to the filetype specified in the string
					if (l_CryExportNodeNameSplit[1] == L"CAF")
					{
						l_ExportFiletype |= CRY_FILE_TYPE_CAF;
					}

					// set the ExportFiletype to the filetype specified in the string
					if (l_CryExportNodeNameSplit[1] == L"CGA")
					{
						l_ExportFiletype |= CRY_FILE_TYPE_CGA;
					}

					// set the ExportFiletype to the filetype specified in the string
					if (l_CryExportNodeNameSplit[1] == L"ANM")
					{
						l_ExportFiletype |= CRY_FILE_TYPE_ANM;
					}

					CustomProperty l_Properties(l_Object.GetProperties().GetItem(L"ExportProperties"));
					l_Properties.PutParameterValue(L"ExportFiletype", (short)l_ExportFiletype);

					l_CryExportNodesToExport.Add(l_Object);

					// skip the next one if we found the two file type entry
					if (l_ExportFiletype == (CRY_FILE_TYPE_CHR|CRY_FILE_TYPE_CAF))
					{
						loop++;
					}
					if (l_ExportFiletype == (CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_ANM))
					{
						loop++;
					}
				}
			}
		}
	}
	else if(l_lType == EXPORT_ALL)
	{
		l_CryExportNodesToExport = GetAllCryExportNodes();

		for (LONG i = 0; i < l_CryExportNodesToExport.GetCount(); i++)
		{
			X3DObject l_Object(l_CryExportNodesToExport.GetItem(i));

			CustomProperty l_Properties(l_Object.GetProperties().GetItem(L"ExportProperties"));
			l_Properties.PutParameterValue(L"ExportFiletype", GetCryExportNodeFiletype(l_Object));
		}

		if (l_CryExportNodesToExport.GetCount() == 0)
		{
			app.LogMessage(L"There is no CryExportNodes in the scene - Export All was canceled", siErrorMsg);
			return status;
		}
	}

	// This is where we populate the list of export callbacks

	// if something is selected then check the advance option
	bool l_bExportSelectionOnly = exportProp.GetParameterValue(L"ExportSelectionOnly");


	// This callback sets the version of dotXSI to export
	converter.exportcallbacks().Add(new CProcessTimer(L"Set version"));
	converter.exportcallbacks().Add(new CdotXSI_SetVersion());

	// This callback sets scene information from XSI to the FTK
	converter.exportcallbacks().Add(new CProcessTimer(L"Converting scene info"));
	converter.exportcallbacks().Add(new CSceneInfoFromXSI());

	/* NO ENVIRONEMENT EXPORT
	// This callback sets the environment (ambience) from XSI to the FTK
	converter.exportcallbacks().Add(new CProcessTimer(L"Converting environment"));
	converter.exportcallbacks().Add(new CEnvironmentFromXSI());
	converter.exportcallbacks().Add(new CProcessTimer(L"Converting environment animations"));
	converter.exportcallbacks().Add(new CEnvironmentAnimationFromXSI());
	*/

	// This callback sets the image clips from XSI to the FTK
	converter.exportcallbacks().Add(new CProcessTimer(L"Converting image clips"));
	converter.exportcallbacks().Add(new CXSIImageLibraryFromXSI());

	/*
	converter.exportcallbacks().Add(new CProcessTimer(L"Converting image clip animations"));
	converter.exportcallbacks().Add(new CXSIImageLibraryAnimationFromXSI());
	*/
	// This callback sets the materials from XSI to the FTK
	converter.exportcallbacks().Add(new CProcessTimer(L"Converting materials"));
	l_pMatLibConverter = new CMaterialLibraryFromXSI(l_lType);
	converter.exportcallbacks().Add(l_pMatLibConverter);
	/*
	converter.exportcallbacks().Add(new CProcessTimer(L"Converting material animations"));
	converter.exportcallbacks().Add(new CMaterialLibraryAnimationFromXSI());
	*/

	// if we export everything we do not need to filter based on selection.
	// This callback does a first hierarchy travers to identify which scene elements
	// we want to export exactly (based on selection).
	CXSIHierarchyTraverser *l_XSIFilteringPassTraverser = new CXSIHierarchyTraverser();

	// we are not setting the mode of this pass to selected so it will go thru all the
	// element of the scene and will execute the callback regardless of the Filetype.
	CHierarchyElementInfoFromXSI *l_pFilterCallbak = new CHierarchyElementInfoFromXSI(CRY_FILE_TYPE_NONE);
	l_pFilterCallbak->SetCryExportNodesToExport(l_CryExportNodesToExport);

	l_XSIFilteringPassTraverser->callbacks().Add(l_pFilterCallbak);
	converter.exportcallbacks().Add(new CProcessTimer(L"Filtering pass"));
	converter.exportcallbacks().Add(l_XSIFilteringPassTraverser);

	// This callback adds auxiliary nodes to the list to export.
	CXSIHierarchyTraverser *l_XSIAuxiliaryPassTraverser = new CXSIHierarchyTraverser();

	// we are not setting the mode of this pass to selected so it will go thru all the
	// element of the scene and will execute the callback regardless of the Filetype.
	CAuxiliaryHierarchyElementInfoFromXSI *l_pAuxiliaryCallback = new CAuxiliaryHierarchyElementInfoFromXSI(CRY_FILE_TYPE_NONE);
	l_pAuxiliaryCallback->SetAuxiliaryNodesToExport(l_pFilterCallbak->GetAuxiliaryNodesToExport(), l_pFilterCallbak->GetAuxiliaryNodeFileTypes());

	l_XSIAuxiliaryPassTraverser->callbacks().Add(l_pAuxiliaryCallback);
	converter.exportcallbacks().Add(new CProcessTimer(L"Auxiliary pass"));
	converter.exportcallbacks().Add(l_XSIAuxiliaryPassTraverser);

	// Add the Root hierarchy element info.
	converter.AddHierarchyElementInfo();

	// This callback makes a traverser to populate models in the FTK from XSI (Pass1)
	CXSIHierarchyTraverser *l_XSIPass1Traverser = new CXSIHierarchyTraverser();

	l_XSIPass1Traverser->SetTraverserMode( l_bExportSelectionOnly ? CXSIHierarchyTraverser::SELECTED : CXSIHierarchyTraverser::ALL );

	converter.exportcallbacks().Add(new CProcessTimer(L"Converting hierarchy - first pass"));
	converter.exportcallbacks().Add(l_XSIPass1Traverser);

	if (l_lType != EXPORT_ALLMATERIALS)
	{
		// CrySpecific: Remove ModelFromXSI...
		//	l_XSIPass1Traverser->callbacks().Add(new CModelFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR|CRY_FILE_TYPE_CAF));
		l_XSIPass1Traverser->callbacks().Add(new CNullFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR|CRY_FILE_TYPE_CAF|CRY_FILE_TYPE_ANM));

		/* NO CAMERAS AND NO LIGHTS
		if (l_lType == EXPORT_TYPE_ALL)
		{
		if (( l_lFormat == DOTXSI_FORMAT_5_0 ) || ( l_lFormat == DOTXSI_FORMAT_5_0_BINARY ))
		{
		l_XSIPass1Traverser->callbacks().Add(new CCameraFromXSI());
		}
		else
		{
		l_XSIPass1Traverser->callbacks().Add(new CXSI_CameraFromXSI());
		}

		l_XSIPass1Traverser->callbacks().Add(new CLightFromXSI());
		}
		*/

		/* NO INSTANCES
		l_XSIPass1Traverser->callbacks().Add(new CInstanceFromXSI());
		*/
		l_XSIPass1Traverser->callbacks().Add(new CMeshFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR));
		l_XSIPass1Traverser->callbacks().Add(new CMeshClusterPropFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR));

		/* NO IK PRESERVATION
		l_bPreserveIK = exportProp.GetParameterValue(L"PreserveIK");

		if ( (l_lFormat != COLLADA_FORMAT_1_4_1) && (l_bPreserveIK) )
		{
		l_XSIPass1Traverser->callbacks().Add(new CIKFromXSI());
		}
		*/
		l_XSIPass1Traverser->callbacks().Add(new CUnknownFromXSI(CRY_FILE_TYPE_CAF|CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR|CRY_FILE_TYPE_ANM));

		l_XSIPass1Traverser->callbacks().Add(new CHierarchyUpdateFTKModel(CRY_FILE_TYPE_CAF|CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR|CRY_FILE_TYPE_ANM));
		l_XSIPass1Traverser->callbacks().Add(new CUserDataBlobFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR));
		l_XSIPass1Traverser->callbacks().Add(new CModelInfoFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR|CRY_FILE_TYPE_CAF|CRY_FILE_TYPE_ANM));
		l_XSIPass1Traverser->callbacks().Add(new CCustomPSetFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR));

		// now let's just add our animation callbacks 

		// create our master animation plotter if we want to globally plot animation
		l_pAnimationPlotter = new CAnimationPlotter();

		/* NO CAMERA AND NO LIGHT
		CCameraAnimationFromXSI				*l_pCameraAnimation = new CCameraAnimationFromXSI();
		CXSICameraAnimationFromXSI			*l_pXSICameraAnimation = new CXSICameraAnimationFromXSI();
		CLightAnimationFromXSI				*l_pLightAnimation = new CLightAnimationFromXSI();
		*/
		CCustomPSetAnimationFromXSI			*l_pCustomPSetAnimation = new CCustomPSetAnimationFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA);
		CModelInfoAnimationFromXSI			*l_pModelInfoAnimation = new CModelInfoAnimationFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA);
		CGlobalTransformAnimationFromXSI	*l_pGlobalTransformAnimation = new CGlobalTransformAnimationFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA);

		bool l_bPlotAnimation = exportProp.GetParameterValue(L"PlotAnimation");

		if (l_bPlotAnimation) // global animation plotting
		{
			/* NO CAMERA AND NO LIGHT
			l_pCameraAnimation->SetAnimationPlotter(l_pAnimationPlotter);
			l_pXSICameraAnimation->SetAnimationPlotter(l_pAnimationPlotter);
			l_pLightAnimation->SetAnimationPlotter(l_pAnimationPlotter);
			*/

			l_pCustomPSetAnimation->SetAnimationPlotter(l_pAnimationPlotter);
			l_pModelInfoAnimation->SetAnimationPlotter(l_pAnimationPlotter);
		}

		l_pGlobalTransformAnimation->SetAnimationPlotter(l_pAnimationPlotter);

		/* NO CAMERA AND NO LIGHT
		l_XSIPass1Traverser->callbacks().Add(l_pCameraAnimation);
		l_XSIPass1Traverser->callbacks().Add(l_pXSICameraAnimation);	
		l_XSIPass1Traverser->callbacks().Add(l_pLightAnimation);
		l_XSIPass1Traverser->callbacks().Add(l_pCustomPSetAnimation);
		*/

	// CrySpecific: Only mixer animations
//		l_XSIPass1Traverser->callbacks().Add(l_pModelInfoAnimation);
//		l_XSIPass1Traverser->callbacks().Add(l_pGlobalTransformAnimation);
		l_XSIPass1Traverser->callbacks().Add(new CMixerFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CAF|CRY_FILE_TYPE_ANM));

		l_XSIPass1Traverser->callbacks().Add(new CShapeAnimationFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR));

	}

	CXSIInstanceDataFromXSI *l_pInstanceDataConverter = new CXSIInstanceDataFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR);
	l_pInstanceDataConverter->m_pMatLibConverter = l_pMatLibConverter;
	l_XSIPass1Traverser->callbacks().Add(l_pInstanceDataConverter);

	// Pass 2 - Create new traverser that connects operators or other
	// things that have relations between objects
	CXSIHierarchyTraverser *l_XSIPass2Traverser = new CXSIHierarchyTraverser();
	l_XSIPass2Traverser->SetTraverserMode( l_bExportSelectionOnly ? CXSIHierarchyTraverser::SELECTED : CXSIHierarchyTraverser::ALL );

	converter.exportcallbacks().Add(new CProcessTimer(L"Converting hierarchy - second pass"));
	converter.exportcallbacks().Add(l_XSIPass2Traverser);

	if (l_lType != EXPORT_ALLMATERIALS)
	{
		l_XSIPass2Traverser->callbacks().Add(new CMeshClusterFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR));

		// in shape animation "plot all animation" mode, we do not export the envelope operator since the
		// envelope deformation is plotted.
		LONG l_ShapeAnimType = exportProp.GetParameterValue(L"ShapeAnim");

		if ( l_ShapeAnimType != CShapeAnimationFromXSI::PLOT_SHAPES )
		{
			l_XSIPass2Traverser->callbacks().Add(new CEnvelopeFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR));
		}

		/* NO IK PRESERVATION
		if (l_lType == EXPORT_TYPE_ALL && !l_bPreserveIK)
		{
		CIKtoFKFromXSI						*l_pIKtoFK = new CIKtoFKFromXSI();
		l_pIKtoFK->SetAnimationPlotter(l_pAnimationPlotter);
		l_XSIPass2Traverser->callbacks().Add(l_pIKtoFK);
		}
		*/

		// Optimizers phase
		converter.exportcallbacks().Add(new CProcessTimer(L"Plotting animations"));
		converter.exportcallbacks().Add(l_pAnimationPlotter);

		converter.exportcallbacks().Add(new CMaterialLibraryFromXSI_RemoveUnused());
		converter.exportcallbacks().Add(new CXSIImageLibraryFromXSI_RemoveUnused());

	}

	// This is where we populate the list of write callbacks
	// This callback writes the content of the FTK as a dotXSI
	converter.writecallbacks().Add(new CProcessTimer(L"Writing file"));

	if ( l_lFormat == COLLADA_FORMAT_1_4_1 )
	{
		converter.writecallbacks().Add(new CCOLLADA_Write());
	} else {
		converter.writecallbacks().Add(new CdotXSI_Write());
	}

	converter.writecallbacks().Add(new CProcessTimer(L"Export completed"));

	// Converts the XSI scene to dotXSI
	CProcessTimer::Reset();
	_XSI_CALL(converter.ConvertFromXSI(), L"Failed to convert scene");

	if (!converter.IsCancelPressed())
	{    
		// Write the file
		_XSI_CALL(converter.Write(), L"Failed to write");
	}

	HideClusters();

	return status;
}
