//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/****************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/

/*! \file dotXSIConverterCallback.h   
    Definition file for the CdotXSIConverterCallback class
*/

#include "stdafx.h"
#include <xsi_status.h>
#include <xsi_application.h>


/****************************************************************************************
To make sure we use the XSI namespace
****************************************************************************************/
using namespace XSI;


#ifndef _DOTXSICONVERTERCALLBACK_H
#define _DOTXSICONVERTERCALLBACK_H



//! Class CdotXSIConverterCallback
/*!
    This is the class that implements the low level dotXSI converter functionality. 
	This class is a callback that is sequenced by the CdotXSIConverter class to do the
	conversion.
*/
class CdotXSIConverter;
class CdotXSIConverterCallback
{

public:

/****************************************************************************************
Constructors/Destructors
****************************************************************************************/

//! Default constructor
	CdotXSIConverterCallback();

//! Default destructor
	virtual ~CdotXSIConverterCallback();

/****************************************************************************************
Member access
****************************************************************************************/
	
/****************************************************************************************
Execution method
****************************************************************************************/

//! Executes the callback
/*!
	\param in_pContext The converter context to be used in the execution
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();

private:

	

};






#endif _DOTXSICONVERTERCALLBACK_H