//***************************************************************************************
//
// File supervisor: Softimage 3D Games & 3D Bridge team
//
// (c) Copyright 1999-2003 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/****************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2003 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
#include "stdafx.h"
#include "CrytekDisplay.h"
#include <xsi_decl.h>
#include <xsi_application.h>
#include <xsi_ref.h>
#include <xsi_customproperty.h>
#include <xsi_context.h>
#include <xsi_ppglayout.h>

/*

//****************************************************************************************
// DLL MAIN
//****************************************************************************************

#ifndef XSI_STATIC_LINK
BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
			break;
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
			break;
		case DLL_PROCESS_DETACH:
			break;
    }
    return TRUE;
}
#endif

// ****************************************************************************************
// XSI plugin registration 
// ****************************************************************************************

RTSHADER_API XSI::CStatus XSILoadPlugin( XSI::PluginRegistrar& in_reg )
{
	in_reg.PutAuthor( L"Softimage co." );
	in_reg.PutName( L"Crytek Display" );
	in_reg.PutVersion( 1, 0 );

	in_reg.RegisterDisplayPass( L"Crytek" );

	in_reg.RegisterProperty( L"CrytekDisplayOptions" );

	// *******************************************************************
	// Initialize the global context
	// *******************************************************************

	return XSI::CStatus::OK;	

}

RTSHADER_API XSI::CStatus XSIUnloadPlugin( const XSI::PluginRegistrar& in_reg )
{
	return XSI::CStatus::OK;
}
*/

/ ****************************************************************************************
XSI plugin custom properties function
**************************************************************************************** /
_XSI_EXTERN_ XSI::CStatus CrytekDisplayOptions_Define( const XSI::CRef & in_Ctx )
{
	XSI::CStatus status = XSI::CStatus::OK;
	XSI::Application app ;
	XSI::CustomProperty prop = XSI::Context(in_Ctx).GetSource() ;
	XSI::Parameter param ;

	// Default capabilities for most of these parameters
	int caps = XSI::siPersistable;
	XSI::CValue dft ;	// Used for arguments we don't want to set


	dft = (LONG)0;
	prop.AddParameter(	L"Channel",XSI::CValue::siString, caps,
						L"Channel", L"",
						dft, param ) ;

	prop.AddParameter(	L"Channel",XSI::CValue::siUInt4 , caps, 
						L"Channel", L"", 
						dft, param ) ;	

	param.PutValue(XSI::CValue((LONG)0L));

	return status;
}

_XSI_EXTERN_ XSI::CStatus CrytekDisplayOptions_DefineLayout( const XSI::CRef & in_Ctx )
{
	XSI::CStatus status = XSI::CStatus::OK;
	XSI::CString l_Empty;

	// XSI will call this to define the visual appearance of the CustomProperty
	// The layout is shared between all instances of the CustomProperty
	// and is cached.  You can force the code to re-execute by using the 
	// XSIUtils.Refresh feature.
	
	XSI::PPGLayout oLayout = XSI::Context( in_Ctx ).GetSource() ;
	XSI::PPGItem item ;

	oLayout.AddRow();
	oLayout.AddGroup(L"Vertex Color Display Channel", true, 75);
	XSI::CValueArray comboItemsFormat( 8 ) ;
	comboItemsFormat[0] = L"Red"; comboItemsFormat[1] = XSI::CValue((LONG)0) ;
	comboItemsFormat[2] = L"Green"; comboItemsFormat[3] = XSI::CValue((LONG)1) ;
	comboItemsFormat[4] = L"Blue";  comboItemsFormat[5] = XSI::CValue((LONG)2) ;
	comboItemsFormat[6] = L"All (RGB)"; comboItemsFormat[7] = XSI::CValue((LONG)3) ;
	item = oLayout.AddEnumControl( L"Channel", comboItemsFormat, l_Empty, XSI::siControlCombo ) ;
	item.PutAttribute( XSI::siUINoLabel, true ) ;

	oLayout.EndGroup();

	return status;
}
