//***************************************************************************************
//
// File supervisor: Softimage 3D Games & 3D Bridge team
//
// (c) Copyright 1999-2003 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/****************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2003 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/

#include "CrytekRTS.h"
#include "xsi_application.h"
#include "xsi_property.h"
#include "xsi_model.h"

//****************************************************************************************
// globals
//****************************************************************************************

//****************************************************************************************
// property page structure
//****************************************************************************************

// All structures that are used to construct a PPG must be compiled without padding 
// between struct fields.  This is because a pointer to the PPG struct will be initialized 
// directly by type casting a void pointer as in the following:
//
//   MyPPG * my_ppg = (MyPPG*) in_pVoid;
//
// The pragma is not necessary under a 32 bit architecture since a PPG will only contain
// floats (4 bytes), longs (4 bytes) and pointers (4 bytes).  Therefore structs will 
// never contain padding.  But, in a 64 bit architecture where pointers are 8 bytes, 
// if we don't force the compiler to remove the automatic padding, the struct may contain
// padding.  This padding is not considered when initializing the void pointer (in_pVoid).
// Therefore, the direct type casting would not work.
#pragma pack(push, 1)
typedef struct 
{
	LONG						Channel;
} CrytekVertexColorPPG;
#pragma pack(pop)

//****************************************************************************************
// Implementation
//****************************************************************************************


//****************************************************************************************
// Implementation
//****************************************************************************************
RTSHADER_API bool CrytekVertexColor_Init	
(
	XSI_RTS_SystemParams			*in_pSysParams,					//! The system parameters
	void							*in_pParams,					//! The property page parameters
	void							**io_pShaderInstanceData		//! The shader instance data
)
{
	return TRUE;
}

RTSHADER_API bool CrytekVertexColor_Execute		
(
	XSI_RTS_SystemParams			*in_pSysParams,					//! The system parameters
	void							*in_pParams,					//! The property page parameters
	XSI_RTS_TriangulatedGeometry	*in_pGeom,						//! The geometry information
	void							**io_pShaderInstanceData		//! The shader instance data
)
{
	bool			result = TRUE;

	CrytekVertexColorPPG	*ppg = (CrytekVertexColorPPG *) in_pParams;

	XSI::Application app;
	XSI::Property prop = app.GetActiveSceneRoot().GetProperties().GetItem( L"CrytekDisplayOptions" ) ;
					
	if (!prop.IsValid())
	{
		prop = app.GetActiveSceneRoot().AddProperty( L"CrytekDisplayOptions" ) ;
	}

	int l_Channel = 0;

	// if there is a vertex color channel, draw it according to the ppg property
	if (in_pGeom->m_lNbColorStreams > 0)
	{
		//From CrytekDisplayOptions
		if (ppg->Channel == -1)
		{
			l_Channel = prop.GetParameterValue(L"Channel");
		}
		else
		{
			l_Channel = ppg->Channel;
		}
	}

	// Draw
	unsigned int i;
	int j;

	glDisable(GL_LIGHTING);

	XSI_RTS_TriangulatedGeometry	tmpGeom = *in_pGeom; // just a temporary placeholder

	if (in_pGeom->m_Type == RTS_TL_SINGLE_INDEX_ARRAY)
	{
		unsigned int					loop;
		// Set the position array
		glEnableClientState( GL_VERTEX_ARRAY );
		glVertexPointer
		(
			3, 
			GL_FLOAT,
			0,
			tmpGeom.m_pPositionArray
		);

		glDisableClientState( GL_COLOR_ARRAY );
		glDisableClientState( GL_TEXTURE_COORD_ARRAY );

		// Colors
		if(tmpGeom.m_pColorArray)
		{
			unsigned int l_ColorIndex = 0;
			unsigned int loop2 = 0;

			// Draw triangles 
			for(i = 0; i < tmpGeom.m_lNbTriangleLists ; i++)
			{			
				for (loop = 0; loop < tmpGeom.m_pTriangleLists[i].m_lNbVertices; loop++)
				{
					for (loop2 = 0; loop2 < tmpGeom.m_lNbColorStreams; loop2++)
					{
						switch(l_Channel)
						{
						case RED_CHANNEL:
							tmpGeom.m_pColorArray[l_ColorIndex].m_green = 0;
							tmpGeom.m_pColorArray[l_ColorIndex].m_blue = 0;
							tmpGeom.m_pColorArray[l_ColorIndex].m_alpha = 0;
							break;
						case GREEN_CHANNEL:
							tmpGeom.m_pColorArray[l_ColorIndex].m_red = 0;
							tmpGeom.m_pColorArray[l_ColorIndex].m_blue = 0;
							tmpGeom.m_pColorArray[l_ColorIndex].m_alpha = 0;
							break;
						case BLUE_CHANNEL:
							tmpGeom.m_pColorArray[l_ColorIndex].m_red = 0;
							tmpGeom.m_pColorArray[l_ColorIndex].m_green = 0;
							tmpGeom.m_pColorArray[l_ColorIndex].m_alpha = 0;
							break;
						case ALPHA_CHANNEL:
							tmpGeom.m_pColorArray[l_ColorIndex].m_red = 0;
							tmpGeom.m_pColorArray[l_ColorIndex].m_green = 0;
							tmpGeom.m_pColorArray[l_ColorIndex].m_blue = 0;
							break;
						}

						l_ColorIndex++;
					}
				}
			}

			glEnableClientState( GL_COLOR_ARRAY );
			glColorPointer
				(
				4,
				GL_UNSIGNED_BYTE,
				(tmpGeom.m_lNbColorStreams) * sizeof(XSI_RTS_ColorRGBA),
				tmpGeom.m_pColorArray
				);
		}

		// Draw triangles 
		for(i = 0; i < tmpGeom.m_lNbTriangleLists ; i++)
		{	
			if(in_pSysParams->m_pGLExtFuncs->glDrawRangeElementsEXT)
			{
				in_pSysParams->m_pGLExtFuncs->glDrawRangeElementsEXT
				(
					tmpGeom.m_pTriangleLists[i].m_lType,
					tmpGeom.m_pTriangleLists[i].m_lMinIndex, 
					tmpGeom.m_pTriangleLists[i].m_lMaxIndex,
					tmpGeom.m_pTriangleLists[i].m_lNbVertices,
					GL_UNSIGNED_INT,
					tmpGeom.m_pIndices + tmpGeom.m_pTriangleLists[i].m_lOffset
				);
			}
			else
			{
				glDrawElements(tmpGeom.m_pTriangleLists[i].m_lType, tmpGeom.m_pTriangleLists[i].m_lNbVertices, GL_UNSIGNED_INT, tmpGeom.m_pIndices + tmpGeom.m_pTriangleLists[i].m_lOffset);
			}
		}
	}
	else
	{
		for(i = 0; i < in_pGeom->m_lNbTriangleLists; i++)
		{
			int nbVertices = in_pGeom->m_pTriangleLists[i].m_lNbVertices;
			int offset = in_pGeom->m_pTriangleLists[i].m_lOffset;

			if(in_pGeom->m_Type == RTS_TL_BYREF)
			{
				tmpGeom.m_pPositionPtrArray = in_pGeom->m_pPositionPtrArray + offset;
			}
			else if( in_pGeom->m_Type == RTS_TL_BYREF_POSD)
			{
				tmpGeom.m_pPositionDPtrArray = in_pGeom->m_pPositionDPtrArray + offset;
			}

			if(tmpGeom.m_pColorPtrArray)
				tmpGeom.m_pColorPtrArray = in_pGeom->m_pColorPtrArray + offset;

			glBegin(in_pGeom->m_pTriangleLists[i].m_lType);
			for(j = 0; j < nbVertices; j++)
			{	
				// Colors
				if(in_pGeom->m_pColorPtrArray)
				{
					switch(l_Channel)
					{
					case RED_CHANNEL:
						glColor4ub(tmpGeom.m_pColorPtrArray[j]->m_red, 0, 0, 1);
						break;
					case GREEN_CHANNEL:
						glColor4ub(0, tmpGeom.m_pColorPtrArray[j]->m_green, 0, 1);
						break;
					case BLUE_CHANNEL:
						glColor4ub(0, 0, tmpGeom.m_pColorPtrArray[j]->m_blue, 1);
						break;
					case ALPHA_CHANNEL:
						glColor4ub(tmpGeom.m_pColorPtrArray[j]->m_alpha, tmpGeom.m_pColorPtrArray[j]->m_alpha, tmpGeom.m_pColorPtrArray[j]->m_alpha, 1);
						break;
					case ALL_CHANNEL:
						glColor4ub(tmpGeom.m_pColorPtrArray[j]->m_red, tmpGeom.m_pColorPtrArray[j]->m_green, tmpGeom.m_pColorPtrArray[j]->m_blue, 1);
						break;
					}
				}
				else
				{
					glColor4f(0.0,0.0,0.0,1.0);
				}

				if(in_pGeom->m_Type == RTS_TL_BYREF)
				{
					glVertex3fv
					(
						&tmpGeom.m_pPositionPtrArray[j]->m_x
					);
				}
				else if( in_pGeom->m_Type == RTS_TL_BYREF_POSD)
				{
					glVertex3dv
					(
						&tmpGeom.m_pPositionDPtrArray[j]->m_x
					);
				}
				else if (in_pGeom->m_Type == RTS_TL_SINGLE_INDEX_ARRAY)
				{
					glVertex3fv
					(
						&tmpGeom.m_pPositionPtrArray[j]->m_x
					);
				}
			}
			glEnd();
		}
	}

	return result;
}

RTSHADER_API bool CrytekVertexColor_GetRequirements		
(
	XSI_RTS_SystemParams			*in_pSysParams,					//! The system parameters
	void							*in_pParams,					//! The property page parameters
	XSI_RTS_TriangulatedGeometry	*in_pGeom,						//! The geometry information
	void							**io_pShaderInstanceData,		//! The shader instance data
	ULONG					in_lFlag,						//! The flag to check
	ULONG					*out_pValue						//! The returned value
)
{
	return true;
}
