//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/****************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/

/*! \file cmdstubs.h   
    command function stubs definition for XSI v4.2.2004.1216-QFE2
*/

#include <xsi_application.h>
#include <xsi_value.h>
#include <xsi_status.h>
#include <xsi_string.h>

#ifndef _CMDSTUBS_H_
#define _CMDSTUBS_H_

#ifndef EXPORTSTUBS
#ifdef WIN32
#define EXPORTSTUBS __declspec(dllexport)
#else
#define EXPORTSTUBS 
#endif
#endif

namespace XSI {
namespace COMMANDS {

	EXPORTSTUBS void AbortFramePreview( void );
	EXPORTSTUBS void AcclaimImport( const CString& in_skeletonfilename, const CString& in_motionfilename, bool in_cropmotionvaluestolimit, bool in_overridebonelengthmultiplier, const CValue& /*number*/ in_bonelengthmultiplier, bool in_insermotion, bool in_nullshierarchy, bool in_gaplessskeleton, bool in_si3dchains, bool in_groupanimobjs );
	EXPORTSTUBS void ActivateEdgeSelTool( const CString& in_selregionmode );
	EXPORTSTUBS void ActivateEdgeSelToolWithNoObjStateChange( const CString& in_selregionmode );
	EXPORTSTUBS void ActivateElements( const CValue& /*undefined*/ in_selectionlist );
	EXPORTSTUBS CValue ActivateExternalConstraints( const CValue& /*undefined*/ in_inputobj, const CString& in_operation );
	EXPORTSTUBS void ActivateFCurve( const CValue& /*undefined*/ in_inputobjs, bool in_activate, const CValue& /*undefined*/ in_startframe, const CValue& /*undefined*/ in_endframe );
	EXPORTSTUBS void ActivateMarkingSet( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void ActivateObjectSelTool( const CString& in_selregionmode );
	EXPORTSTUBS void ActivateObjectSelToolWithNoObjStateChange( void );
	EXPORTSTUBS void ActivatePolygonSelTool( const CString& in_selregionmode );
	EXPORTSTUBS void ActivatePolygonSelToolWithNoObjStateChange( const CString& in_selregionmode );
	EXPORTSTUBS void ActivateRaycastEdgeSelTool( const CString& in_selregionmode );
	EXPORTSTUBS void ActivateRaycastEdgeSelToolWithNoObjStateChange( const CString& in_selregionmode );
	EXPORTSTUBS void ActivateRaycastPolySelTool( const CString& in_selregionmode );
	EXPORTSTUBS void ActivateRaycastPolySelToolWithNoObjStateChange( const CString& in_selregionmode );
	EXPORTSTUBS void ActivateSampledPointSelTool( const CString& in_selregionmode );
	EXPORTSTUBS void ActivateSampledPointSelToolWithNoObjStateChange( const CString& in_selregionmode );
	EXPORTSTUBS void ActivateTipSelTool( const CString& in_selregionmode );
	EXPORTSTUBS void ActivateVertexSelTool( const CString& in_selregionmode );
	EXPORTSTUBS void ActivateVertexSelToolWithNoObjStateChange( const CString& in_selregionmode );
	EXPORTSTUBS CValue Add2DShape( const CValue& /*undefined*/ in_shapelist, const CString& in_shapetype, const CRef& /*object*/ in_value );
	EXPORTSTUBS CValue Add2DShapePoint( const CValue& /*undefined*/ in_shape, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y, const CValue& /*number*/ in_value );
	EXPORTSTUBS void Add2DShapePointArray( const CValue& /*undefined*/ in_shape, const CValue& /*undefined*/ in_points );
	EXPORTSTUBS void Add3DObjectToScene( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_parent );
	EXPORTSTUBS CValue AddAlphaFloodFillPaintShape( const CValue& /*undefined*/ in_shapelist, const CValue& /*number*/ in_seedx, const CValue& /*number*/ in_seedy, const CRef& /*object*/ in_value );
	EXPORTSTUBS CValue AddAudioClip( const CValue& /*undefined*/ in_model, const CValue& /*undefined*/ in_source, const CValue& /*undefined*/ in_compound, const CValue& /*undefined*/ in_track, const CValue& /*undefined*/ in_time, const CString& in_name );
	EXPORTSTUBS void AddBoneToEnd( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue AddBoundaryFillPaintShape( const CValue& /*undefined*/ in_shapelist, const CValue& /*number*/ in_seedx, const CValue& /*number*/ in_seedy, const CRef& /*object*/ in_value );
	EXPORTSTUBS CValue AddBridgeTransition( const CValue& /*undefined*/ in_from, const CValue& /*undefined*/ in_to, const CString& in_name );
	EXPORTSTUBS CValue AddBrushStroke( const CValue& /*undefined*/ in_shapelist, const CValue& /*undefined*/ in_points, const CValue& /*undefined*/ in_pressure, const CValue& /*number*/ in_index, const CRef& /*object*/ in_value );
	EXPORTSTUBS CValue AddBVHAction( const CValue& /*undefined*/ in_arg0, const CValue& /*undefined*/ in_arg1, const CValue& /*undefined*/ in_arg2, const CValue& /*undefined*/ in_arg3, const CValue& /*undefined*/ in_arg4, const CValue& /*undefined*/ in_arg5, const CValue& /*undefined*/ in_arg6, const CValue& /*undefined*/ in_arg7 );
	EXPORTSTUBS CValue AddClearImageShape( const CValue& /*undefined*/ in_shapelist, const CRef& /*object*/ in_value );
	EXPORTSTUBS CValue AddClip( const CValue& /*undefined*/ in_model, const CValue& /*undefined*/ in_source, const CValue& /*undefined*/ in_compound, const CValue& /*undefined*/ in_track, const CValue& /*undefined*/ in_time, const CString& in_name, const CValue& /*undefined*/ in_connectionmappingtemplate, const CValue& /*undefined*/ in_valuemappingtemplate, bool in_shareparent );
	EXPORTSTUBS CValue AddClipRelation( const CValue& /*undefined*/ in_from, const CValue& /*undefined*/ in_to, const CString& in_name );
	EXPORTSTUBS CValue AddClipTextureLayer( const CValue& /*undefined*/ in_clip, const CValue& /*undefined*/ in_inputobjs, const CString& in_name, bool in_after, const CValue& /*undefined*/ in_reference );
	EXPORTSTUBS void AddClothClusters( const CValue& /*undefined*/ in_inputobj, bool in_interactive );
	EXPORTSTUBS CValue AddColorPaintShape( const CValue& /*undefined*/ in_shapelist, const CRef& /*object*/ in_value );
	EXPORTSTUBS CValue AddColSphere( void );
	EXPORTSTUBS void AddComponentTool( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue AddContainerToEnvironment( const CValue& /*undefined*/ in_environment, const CString& in_type, bool in_support3dobject, const CString& in_name, const CRef& /*object*/ in_container );
	EXPORTSTUBS CValue AddEdge( const CValue& /*undefined*/ in_connectionset, const CValue& /*number*/ in_ratio, siOperationMode in_immediatemode, const CValue& /*number*/ in_newpointid, const CValue& /*number*/ in_newedgeid );
	EXPORTSTUBS CValue AddEllipsePaintShape( const CValue& /*undefined*/ in_shapelist, const CValue& /*number*/ in_x1, const CValue& /*number*/ in_y1, const CValue& /*number*/ in_x2, const CValue& /*number*/ in_y2, bool in_fromcenter, const CRef& /*object*/ in_value );
	EXPORTSTUBS void AddExpr( const CValue& /*undefined*/ in_inputobj, const CString& in_exprstr, bool in_disableautoinspect );
	EXPORTSTUBS void AddFCurve( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue AddFloodFillPaintShape( const CValue& /*undefined*/ in_shapelist, const CValue& /*number*/ in_seedx, const CValue& /*number*/ in_seedy, const CRef& /*object*/ in_value );
	EXPORTSTUBS CValue AddFloor( void );
	EXPORTSTUBS CValue AddFxMaskShape( const CValue& /*undefined*/ in_shapelist, const CRef& /*object*/ in_value );
	EXPORTSTUBS CValue AddFxOp( const CValue& /*undefined*/ in_fxtree, const CString& in_presetname, const CRef& /*object*/ in_value );
	EXPORTSTUBS void AddGroup( const CValue& /*undefined*/ in_target, const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void AddHelperBone( const CValue& /*undefined*/ in_rig, const CValue& /*undefined*/ in_root, const CValue& /*undefined*/ in_parent, const CValue& /*undefined*/ in_child );
	EXPORTSTUBS void AddHelperTrigger( const CValue& /*undefined*/ in_helper, const CValue& /*undefined*/ in_bone1, const CValue& /*undefined*/ in_bone2 );
	EXPORTSTUBS CValue AddImageClip( const CValue& /*undefined*/ in_source, const CString& in_name, const CString& in_value );
	EXPORTSTUBS CValue AddImageClipFxOp( const CValue& /*undefined*/ in_fxtree, const CValue& /*undefined*/ in_imageclip, const CRef& /*object*/ in_value );
	EXPORTSTUBS CValue AddImageSource( const CString& in_filename, const CString& in_name, const CString& in_value );
	EXPORTSTUBS CValue AddImageTextureLayer( const CString& in_filename, const CValue& /*undefined*/ in_inputobjs, const CString& in_name, bool in_after, const CValue& /*undefined*/ in_reference );
	EXPORTSTUBS void AddInputToOperator( const CValue& /*undefined*/ in_reference, const CValue& /*undefined*/ in_new );
	EXPORTSTUBS CValue AddJointLimit( void );
	EXPORTSTUBS void AddMappingNode( const CValue& /*undefined*/ in_operator, const CValue& /*undefined*/ in_propobj, const CRef& /*object*/ in_mappingnodeprop, const CRef& /*object*/ in_mapmixerop );
	EXPORTSTUBS void AddMappingRule( const CValue& /*undefined*/ in_mappingtemplate, const CString& in_from, const CString& in_to, const CValue& /*number*/ in_index );
	EXPORTSTUBS CValue AddMarker( const CValue& /*undefined*/ in_model, const CValue& /*undefined*/ in_container, const CValue& /*undefined*/ in_time, const CValue& /*number*/ in_duration, const CString& in_name );
	EXPORTSTUBS CValue AddModelClip( const CString& in_source, const CString& in_name, const CString& in_value );
	EXPORTSTUBS CValue AddModelSource( const CString& in_filename, const CString& in_name, const CValue& /*number*/ in_resolution, const CString& in_value );
	EXPORTSTUBS void AddObjectsToShader( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_target );
	EXPORTSTUBS CValue AddPaintMaskShape( const CValue& /*number*/ in_selectionaction, bool in_antialiased, const CValue& /*number*/ in_feather, const CRef& /*object*/ in_value );
	EXPORTSTUBS CValue AddPaintShapePoint( const CValue& /*undefined*/ in_shape, const CValue& /*number*/ in_insertposition, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y, const CValue& /*number*/ in_lhx, const CValue& /*number*/ in_lhy, const CValue& /*number*/ in_rhx, const CValue& /*number*/ in_rhy, const CValue& /*number*/ in_value );
	EXPORTSTUBS void AddParticleEmitter( const CValue& /*undefined*/ in_target, const CValue& /*undefined*/ in_inputobj, bool in_interactive );
	EXPORTSTUBS void AddParticleEvent( const CString& in_target, const CString& in_source, const CRef& /*object*/ in_output );
	EXPORTSTUBS void AddParticleForce( const CString& in_target, const CString& in_inputobj );
	EXPORTSTUBS void AddParticleGoal( const CString& in_target, const CString& in_inputobj, const CRef& /*object*/ in_output );
	EXPORTSTUBS void AddParticleObstacle( const CString& in_target, const CString& in_inputobj );
	EXPORTSTUBS CValue AddParticles( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_partype, const CValue& /*undefined*/ in_positions, const CValue& /*undefined*/ in_velocities, bool in_world_referential );
	EXPORTSTUBS void AddParticleTool( const CString& in_clsid );
	EXPORTSTUBS CValue AddPassInputFxOp( const CValue& /*undefined*/ in_fxtree, const CValue& /*undefined*/ in_renderpass, const CRef& /*object*/ in_value );
	EXPORTSTUBS void AddPointInteriorToPolygon( const CValue& /*undefined*/ in_operator, const CValue& /*number*/ in_polygonid, const CValue& /*number*/ in_firstoffset, const CValue& /*number*/ in_secondoffset, const CValue& /*number*/ in_thirdoffset, const CValue& /*number*/ in_firstweight, const CValue& /*number*/ in_secondweight, const CValue& /*number*/ in_thirdweight, const CValue& /*number*/ in_height );
	EXPORTSTUBS void AddPointOnCurveToolByCVs( const CString& in_clsid );
	EXPORTSTUBS void AddPointOnCurveToolByKnotPoints( const CString& in_clsid );
	EXPORTSTUBS CValue AddPointToNewPolygon( const CValue& /*undefined*/ in_inputobj, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y, const CValue& /*number*/ in_z, const CValue& /*number*/ in_insertposition, const CValue& /*number*/ in_polygonid );
	EXPORTSTUBS void AddPoseActionItems( const CValue& /*undefined*/ in_inputobjs, const CString& in_name );
	EXPORTSTUBS CValue AddPresetTextureLayer( const CString& in_presetobj, const CValue& /*undefined*/ in_inputobjs, const CString& in_name, bool in_after, const CValue& /*undefined*/ in_reference );
	EXPORTSTUBS void AddProp( const CString& in_presetobj, const CString& in_inputobjs, const CString& in_propagation, const CString& in_propertyname, const CRef& /*object*/ in_value );
	EXPORTSTUBS void AddProxyParam( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_proxied, const CString& in_prefix );
	EXPORTSTUBS CValue AddRectanglePaintShape( const CValue& /*undefined*/ in_shapelist, const CValue& /*number*/ in_x1, const CValue& /*number*/ in_y1, const CValue& /*number*/ in_x2, const CValue& /*number*/ in_y2, bool in_fromcenter, const CRef& /*object*/ in_value );
	EXPORTSTUBS CValue AddScriptedOp( const CValue& /*undefined*/ in_outputobjs, const CString& in_code, const CValue& /*undefined*/ in_inputobjs, const CString& in_name, const CString& in_language, const CValue& /*undefined*/ in_constructionmode );
	EXPORTSTUBS CValue AddScriptedOpFromFile( const CValue& /*undefined*/ in_outputobjs, const CString& in_filename, const CValue& /*undefined*/ in_inputobjs, const CString& in_name, const CString& in_language, const CValue& /*undefined*/ in_constructionmode );
	EXPORTSTUBS CValue AddTextureLayer( const CValue& /*undefined*/ in_object, const CValue& /*undefined*/ in_inputobjs, const CString& in_name, bool in_after, const CValue& /*undefined*/ in_reference );
	EXPORTSTUBS CValue AddTextureLayerPorts( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void AddToCluster( const CString& in_inputobjs, siActionWhenLocalMaterialsOverlap in_actionwhenlocalmaterialsoverlap );
	EXPORTSTUBS void AddToContainer( const CString& in_target, const CString& in_inputobjs );
	EXPORTSTUBS void AddToGroup( const CString& in_target, const CString& in_inputobjs );
	EXPORTSTUBS void AddToMarking( const CValue& /*undefined*/ in_pathlist );
	EXPORTSTUBS void AddToPaintShapePointSelection( const CValue& /*undefined*/ in_shape, const CValue& /*undefined*/ in_indices );
	EXPORTSTUBS void AddToPartition( const CValue& /*undefined*/ in_target, const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void AddToSelection( const CValue& /*undefined*/ in_selectionlist, const CString& in_hierarchylevel, bool in_checkobjectselectability );
	EXPORTSTUBS void AddToTOC( const CValue& /*undefined*/ in_source );
	EXPORTSTUBS CValue AddTrack( const CValue& /*undefined*/ in_model, const CValue& /*undefined*/ in_compound, const CValue& /*number*/ in_type, const CString& in_name, const CValue& /*number*/ in_insertposition );
	EXPORTSTUBS CValue AddTransition( const CValue& /*undefined*/ in_from, const CValue& /*undefined*/ in_to, const CValue& /*number*/ in_type, const CString& in_name );
	EXPORTSTUBS CValue AddTWTransition( const CValue& /*undefined*/ in_from, const CValue& /*undefined*/ in_to, const CValue& /*number*/ in_from_period, const CValue& /*number*/ in_to_period, const CString& in_name );
	EXPORTSTUBS void AddUserParameter( const CValue& /*undefined*/ in_target, const CString& in_name, const CValue& /*number*/ in_type );
	EXPORTSTUBS void AddVertexTool( const CString& in_clsid );
	EXPORTSTUBS void Align( const CValue& /*undefined*/ in_inputobjs, siAxesFilter in_alignaxes, siAlignModes in_posx, siAlignModes in_posy, siAlignModes in_posz, siAlignModes in_refx, siAlignModes in_refy, siAlignModes in_refz, bool in_allobjects );
	EXPORTSTUBS void AlignRootToFirstBone( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue AppendBone( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_ex, const CValue& /*number*/ in_ey, const CValue& /*number*/ in_ez, bool in_pin );
	EXPORTSTUBS void ApplyAction( const CValue& /*undefined*/ in_source, const CValue& /*undefined*/ in_target, bool in_consider_time, const CValue& /*number*/ in_startframe, const CValue& /*number*/ in_endframe, bool in_ripple );
	EXPORTSTUBS CValue ApplyCloth( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue ApplyCns( const CString& in_presetobj, const CValue& /*undefined*/ in_constrainedobj, const CValue& /*undefined*/ in_constrainingobj, bool in_compensation );
	EXPORTSTUBS CValue ApplyDeformByCage( const CValue& /*undefined*/ in_connectionset, const CValue& /*undefined*/ in_constructionmode );
	EXPORTSTUBS void ApplyDeformBySpine( const CString& in_connectionset, const CValue& /*undefined*/ in_constructionmode );
	EXPORTSTUBS CValue ApplyDeformKey( const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS CValue ApplyFlexEnv( const CValue& /*undefined*/ in_connectionset, bool in_assignnewdeformers, const CValue& /*undefined*/ in_constructionmode );
	EXPORTSTUBS void ApplyGenOp( const CString& in_presetobj, const CString& in_target, const CString& in_connectionset, const CValue& /*number*/ in_connecttype, siOperationMode in_immediatemode, siGeneratorInputsDisposalMode in_genopinputsdisposal, const CRef& /*object*/ in_outputobjs );
	EXPORTSTUBS CValue ApplyHairAttenuateOp( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue ApplyHairClumpOp( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue ApplyHairCombNormalOp( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue ApplyHairCombOp( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y, const CValue& /*number*/ in_z );
	EXPORTSTUBS CValue ApplyHairCutOp( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue ApplyHairDynamicsOp( const CValue& /*undefined*/ in_in_objs );
	EXPORTSTUBS CValue ApplyHairLockOp( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue ApplyHairMergeOp( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue ApplyHairOp( const CValue& /*undefined*/ in_in_objs, const CString& in_presetobj );
	EXPORTSTUBS CValue ApplyHairPopOp( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue ApplyHairPopSelectedOp( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue ApplyHairPuffOp( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue ApplyHairRecombOp( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue ApplyHairResampleOp( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue ApplyHairRotateOp( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue ApplyHairScaleOp( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue ApplyHairShatterOp( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue ApplyHairSplineGenOp( const CValue& /*undefined*/ in_in_objs, const CString& in_presetobj );
	EXPORTSTUBS CValue ApplyHairSplitOp( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue ApplyHairUnlockOp( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void ApplyHelperBoneChanges( const CValue& /*undefined*/ in_prop );
	EXPORTSTUBS CValue ApplyKinematicOp( const CValue& /*undefined*/ in_presetobj, const CValue& /*undefined*/ in_connectionset, siBranchFlag in_connecttype );
	EXPORTSTUBS void ApplyOp( const CString& in_presetobj, const CString& in_connectionset, const CValue& /*number*/ in_connecttype, siOperationMode in_immediatemode, const CRef& /*object*/ in_outputobjs, const CValue& /*undefined*/ in_constructionmode );
	EXPORTSTUBS CValue ApplyOperator( const CValue& /*undefined*/ in_presetobj, const CValue& /*undefined*/ in_connectionset, siBranchFlag in_connecttype );
	EXPORTSTUBS void ApplyParticleShader( const CString& in_inputobjs, const CString& in_material, const CString& in_volume );
	EXPORTSTUBS void ApplyPath( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_path, const CValue& /*undefined*/ in_startframe, const CValue& /*undefined*/ in_endframe, const CValue& /*number*/ in_nbkeys, bool in_linear, bool in_tangent );
	EXPORTSTUBS CValue Applypolymatricks( const CString& in_target, const CValueArray&  in_stack );
	EXPORTSTUBS void ApplyPropVolumeOp( const CString& in_presetobj, const CString& in_connectionset, const CValue& /*number*/ in_connecttype, bool in_immediatemode, siOperationMode in_outputobjs, const CRef& /*object*/ in_constructionmode );
	EXPORTSTUBS void ApplyShader( const CString& in_presetobj, const CString& in_inputobjs, const CString& in_name, const CString& in_propagationtype, siActionWhenLocalMaterialsOverlap in_actionwhenlocalmaterialsoverlap );
	EXPORTSTUBS CValue ApplyShapeKey( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_compound, const CValue& /*undefined*/ in_track, const CValue& /*undefined*/ in_time, const CValue& /*undefined*/ in_duration, const CValue& /*undefined*/ in_mode, const CValue& /*undefined*/ in_name, const CValue& /*undefined*/ in_overwrite );
	EXPORTSTUBS void ApplySnapFaceOp( const CValue& /*undefined*/ in_connectionset, siBranchFlag in_connecttype, siOperationMode in_immediatemode, const CRef& /*object*/ in_outputobjs );
	EXPORTSTUBS CValue ApplySoftBody( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void ApplySpringOp( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_mass, const CValue& /*number*/ in_linearstiffness, const CValue& /*number*/ in_lineardamping, const CString& in_springcache, const CRef& /*object*/ in_outputobjs );
	EXPORTSTUBS void ApplyTopoOp( const CString& in_presetobj, const CString& in_connectionset, const CValue& /*number*/ in_connecttype, siOperationMode in_immediatemode, const CRef& /*object*/ in_outputobjs );
	EXPORTSTUBS void AssembleNurbsMesh( const CValue& /*undefined*/ in_inputobj, const CValue& /*number*/ in_tolerance, bool in_copyusercluster, bool in_copymaterial, bool in_centergeomcenter );
	EXPORTSTUBS void AssignMaterial( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void AssociateEnvelopeBoundingVolume( const CValue& /*undefined*/ in_inputobjs, const CString& in_bndvoltype );
	EXPORTSTUBS void AttachRigidBodies( const CString& in_name, const CValue& /*undefined*/ in_bodies, const CValue& /*number*/ in_px, const CValue& /*number*/ in_py, const CValue& /*number*/ in_pz );
	EXPORTSTUBS void AutoInspect( const CValue& /*undefined*/ in_inputobjs, const CString& in_title, siInspectMode in_mode, const CString& in_keywords );
	EXPORTSTUBS CValue AutoInspectEnabled( void );
	EXPORTSTUBS void BeginUndo( const CString& in_name );
	EXPORTSTUBS void BiovisionImport( const CString& in_filename, bool in_insermotion, bool in_nullshierarchy, bool in_gaplessskeleton, bool in_si3dchains, bool in_groupanimobjs );
	EXPORTSTUBS CValue BlendClipsInTextureLayers( const CValue& /*undefined*/ in_cliplist, const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_sharedmataction, bool in_notifynoresult, siBlendInTextureLayersModes in_mode, bool in_ambient, bool in_diffuse, bool in_transparency, bool in_reflection );
	EXPORTSTUBS CValue BlendClipsInTextureLayersInsp( const CValue& /*undefined*/ in_cliplist, const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_sharedmataction, bool in_notifynoresult, siBlendInTextureLayersModes in_mode, bool in_ambient, bool in_diffuse, bool in_transparency, bool in_reflection );
	EXPORTSTUBS CValue BlendClipsInTextureLayersWithPorts( const CValue& /*undefined*/ in_cliplist, const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue BlendClipsInTextureLayersWithPortsInsp( const CValue& /*undefined*/ in_cliplist, const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue BlendInPresets( const CString& in_presetnames, const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_sharedmataction, bool in_notifynoresult, siBlendInPresetModes in_mode, bool in_ambient, bool in_diffuse, bool in_transparency, bool in_reflection );
	EXPORTSTUBS CValue BlendInPresetsInsp( const CString& in_presetnames, const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_sharedmataction, bool in_notifynoresult, siBlendInPresetModes in_mode, bool in_ambient, bool in_diffuse, bool in_transparency, bool in_reflection );
	EXPORTSTUBS CValue BlendInPresetsWithPorts( const CString& in_presetnames, const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue BlendInPresetsWithPortsInsp( const CString& in_presetnames, const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue BlendInTextureLayers( const CString& in_presetnames, const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_sharedmataction, bool in_notifynoresult, siBlendInTextureLayersModes in_mode, bool in_ambient, bool in_diffuse, bool in_transparency, bool in_reflection );
	EXPORTSTUBS CValue BlendInTextureLayersInsp( const CString& in_presetnames, const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_sharedmataction, bool in_notifynoresult, siBlendInTextureLayersModes in_mode, bool in_ambient, bool in_diffuse, bool in_transparency, bool in_reflection );
	EXPORTSTUBS CValue BlendInTextureLayersWithPorts( const CString& in_presetnames, const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue BlendInTextureLayersWithPortsInsp( const CString& in_presetnames, const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void BreakChainAtBone( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void CamDollyTool( const CString& in_clsid );
	EXPORTSTUBS void CamDriveTool( const CString& in_clsid );
	EXPORTSTUBS void CameraRedo( const CValue& /*number*/ in_view );
	EXPORTSTUBS void CameraReset( const CValue& /*number*/ in_view, bool in_allviews );
	EXPORTSTUBS void CameraTextureProj( const CValue& /*undefined*/ in_inputobjs, const CString& in_name, const CString& in_camera );
	EXPORTSTUBS void CameraUndo( const CValue& /*number*/ in_view );
	EXPORTSTUBS void CamFlyTool( const CString& in_clsid );
	EXPORTSTUBS void CamNavigTool( const CString& in_clsid );
	EXPORTSTUBS void CamOrbitTool( const CString& in_clsid );
	EXPORTSTUBS void CamPanZoomTool( const CString& in_clsid );
	EXPORTSTUBS void CamPivotTool( const CString& in_clsid );
	EXPORTSTUBS void CamRectZoomTool( const CString& in_clsid );
	EXPORTSTUBS void CamRollTool( const CString& in_clsid );
	EXPORTSTUBS void CamTrackTool( const CString& in_clsid );
	EXPORTSTUBS void CamWalkTool( const CString& in_clsid );
	EXPORTSTUBS void CamZoomTool( const CString& in_clsid );
	EXPORTSTUBS void CaptureViewport( const CValue& /*number*/ in_target, bool in_interactive );
	EXPORTSTUBS CValue ChangeSubdivision( const CString& in_inputobj, bool in_updirection );
	EXPORTSTUBS void ClearImage( void );
	EXPORTSTUBS void ClearMarking( void );
	EXPORTSTUBS void ClearPaintClipFrameSelection( const CValue& /*undefined*/ in_paintclip );
	EXPORTSTUBS void ClearPaintSelection( void );
	EXPORTSTUBS void ClearParameterColor( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void ClearThumbnail( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void ClearUserKeyword( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void ClipMatch( const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS CValue Clone( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_nbitems, siDupParent in_hierarchy, siDupGroup in_grouping, siDupProperty in_properties, siDupAnimation in_animation, siDupConstraint in_constraints, siDupSelection in_selection, siDupTransform in_xfrom, const CString& in_sx, const CString& in_sy, const CString& in_sz, const CString& in_rx, const CString& in_ry, const CString& in_rz, const CString& in_tx, const CString& in_ty, const CString& in_tz, const CString& in_trackxform );
	EXPORTSTUBS void ClosestPaintShapeKey( const CValue& /*undefined*/ in_shape, const CValue& /*undefined*/ in_time );
	EXPORTSTUBS CValue ClusterNonOverlapEnforcement( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_property, siActionWhenLocalMaterialsOverlap in_actionwhenlocalmaterialsoverlap, const CRef& /*object*/ in_outputobj );
	EXPORTSTUBS void ClusterPropSetValues( const CRef& /*object*/ in_clusterprop );
	EXPORTSTUBS void CollapseOp( const CValue& /*undefined*/ in_inputobjs, bool in_relative, const CRef& /*object*/ in_collapseoperators );
	EXPORTSTUBS void ColorizeObject( const CValue& /*number*/ in_colorid );
	EXPORTSTUBS void ConnectBevelProfileCurve( const CValue& /*undefined*/ in_target, const CValue& /*undefined*/ in_source );
	EXPORTSTUBS void ConnectFxOp( const CValue& /*undefined*/ in_op1, const CValue& /*undefined*/ in_op2, const CString& in_connection );
	EXPORTSTUBS CValue ConnectImageTo3DO( const CValue& /*undefined*/ in_inputobjs, const CString& in_filename );
	EXPORTSTUBS void ConnectMap( const CValue& /*undefined*/ in_propobj, const CValue& /*undefined*/ in_target );
	EXPORTSTUBS CValue ConnectNewPolygonToEdge( const CValue& /*undefined*/ in_inputobj, const CValue& /*number*/ in_edgeid, const CValue& /*number*/ in_insertposition, bool in_invertpolygon );
	EXPORTSTUBS CValue ConnectNewPolygonToPoint( const CValue& /*undefined*/ in_inputobj, const CValue& /*number*/ in_pointid, const CValue& /*number*/ in_insertposition, bool in_invertpolygon );
	EXPORTSTUBS void ConnectOperatorParameter( const CValue& /*undefined*/ in_parameter, const CValue& /*undefined*/ in_projobj );
	EXPORTSTUBS void ConnectParticleInitState( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_initcloud );
	EXPORTSTUBS void ConnectPlaneReferenceToSlicePolygonsOp( const CValue& /*undefined*/ in_target, const CValue& /*undefined*/ in_source );
	EXPORTSTUBS void ConnectSource( const CValue& /*undefined*/ in_target, const CRef& /*object*/ in_inputobj );
	EXPORTSTUBS void ConnectToProjection( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_propertyname, const CValue& /*undefined*/ in_textureprojection );
	EXPORTSTUBS void ConnectToSupport( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_propertyname, const CValue& /*undefined*/ in_texturesupport );
	EXPORTSTUBS void ConnectToTextureProj( const CValue& /*undefined*/ in_inputobjs, const CString& in_name, const CString& in_texturesupport );
	EXPORTSTUBS void ConnectWeightMap( const CValue& /*undefined*/ in_operator, const CValue& /*undefined*/ in_propobj );
	EXPORTSTUBS void ConnectWeightMapToComponent( const CValue& /*undefined*/ in_target, const CValue& /*undefined*/ in_propobj );
	EXPORTSTUBS void Convert( const CString& in_target, const CString& in_source );
	EXPORTSTUBS void ConvertEulerToQuat( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void ConvertPosAnimToPath( const CValue& /*undefined*/ in_inputobjs, const CString& in_name, const CValue& /*undefined*/ in_starttime, const CValue& /*undefined*/ in_endtime, const CValue& /*undefined*/ in_stepframe );
	EXPORTSTUBS void ConvertQuatToEuler( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue ConvertScriptedOp( const CValue& /*undefined*/ in_source );
	EXPORTSTUBS void ConvertShapeReferenceMode( const CValue& /*undefined*/ in_inputobj, siShapeReferenceMode in_refmode );
	EXPORTSTUBS void Copy( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void CopyAllAnimation2( const CValue& /*undefined*/ in_inputobjs, siSourceType in_sourcemask, siParameterFilter in_parametermask, bool in_removeanimation );
	EXPORTSTUBS void CopyAnimation( const CValue& /*undefined*/ in_inputobjs, bool in_usefcurves, bool in_useexpressions, bool in_removeanimation );
	EXPORTSTUBS void CopyAnimContainer( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_target );
	EXPORTSTUBS CValue CopyClipToTrack( const CValue& /*undefined*/ in_model, const CValue& /*undefined*/ in_clip, const CValue& /*undefined*/ in_compound, const CValue& /*undefined*/ in_track, const CValue& /*undefined*/ in_time );
	EXPORTSTUBS void CopyCluster( const CValue& /*undefined*/ in_cluster, const CValue& /*undefined*/ in_target );
	EXPORTSTUBS void CopyExtFilesIntoProject( const CString& in_scenefilename, bool in_overwrite );
	EXPORTSTUBS void CopyFxOp( const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS void CopyKeys( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_startframe, const CValue& /*number*/ in_endframe, bool in_reset );
	EXPORTSTUBS void CopyPartition( const CValue& /*undefined*/ in_target, const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void CopyPaste( const CValue& /*undefined*/ in_source, const CString& in_filename, const CValue& /*undefined*/ in_target, const CValue& /*number*/ in_mode );
	EXPORTSTUBS void CopyRegionOptionsFromRender( const CString& in_from, const CString& in_to, const CString& in_area );
	EXPORTSTUBS void CopyRegionWindowFromRender( const CString& in_from, const CString& in_to );
	EXPORTSTUBS void CopyRenderOptions( const CString& in_from, const CString& in_to, const CString& in_area );
	EXPORTSTUBS void CopyRenderOptionsFromRegion( const CString& in_from, const CString& in_to, const CString& in_area );
	EXPORTSTUBS void CopyRenderWindow( const CString& in_from, const CString& in_to );
	EXPORTSTUBS void CopyRenderWindowFromRegion( const CString& in_from, const CString& in_to );
	EXPORTSTUBS void CopyShape( const CValue& /*undefined*/ in_source, const CValue& /*undefined*/ in_target );
	EXPORTSTUBS void CopySourceActionToFolder( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_target );
	EXPORTSTUBS void CopyStyle( const CValue& /*undefined*/ in_targethairobject, const CValue& /*undefined*/ in_modelhairstyleobject );
	EXPORTSTUBS void CopyUVW( const CValue& /*undefined*/ in_textureprojection, const CValue& /*undefined*/ in_subcomp );
	EXPORTSTUBS CValue Create2DMap( const CValue& /*undefined*/ in_inputobjs, const CString& in_propertyname, siPropagationType in_propagationtype );
	EXPORTSTUBS CValue Create2DMapWithProjection( const CValue& /*undefined*/ in_inputobjs, const CString& in_propertyname, siPropagationType in_propagationtype, siTxtCreationType in_type, const CString& in_camera, bool in_inspect );
	EXPORTSTUBS CValue Create2DSkeleton( const CValue& /*number*/ in_rx, const CValue& /*number*/ in_ry, const CValue& /*number*/ in_rz, const CValue& /*number*/ in_ex, const CValue& /*number*/ in_ey, const CValue& /*number*/ in_ez, const CValue& /*number*/ in_nx, const CValue& /*number*/ in_ny, const CValue& /*number*/ in_nz, const CValue& /*number*/ in_viewtype, const CRef& /*object*/ in_bone, const CRef& /*object*/ in_effector );
	EXPORTSTUBS CValue Create3DSkeleton( const CValue& /*number*/ in_rx, const CValue& /*number*/ in_ry, const CValue& /*number*/ in_rz, const CValue& /*number*/ in_ex, const CValue& /*number*/ in_ey, const CValue& /*number*/ in_ez, const CValue& /*number*/ in_nx, const CValue& /*number*/ in_ny, const CValue& /*number*/ in_nz, const CValue& /*number*/ in_bone, const CRef& /*object*/ in_effector );
	EXPORTSTUBS void CreateActiveRigidBody( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue CreateAndEditCommand( void );
	EXPORTSTUBS void CreateChainfromCurve( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_nbjoints, const CValue& /*undefined*/ in_usecns );
	EXPORTSTUBS CValue CreateCluster( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue CreateClusterCenter( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_s3d_cmdarg_nulllist, bool in_supplymode, const CValue& /*undefined*/ in_constructionmode );
	EXPORTSTUBS CValue CreateClusterCenterWithNull( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_constructionmode );
	EXPORTSTUBS CValue CreateClusterFromSubComponent( const CValue& /*undefined*/ in_inputobjs, const CString& in_name, bool in_canconnecttotag );
	EXPORTSTUBS CValue CreateClustersAlongDepthFromCurvesToMeshOperator( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue CreateClustersFromSlicePolygonsOperator( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue CreateCompound( const CValue& /*undefined*/ in_model, const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_compound, const CValue& /*undefined*/ in_track, const CValue& /*undefined*/ in_time, const CString& in_name );
	EXPORTSTUBS void CreateConnectionMap( const CValue& /*undefined*/ in_obj1, const CValue& /*undefined*/ in_obj2, const CRef& /*object*/ in_mappingtemplate );
	EXPORTSTUBS void CreateCPSPreset( const CValue& /*undefined*/ in_filename, const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS void CreateCurve( const CValue& /*number*/ in_degree, const CValue& /*number*/ in_curvetype, const CString& in_points, bool in_local, const CRef& /*object*/ in_value );
	EXPORTSTUBS void CreateCurvePartitionClusters( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue CreateDisplayInfo( const CValue& /*undefined*/ in_inputobj, const CString& in_psetname, bool in_showdisplayinfo );
	EXPORTSTUBS void CreateEmptyConnectionMap( const CValue& /*undefined*/ in_obj1, const CRef& /*object*/ in_mappingtemplate );
	EXPORTSTUBS void CreateEmptyPartition( const CValue& /*undefined*/ in_target, const CString& in_name, siPartitionType in_type, const CRef& /*object*/ in_value );
	EXPORTSTUBS void CreateEmptyValueMap( const CValue& /*undefined*/ in_obj1, const CRef& /*object*/ in_mappingtemplate );
	EXPORTSTUBS CValue CreateEnvironment( const CString& in_name, const CRef& /*object*/ in_environment );
	EXPORTSTUBS CValue CreateEnvironmentCache( const CValue& /*undefined*/ in_model, const CValue& /*undefined*/ in_environment );
	EXPORTSTUBS void CreateEventSource( const CString& in_target, const CRef& /*object*/ in_output );
	EXPORTSTUBS CValue CreateExplosion( const CString& in_inputobjs );
	EXPORTSTUBS CValue CreateFluid( const CString& in_inputobjs );
	EXPORTSTUBS void CreateFolder( const CValue& /*undefined*/ in_target, const CString& in_name, const CRef& /*object*/ in_folder );
	EXPORTSTUBS CValue CreateForce( const CString& in_name, const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue CreateFxTree( const CRef& /*object*/ in_value );
	EXPORTSTUBS CValue CreateGridAndConnectToSlicePolygonsOp( const CValue& /*undefined*/ in_target );
	EXPORTSTUBS CValue CreateGroup( const CString& in_name, const CValue& /*undefined*/ in_inputobjs, const CString& in_parent );
	EXPORTSTUBS CValue CreateHierarchyFromBiped( const CString& in_guidename, const CValue& /*number*/ in_hierarchystyle );
	EXPORTSTUBS void CreateImageBasedLightingPass( const CString& in_filename, const CValue& /*undefined*/ in_clip );
	EXPORTSTUBS CValue CreateImageClip( const CString& in_filename, const CString& in_name, const CString& in_value );
	EXPORTSTUBS CValue CreateImageClip2( const CString& in_filename, const CString& in_name, const CString& in_value );
	EXPORTSTUBS void CreateInspectParticleTypeBillboard( const CString& in_rendertype );
	EXPORTSTUBS void CreateInspectParticleTypeBlob( const CString& in_rendertype );
	EXPORTSTUBS void CreateInspectParticleTypeSphere( const CString& in_rendertype );
	EXPORTSTUBS void CreateLayer( const CString& in_presetobj, const CString& in_name, const CValue& /*undefined*/ in_inputobjs, const CRef& /*object*/ in_value );
	EXPORTSTUBS void CreateLibrary( const CString& in_name, const CValue& /*number*/ in_type, CRef& /*object*/ in_value );
	EXPORTSTUBS void CreateLightRigFromImage( const CString& in_filename, const CValue& /*number*/ in_number_layers, const CValue& /*number*/ in_areahigh, const CValue& /*number*/ in_lightdisthigh );
	EXPORTSTUBS void CreateMarkingSet( const CValue& /*undefined*/ in_inputobjs, bool in_reset );
	EXPORTSTUBS void CreateMeshPartitionClusters( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue CreateMeshText( const CValue& /*undefined*/ in_presetobj, siOperationMode in_immediatemode );
	EXPORTSTUBS void CreateModel( const CString& in_inputobj, const CString& in_name, const CString& in_parent, const CRef& /*object*/ in_value );
	EXPORTSTUBS CValue CreateModelClip( const CString& in_filename, const CString& in_name, const CString& in_value );
	EXPORTSTUBS CValue CreateNonOverlappingCluster( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue CreateObjectFromPreset( const CValue& /*undefined*/ in_presetobj, const CString& in_name );
	EXPORTSTUBS void CreateOffsetEffect( const CValue& /*undefined*/ in_clip );
	EXPORTSTUBS CValue CreateParticleCloud( const CValue& /*undefined*/ in_inputobjs, const CString& in_prim );
	EXPORTSTUBS CValue CreateParticleSimulationFromFile( const CString& in_filename );
	EXPORTSTUBS void CreateParticleType( siParticleRenderType in_rendertype, const CRef& /*object*/ in_output );
	EXPORTSTUBS void CreatePartition( const CString& in_target, const CString& in_name, const CString& in_inputobjs, const CRef& /*object*/ in_value );
	EXPORTSTUBS void CreatePass( const CString& in_presetobj, const CString& in_name, const CRef& /*object*/ in_value );
	EXPORTSTUBS void CreatePassFromLayers( const CString& in_name, const CRef& /*object*/ in_value );
	EXPORTSTUBS void CreatePassiveRigidBody( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void CreatePassWithPartition( const CString& in_presetobj, const CString& in_name, const CString& in_paramname, const CValue& /*undefined*/ in_inputobjs, const CRef& /*object*/ in_value );
	EXPORTSTUBS CValue CreatePreset( const CString& in_name, const CString& in_family, const CString& in_path );
	EXPORTSTUBS void CreatePrim( const CString& in_presetobj, const CString& in_geometrytype, const CString& in_name, const CString& in_parent );
	EXPORTSTUBS void CreateProjection( const CValue& /*undefined*/ in_inputobjs, siTxtCreationType in_type, siTxtDefaultCreationType in_uvdefaulttype, const CValue& /*undefined*/ in_supportname, const CValue& /*undefined*/ in_propertyname, bool in_parenting, siTxtProjFitMethod in_fitting, const CString& in_camera );
	EXPORTSTUBS CValue CreateReferencePlane( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void CreateRigFromGuide( void );
	EXPORTSTUBS void CreateRigFromQuadruped( void );
	EXPORTSTUBS void CreateScaleEffect( const CValue& /*undefined*/ in_clip );
	EXPORTSTUBS CValue CreateSourceFileFromDoc( const CValue& /*undefined*/ in_tag, const CValue& /*undefined*/ in_method, const CValue& /*undefined*/ in_lang );
	EXPORTSTUBS CValue CreateSpine( const CValue& /*undefined*/ in_hip, const CValue& /*undefined*/ in_chest, const CValue& /*number*/ in_numvertebrae, bool in_implicitvertebrae, bool in_interactive );
	EXPORTSTUBS void CreateSubprojection( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_textureprojection, siTxtProjType in_type, siTxtProjPlane in_plane, const CString& in_supportname, bool in_parenting, siTxtProjFitMethod in_fitting, bool in_fittoimage, bool in_maintainaspect, const CRef& /*object*/ in_3dobjtexture );
	EXPORTSTUBS CValue CreateSymmetryMap( const CString& in_presetobj, const CValue& /*undefined*/ in_inputobj, const CString& in_name, const CString& in_proppresetobj );
	EXPORTSTUBS CValue CreateSymmetryMappingTemplate( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_filltemplate, const CValue& /*number*/ in_symmetry_plane, bool in_createsymmetrymap );
	EXPORTSTUBS void CreateTextureProj( const CValue& /*undefined*/ in_inputobjs, const CString& in_projectionname, bool in_parenting, siTxtProjType in_projectiontype, siTxtProjPlane in_projectionplane );
	EXPORTSTUBS void CreateTextureSpatial( const CValue& /*undefined*/ in_inputobjs, const CString& in_name );
	EXPORTSTUBS void CreateTextureSupport( const CValue& /*undefined*/ in_inputobjs, siTxtCreationType in_type, siTxtDefaultCreationType in_uvdefaulttype, const CString& in_name, bool in_parenting );
	EXPORTSTUBS void CreateTextureUVDomain( const CValue& /*undefined*/ in_inputobjs, const CString& in_supportname, const CString& in_propertyname );
	EXPORTSTUBS CValue CreateUserDataMap( const CValue& /*undefined*/ in_inputobj, const CString& in_propertyname, const CValue& /*undefined*/ in_template );
	EXPORTSTUBS CValue CreateUserDataMapAndPickTemplate( const CValue& /*undefined*/ in_inputobj, const CString& in_propertyname );
	EXPORTSTUBS void CreateValueMap( const CValue& /*undefined*/ in_obj1, const CValue& /*undefined*/ in_obj2, const CValue& /*number*/ in_mode, const CValue& /*number*/ in_scope, bool in_usenames, const CRef& /*object*/ in_mappingtemplate );
	EXPORTSTUBS CValue CreateVertexColorSupport( const CString& in_presetobj, const CString& in_propertyname, const CValue& /*undefined*/ in_inputobjs);
	EXPORTSTUBS CValue CreateWeightMap( const CString& in_presetobj, const CValue& /*undefined*/ in_inputobj, const CString& in_propertyname, const CString& in_proppresetobj, bool in_select );
	EXPORTSTUBS void CrossfadeClipWeights( const CValue& /*undefined*/ in_firstclip, const CValue& /*undefined*/ in_secondclip );
	EXPORTSTUBS void CurrentFxTracking( void );
	EXPORTSTUBS void Cut( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue CutClip( const CValue& /*undefined*/ in_clip, siCutClipOptions in_mode, const CValue& /*undefined*/ in_time );
	EXPORTSTUBS CValue CutClipInSpace( const CValue& /*undefined*/ in_model, const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_clip );
	EXPORTSTUBS void CutFxOp( const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS void CutKeys( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_startframe, const CValue& /*number*/ in_endframe, bool in_reset, bool in_ripple );
	EXPORTSTUBS void CutObj( const CValue& /*undefined*/ in_children );
	EXPORTSTUBS CValue CycleChecking( const CValue& /*undefined*/ in_startinggraphpt, bool in_check_current_frame, bool in_iscycle );
	EXPORTSTUBS CValue CycleUVW( const CValue& /*undefined*/ in_textureprojection, const CValue& /*undefined*/ in_subcomp, const CValue& /*number*/ in_offset );
	EXPORTSTUBS void DeactivateAbove( const CValue& /*undefined*/ in_operator, bool in_mute );
	EXPORTSTUBS void DeactivateElements( const CValue& /*undefined*/ in_selectionlist );
	EXPORTSTUBS CValue DeactivateExternalConstraints( const CValue& /*undefined*/ in_inputobj, const CString& in_operation );
	EXPORTSTUBS void DecPaintShapePointWeight( const CValue& /*undefined*/ in_shape );
	EXPORTSTUBS void DeformMotion( void );
	EXPORTSTUBS void Delete2DShapePoint( const CValue& /*undefined*/ in_shape, const CValue& /*number*/ in_index );
	EXPORTSTUBS void DeleteAll( bool in_confirm );
	EXPORTSTUBS void DeleteAllPaintShapes( const CValue& /*undefined*/ in_shapelist );
	EXPORTSTUBS void DeleteAllUnusedMaterials( void );
	EXPORTSTUBS void DeleteCurrentLayer( const CString& in_inputobj );
	EXPORTSTUBS void DeleteCurrentPass( const CString& in_inputobj );
	EXPORTSTUBS void DeleteGeneratorInputs( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue DeleteHelperBone( const CValue& /*undefined*/ in_helper, bool in_confirm );
	EXPORTSTUBS CValue DeleteHelperTrigger( const CValue& /*undefined*/ in_helper, const CValue& /*number*/ in_index, bool in_confirm );
	EXPORTSTUBS void DeleteMappingRule( const CValue& /*undefined*/ in_mappingtemplate, const CValue& /*number*/ in_index );
	EXPORTSTUBS void DeleteMarkingSet( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void DeleteModelFromObj( const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS void DeleteMotionDerivator( const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS void DeleteObj( const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS void DeleteOverride( void );
	EXPORTSTUBS void DeletePaintShapeKey( const CValue& /*undefined*/ in_shape, const CValue& /*undefined*/ in_time );
	EXPORTSTUBS void DeletePaintShapePoints( const CValue& /*undefined*/ in_shape, const CValue& /*undefined*/ in_index );
	EXPORTSTUBS void DeleteUnusedImageClips( void );
	EXPORTSTUBS void DeleteUnusedImageSources( void );
	EXPORTSTUBS void DeleteUnusedMaterials( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void DeleteUnusedMixerTracks( const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS void DelPointOnCurveTool( const CString& in_clsid );
	EXPORTSTUBS void DeselectAll( void );
	EXPORTSTUBS void DeselectAllUsingFilter( const CValue& /*undefined*/ in_selfilter );
	EXPORTSTUBS void DisableAllDevices( void );
	EXPORTSTUBS void DisconnectAndDeleteShaders( const CValue& /*undefined*/ in_shaders );
	EXPORTSTUBS void DisconnectBevelProfileCurve( const CValue& /*undefined*/ in_target );
	EXPORTSTUBS void DisconnectFromSimulationOp( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_objectstodisconnect );
	EXPORTSTUBS void DisconnectFxOp( const CValue& /*undefined*/ in_op, const CString& in_connection );
	EXPORTSTUBS void DisconnectOperatorParameter( const CValue& /*undefined*/ in_parameter );
	EXPORTSTUBS void DisconnectParticleInitState( const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS void DisconnectPlaneReferenceFromSlicePolygonsOp( const CValue& /*undefined*/ in_target );
	EXPORTSTUBS void DisposeRenderingCache( void );
	EXPORTSTUBS void DrawImplicitPrimitiveTool( const CString& in_presetobj, const CString& in_name, const CString& in_parent );
	EXPORTSTUBS void DrawNullTool( const CString& in_presetobj, const CString& in_name, const CString& in_parent );
	EXPORTSTUBS void DrawPrimitiveTool( const CString& in_presetobj, const CString& in_geometrytype, const CString& in_name, const CString& in_parent );
	EXPORTSTUBS CValue Duplicate( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_nbitems, siDupHistory in_history, siDupParent in_hierarchy, siDupGroup in_grouping, siDupProperty in_properties, siDupAnimation in_animation, siDupConstraint in_constraints, siDupSelection in_selection, siDupTransform in_xfrom, const CString& in_sx, const CString& in_sy, const CString& in_sz, const CString& in_rx, const CString& in_ry, const CString& in_rz, const CString& in_tx, const CString& in_ty, const CString& in_tz, const CString& in_trackxform, siDupTextureSupport in_texturesupports );
	EXPORTSTUBS CValue DuplicateFromAnim( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_startframe, const CValue& /*number*/ in_endframe, const CValue& /*number*/ in_stepframe, bool in_doinstance );
	EXPORTSTUBS void DuplicateMeshComponent( const CString& in_connectionset, siOperationMode in_immediatemode, const CValue& /*number*/ in_length, const CValue& /*number*/ in_nbsubdivs, bool in_merge, const CValue& /*number*/ in_tx, const CValue& /*number*/ in_ty, const CValue& /*number*/ in_tz, const CValue& /*number*/ in_rx, const CValue& /*number*/ in_ry, const CValue& /*number*/ in_rz, const CValue& /*number*/ in_sx, const CValue& /*number*/ in_sy, const CValue& /*number*/ in_sz, bool in_duplicatepolygons );
	EXPORTSTUBS void DuplicateModelFromObj( const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS CValue DuplicateSymmetry( const CValue& /*undefined*/ in_inputobjs, bool in_duplicateconstraints, bool in_shareparent, const CValue& /*number*/ in_symmetryplanea, const CValue& /*number*/ in_symmetryplaneb, const CValue& /*number*/ in_symmetryplanec, const CValue& /*number*/ in_symmetryplaned, bool in_s3d_cmdarg_freezescl );
	EXPORTSTUBS void DuplicateTool( const CValue& /*undefined*/ in_selectionlist );
	EXPORTSTUBS CValue DuplicateUsingGeomApprox( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void EditClip( const CValue& /*undefined*/ in_inputobj, siEditClipOptions in_mode, const CValue& /*undefined*/ in_time );
	EXPORTSTUBS CValue EditCommand( const CString& in_commandname );
	EXPORTSTUBS void EditExpr( const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS void EditHelperBones( const CValue& /*undefined*/ in_rig );
	EXPORTSTUBS void EditParameterDefinition( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_paramname, const CValue& /*number*/ in_vartype, const CValue& /*undefined*/ in_minvalue, const CValue& /*undefined*/ in_maxvalue, const CValue& /*undefined*/ in_suggmin, const CValue& /*undefined*/ in_suggmax, const CValue& /*undefined*/ in_scriptname, const CValue& /*undefined*/ in_description );
	EXPORTSTUBS void EllipsePaintRaster( const CValue& /*number*/ in_x1, const CValue& /*number*/ in_y1, const CValue& /*number*/ in_x2, const CValue& /*number*/ in_y2, bool in_fromcenter );
	EXPORTSTUBS CValue EllipticalPaintMask( const CValue& /*number*/ in_x1, const CValue& /*number*/ in_y1, const CValue& /*number*/ in_x2, const CValue& /*number*/ in_y2, bool in_fromcenter, const CValue& /*number*/ in_selectionaction, bool in_antialiased, const CValue& /*number*/ in_feather, const CRef& /*object*/ in_value );
	EXPORTSTUBS void EnableAllDevices( void );
	EXPORTSTUBS void EndUndo( void );
	EXPORTSTUBS CValue EnumElements( const CValue& /*undefined*/ in_inputobj, bool in_enumchildren, const CValue& /*number*/ in_capabilities );
	EXPORTSTUBS CValue EqualizeAction( const CValue& /*undefined*/ in_source, const CValue& /*number*/ in_time, const CValue& /*number*/ in_duration, const CString& in_name );
	EXPORTSTUBS void EqualizeClips( const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS CValue EvalFCurve( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_time );
	EXPORTSTUBS void EvaluateCurveAt( const CValue& /*undefined*/ in_inputobj, const CValue& /*number*/ in_value, bool in_local, const CValue& /*number*/ in_posx, const CValue& /*number*/ in_posy, const CValue& /*number*/ in_posz, const CValue& /*number*/ in_tanx, const CValue& /*number*/ in_tany, const CValue& /*number*/ in_tanz, const CValue& /*number*/ in_norx, const CValue& /*number*/ in_nory, const CValue& /*number*/ in_norz );
	EXPORTSTUBS void ExplodeCompound( const CValue& /*undefined*/ in_model, const CValue& /*undefined*/ in_compound );
	EXPORTSTUBS void ExportAction( const CValue& /*undefined*/ in_action, const CValue& /*undefined*/ in_filename );
	EXPORTSTUBS void ExportAllPassesToMI2( bool in_passcentric );
	EXPORTSTUBS void ExportDotXSI( const CValue& /*undefined*/ in_model, const CString& in_filename );
	EXPORTSTUBS void ExportHelperBones( const CValue& /*undefined*/ in_rig, const CString& in_filename, bool in_prompt );
	EXPORTSTUBS void ExportImageClip( const CValue& /*undefined*/ in_clip, const CString& in_filename, const CValue& /*number*/ in_startframe, const CValue& /*number*/ in_endframe, const CValue& /*number*/ in_stepframe );
	EXPORTSTUBS void ExportMaterialLibrary( const CValue& /*undefined*/ in_filename, const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void ExportMI2File( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_presetobj, const CValue& /*undefined*/ in_startframe, const CValue& /*undefined*/ in_endframe, const CValue& /*undefined*/ in_stepframe, const CString& in_filename, const CValue& /*undefined*/ in_approximatepolygons, const CValue& /*undefined*/ in_approximatefaces, const CValue& /*undefined*/ in_asciioutput, const CValue& /*undefined*/ in_verbatimtextures, const CValue& /*undefined*/ in_multiplefiles, const CValue& /*undefined*/ in_incremental );
	EXPORTSTUBS void ExportMixer( const CValue& /*undefined*/ in_model, const CValue& /*undefined*/ in_filename, const CValue& /*number*/ in_tracktypes );
	EXPORTSTUBS void ExportModel( const CValue& /*undefined*/ in_model, const CValue& /*undefined*/ in_filename, bool in_includesubmodels );
	EXPORTSTUBS void ExportPreferences( const CString& in_filename, const CString& in_categories );
	EXPORTSTUBS void ExtractFromComponents( const CString& in_presetobj, const CString& in_connectionset, const CString& in_name, bool in_deleteinputcomponents, siOperationMode in_immediatemode, siGeneratorInputsDisposalMode in_genopinputsdisposal, const CRef& /*object*/ in_outputobjs );
	EXPORTSTUBS CValue FilterPSet( const CValue& /*undefined*/ in_inputobjs, siPSetRelationship in_relationship, bool in_include );
	EXPORTSTUBS CValue FindObjects( const CString& in_path, const CString& in_type );
	EXPORTSTUBS void FindPeriods( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_algorithm, const CValue& /*undefined*/ in_startframe, const CValue& /*undefined*/ in_endframe, const CValue& /*undefined*/ in_minimum_period_length, const CValue& /*undefined*/ in_mode, const CValue& /*undefined*/ in_name, const CString& in_title );
	EXPORTSTUBS void FirstFrame( void );
	EXPORTSTUBS CValue FirstKey( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_time );
	EXPORTSTUBS void FirstPaintShapeKey( const CValue& /*undefined*/ in_shape );
	EXPORTSTUBS void FitSubcomponentUVsToImage( const CValue& /*undefined*/ in_properties, const CValue& /*undefined*/ in_subcomp, bool in_explicit, bool in_maintainaspect );
	EXPORTSTUBS void Flipbook( const CString& in_cmdline );
	EXPORTSTUBS CValue FlipUVW( const CValue& /*undefined*/ in_textureprojection, const CValue& /*undefined*/ in_subcomp, const CValue& /*number*/ in_pivot );
	EXPORTSTUBS void FloodFillRaster( const CValue& /*number*/ in_xseed, const CValue& /*number*/ in_yseed );
	EXPORTSTUBS void FrameAll( bool in_allobjects, bool in_allviews, const CValue& /*number*/ in_view );
	EXPORTSTUBS void FramePreviewAllLayers( void );
	EXPORTSTUBS void FramePreviewCurrentLayer( void );
	EXPORTSTUBS void FramePreviewSelection( const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS void FramePreviewSetup( void );
	EXPORTSTUBS void FramePreviewVisibleLayers( void );
	EXPORTSTUBS void FrameSelection( bool in_allobjects, bool in_allviews, const CValue& /*number*/ in_view );
	EXPORTSTUBS CValue FreezeAndReplaceClips( const CValue& /*undefined*/ in_inputobj, const CString& in_name, bool in_ignoreinactivechannels, const CValue& /*number*/ in_stepframe, const CValue& /*number*/ in_fcurve_kind, const CValue& /*number*/ in_defaultsegkind, bool in_fit_fcurve, const CValue& /*number*/ in_fit_tolerance, bool in_processcontrots );
	EXPORTSTUBS CValue FreezeClips( const CValue& /*undefined*/ in_inputobj, const CString& in_name, bool in_ignoreinactivechannels, const CValue& /*number*/ in_stepframe, const CValue& /*number*/ in_fcurve_kind, const CValue& /*number*/ in_defaultsegkind, bool in_fit_fcurve, const CValue& /*number*/ in_fit_tolerance, bool in_processcontrots );
	EXPORTSTUBS void FreezeModeling( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_time, siBranchFlag in_propagationtype );
	EXPORTSTUBS void FreezeObj( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_time, siBranchFlag in_propagationtype );
	EXPORTSTUBS void FreezeUVWTransformation( const CRef& /*object*/ in_textureprojectiondefinition );
	EXPORTSTUBS CValue GenDiffuseMap( const CValue& /*undefined*/ in_pset, const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS CValue GenerateActor( void );
	EXPORTSTUBS CValue GenerateAOMap( const CValue& /*undefined*/ in_pset );
	EXPORTSTUBS CValue GenerateDepthMap( const CValue& /*undefined*/ in_pset );
	EXPORTSTUBS void GenerateInfoReport( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_filename );
	EXPORTSTUBS CValue GenerateMatColorMap( const CValue& /*undefined*/ in_pset );
	EXPORTSTUBS CValue GenerateNormalMap( const CValue& /*undefined*/ in_pset );
	EXPORTSTUBS CValue GenerateSurfaceMap( const CValue& /*undefined*/ in_pset );
	EXPORTSTUBS void GenerateUniqueUVs( const CValue& /*undefined*/ in_inputobjs, const CString& in_propertyname, const CValue& /*number*/ in_lowu, const CValue& /*number*/ in_lowv, const CValue& /*number*/ in_width, const CValue& /*number*/ in_height, const CValue& /*number*/ in_spaceu, const CValue& /*number*/ in_spacev, const CRef& /*object*/ in_properties );
	EXPORTSTUBS CValue GenerateUVSetByContourStretching( const CValue& /*undefined*/ in_inputobjs, const CString& in_propertyname, const CValue& /*number*/ in_contourstretchingmethod, bool in_maintainaspect, const CValue& /*undefined*/ in_cornerpoints );
	EXPORTSTUBS CValue GenNormalMap( const CValue& /*undefined*/ in_pset, const CValue& /*undefined*/ in_inputobj, bool in_gennormalmapm, bool in_gennormalmapt, bool in_gentangents );
	EXPORTSTUBS void GetBBox( const CValue& /*undefined*/ in_inputobj, bool in_finecomputation, const CValue& /*number*/ in_lowerboundx, const CValue& /*number*/ in_lowerboundy, const CValue& /*number*/ in_lowerboundz, const CValue& /*number*/ in_upperboundx, const CValue& /*number*/ in_upperboundy, const CValue& /*number*/ in_upperboundz );
	EXPORTSTUBS CValue GetClosestPaintShapeKey( const CValue& /*undefined*/ in_shape, const CValue& /*undefined*/ in_time, const CRef& /*object*/ in_value );
	EXPORTSTUBS CValue GetConnectedPropVolume( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue GetConnectionSet( const CValue& /*undefined*/ in_presetobj, const CValue& /*undefined*/ in_connectionset, siCnxSetType in_cnxgrouptype, siBranchFlag in_connecttype, bool in_interactive, bool in_createoutputobjs, const CRef& /*object*/ in_outputobjs );
	EXPORTSTUBS void GetConstrainedObjects( const CValue& /*undefined*/ in_inputobj, const CRef& /*object*/ in_outputobjs );
	EXPORTSTUBS void GetCurrentLayer( const CRef& /*object*/ in_value );
	EXPORTSTUBS CValue GetCurrentPass( void );
	EXPORTSTUBS void GetCurveLength( const CValue& /*undefined*/ in_inputobj, const CValue& /*number*/ in_length );
	EXPORTSTUBS void GetCurvePercentageAtKnotIndex( const CValue& /*undefined*/ in_inputobj, const CValue& /*number*/ in_index, const CValue& /*number*/ in_percentage );
	EXPORTSTUBS CValue GetDrivingActions( const CValue& /*undefined*/ in_inputobjs, bool in_consider_time, const CValue& /*undefined*/ in_time, bool in_keep_compound_actions, bool in_keep_inactive_actions );
	EXPORTSTUBS void GetFCurveInfo( const CValue& /*undefined*/ in_inputobj, const CValue& /*number*/ in_curvekind, const CValue& /*number*/ in_valuewhennokey, const CValue& /*number*/ in_nbkeys, const CValue& /*number*/ in_extrapolationkind, const CValue& /*number*/ in_defaultsegkind, const CValue& /*number*/ in_lowclamp, const CValue& /*number*/ in_highclamp );
	EXPORTSTUBS CValue GetFirstPaintShapeKey( const CValue& /*undefined*/ in_shape, const CRef& /*object*/ in_value );
	EXPORTSTUBS void GetGeneratorInputsForDisposal( const CValue& /*undefined*/ in_inputobjs, const CString& in_genopinputsdisposal, const CRef& /*object*/ in_outputobjs );
	EXPORTSTUBS CValue GetInputAndStoreAction( const CString& in_model, const CString& in_inputobj, const CValue& /*number*/ in_mode, const CString& in_name, bool in_removeanim, const CValue& /*number*/ in_startframe, const CValue& /*number*/ in_endframe, bool in_consider_time, bool in_ripple, bool in_addclip, const CValue& /*number*/ in_clipoffset );
	EXPORTSTUBS CValue GetInstances( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void GetKeyboardState( const CValue& /*number*/ in_keycode, const CValue& /*number*/ in_shift );
	EXPORTSTUBS void GetKeyInfo( const CValue& /*undefined*/ in_inputobj, const CValue& /*number*/ in_index, const CValue& /*number*/ in_parameter, const CValue& /*number*/ in_leftvalue, const CValue& /*number*/ in_rightvalue, const CValue& /*number*/ in_lefttanparam, const CValue& /*number*/ in_lefttanvalue, const CValue& /*number*/ in_righttanparam, const CValue& /*number*/ in_righttanvalue, const CValue& /*number*/ in_rightsegkind, const CValue& /*number*/ in_constraints );
	EXPORTSTUBS CValue GetLastPaintShapeKey( const CValue& /*undefined*/ in_shape, const CRef& /*object*/ in_value );
	EXPORTSTUBS void GetMappingRule( const CValue& /*undefined*/ in_mappingtemplate, const CValue& /*number*/ in_index, const CString& in_from, const CString& in_to, bool in_active, bool in_poseoffset );
	EXPORTSTUBS CValue GetMarking( void );
	EXPORTSTUBS CValue GetMaster( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue GetNbTriangles( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue GetNeighborSubcomponents( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_neighbortype, const CString& in_selfilter );
	EXPORTSTUBS CValue GetNextPaintShapeKey( const CValue& /*undefined*/ in_shape, const CValue& /*undefined*/ in_time, const CRef& /*object*/ in_value );
	EXPORTSTUBS void GetNumberOfKnots( const CValue& /*undefined*/ in_inputobj, const CValue& /*number*/ in_nbitems );
	EXPORTSTUBS CValue GetNumMappingRules( const CValue& /*undefined*/ in_mappingtemplate, const CRef& /*object*/ in_value );
	EXPORTSTUBS CValue GetNumRelativeValues( const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS CValue GetPresetModel( const CString& in_modelname, const CString& in_name, const CString& in_parent, const CString& in_psetname );
	EXPORTSTUBS CValue GetPrevPaintShapeKey( const CValue& /*undefined*/ in_shape, const CValue& /*undefined*/ in_time, const CRef& /*object*/ in_value );
	EXPORTSTUBS CValue GetPrim( const CValue& /*undefined*/ in_presetobj, const CString& in_name, const CString& in_parent, const CRef& /*object*/ in_primitive );
	EXPORTSTUBS CValue GetPrimCamera( const CString& in_presetobj, const CString& in_name, const CString& in_parent, const CRef& /*object*/ in_primitive, const CRef& /*object*/ in_3dobjcamera, const CRef& /*object*/ in_3dobjcamerainterest );
	EXPORTSTUBS CValue GetPrimLattice( const CString& in_presetobj, const CValue& /*undefined*/ in_inputobjs, const CString& in_name, const CString& in_parent, const CRef& /*object*/ in_primobj );
	EXPORTSTUBS CValue GetPrimLight( const CString& in_presetobj, const CString& in_name, const CString& in_parent, const CRef& /*object*/ in_primitive, const CRef& /*object*/ in_primobjspot, const CRef& /*object*/ in_primobjspotinterest );
	EXPORTSTUBS CValue GetPrimVolumeDeform( const CString& in_presetobj, const CValue& /*undefined*/ in_inputobjs, const CString& in_name, const CString& in_parent, const CRef& /*object*/ in_primobj );
	EXPORTSTUBS void GetPrimWave( const CString& in_presetobj, const CValue& /*undefined*/ in_inputobjs, const CString& in_name, const CString& in_parent, const CRef& /*object*/ in_primitive );
	EXPORTSTUBS CValue GetProportionalGuide( const CString& in_modelname, const CValue& /*number*/ in_guidestyle, const CValue& /*number*/ in_guidesymmetry );
	EXPORTSTUBS CValue GetRelativeValue( const CValue& /*undefined*/ in_inputobj, const CValue& /*number*/ in_index );
	EXPORTSTUBS void GetRigidBodyInitStateFromAnim( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue GetSize( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_staticsize, const CValue& /*number*/ in_dynamicsize );
	EXPORTSTUBS CValue GetSkeleton( const CValue& /*undefined*/ in_inputobj, const CValue& /*number*/ in_index, const CRef& /*object*/ in_chainelements );
	EXPORTSTUBS CValue GetSource( const CValue& /*undefined*/ in_inputobjs, siSourceType in_sourcemask );
	EXPORTSTUBS void GetStoreActionDefaults( const CValue& /*undefined*/ in_model, const CValue& /*undefined*/ in_inputobj, const CValue& /*number*/ in_mode, const CValue& /*number*/ in_from, const CValue& /*number*/ in_to, const CValue& /*number*/ in_size );
	EXPORTSTUBS CValue GetSurfaceFromCurvesConnectionSet( const CValue& /*undefined*/ in_presetobj, const CValue& /*undefined*/ in_target, const CValue& /*undefined*/ in_connectionset, siCnxSetType in_cnxgrouptype, siBranchFlag in_connecttype, bool in_interactive, const CRef& /*object*/ in_outputobjs, bool in_createoutputobjs );
	EXPORTSTUBS CValue GetUserKeyword( const CValue& /*undefined*/ in_inputobjs, const CRef& /*object*/ in_keywords );
	EXPORTSTUBS CValue GetUserPref( const CString& in_target );
	EXPORTSTUBS CValue GetValue( const CValue& /*undefined*/ in_target, const CValue& /*undefined*/ in_time );
	EXPORTSTUBS CValue GotoHome( void );
	EXPORTSTUBS void GotoSelectedPaintClipFrame( const CValue& /*undefined*/ in_paintclip );
	EXPORTSTUBS void GrowSelection( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void HairClumpTool( const CString& in_clsid );
	EXPORTSTUBS void HairPuffRootsTool( const CString& in_clsid );
	EXPORTSTUBS void HairRotateCursorTool( const CString& in_clsid );
	EXPORTSTUBS void HairRotateRootTool( const CString& in_clsid );
	EXPORTSTUBS void HairRotateTipTool( const CString& in_clsid );
	EXPORTSTUBS void HairScalingTool( const CString& in_clsid );
	EXPORTSTUBS void HairStandOnEndTool( const CString& in_clsid );
	EXPORTSTUBS CValue HealUVW( const CValue& /*undefined*/ in_textureprojection, const CValue& /*undefined*/ in_subcomp );
	EXPORTSTUBS void HelpOnHelperBoneTool( void );
	EXPORTSTUBS void HideAndUnselect( const CValue& /*undefined*/ in_target, const CString& in_propertyname );
	EXPORTSTUBS void HideGeneratorInputs( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void HideTextureUVDomains( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_type );
	EXPORTSTUBS void HideUnselected( const CValue& /*undefined*/ in_target, const CString& in_propertyname );
	EXPORTSTUBS CValue hierachy_from_Biped( void );
	EXPORTSTUBS CValue ImportAction( const CValue& /*undefined*/ in_model, const CValue& /*undefined*/ in_filename, const CString& in_name, const CValue& /*number*/ in_actionstorage );
	EXPORTSTUBS CValue ImportActionAndAddClip( const CValue& /*undefined*/ in_model, const CValue& /*undefined*/ in_filename );
	EXPORTSTUBS CValue ImportActionAndApply( const CValue& /*undefined*/ in_model, const CValue& /*undefined*/ in_filename );
	EXPORTSTUBS CValue ImportAudio( const CValue& /*undefined*/ in_model, const CValue& /*undefined*/ in_filename, const CString& in_name );
	EXPORTSTUBS CValue ImportAudioAndAddClip( const CValue& /*undefined*/ in_model, const CValue& /*undefined*/ in_filename );
	EXPORTSTUBS CValue ImportBVHAction( void );
	EXPORTSTUBS CValue ImportBVHActor( void );
	EXPORTSTUBS void ImportDotXSI( const CString& in_filename, const CString& in_parent );
	EXPORTSTUBS void ImportEPS( const CValue& /*undefined*/ in_filename, const CValue& /*undefined*/ in_parent, bool in_updateselection, const CRef& /*object*/ in_value );
	EXPORTSTUBS CValue ImportFromSI3D( const CValue& /*undefined*/ in_name, bool in_createpasslayer, const CRef& /*object*/ in_createdobj );
	EXPORTSTUBS CValue ImportGuide( void );
	EXPORTSTUBS void ImportHelperBones( const CValue& /*undefined*/ in_rig, const CString& in_filename, bool in_prompt );
	EXPORTSTUBS void ImportIges( const CString& in_filename, const CString& in_parent, const CRef& /*object*/ in_value );
	EXPORTSTUBS void ImportMatadorShapeList( const CValue& /*undefined*/ in_shapelist, const CValue& /*undefined*/ in_filename, const CValue& /*number*/ in_destwidth, const CValue& /*number*/ in_destheight );
	EXPORTSTUBS void ImportMixer( const CValue& /*undefined*/ in_filename, const CValue& /*undefined*/ in_parent, bool in_merge, const CRef& /*object*/ in_value );
	EXPORTSTUBS void ImportModel( const CString& in_filename, const CString& in_parent, bool in_reference, const CRef& /*object*/ in_value, const CString& in_name, const CValue& /*number*/ in_shareoptions, const CString& in_externalcnxmappingtemplate );
	EXPORTSTUBS void ImportPreferences( const CString& in_filename );
	EXPORTSTUBS void ImportPrefs( const CValue& /*undefined*/ in_filename );
	EXPORTSTUBS CValue ImportRefAction( const CValue& /*undefined*/ in_model, const CValue& /*undefined*/ in_filename, const CString& in_name, const CValue& /*number*/ in_actionstorage );
	EXPORTSTUBS CValue ImportRefModels( const CString& in_filename, const CString& in_parent, const CString& in_externalcnxmappingtemplate );
	EXPORTSTUBS CValue ImportWeightMap( void );
	EXPORTSTUBS void IncPaintShapePointWeight( const CValue& /*undefined*/ in_shape );
	EXPORTSTUBS void InfoGeometry( void );
	EXPORTSTUBS void InfoScene( bool in_dogeneral, bool in_doanimation, bool in_dorendering );
	EXPORTSTUBS void InfoSelection( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue InitActor( void );
	EXPORTSTUBS void InitPropVolume( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue InitShapeKey( void );
	EXPORTSTUBS CValue Insert2DShapePoint( const CValue& /*undefined*/ in_shape, const CValue& /*number*/ in_position, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y, const CValue& /*number*/ in_value );
	EXPORTSTUBS CValue InsertPaintShapePoint( const CValue& /*undefined*/ in_shape, const CValue& /*number*/ in_insertposition, const CValue& /*number*/ in_contour, const CValue& /*number*/ in_value );
	EXPORTSTUBS CValue InsertShader( const CValue& /*undefined*/ in_presetobj, const CValue& /*undefined*/ in_inputobjs, const CString& in_name );
	EXPORTSTUBS void InspectBrowse( siInspectBrowseMode in_mode, const CValue& /*number*/ in_length );
	EXPORTSTUBS void InspectChainProperties( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void InspectDevices( void );
	EXPORTSTUBS void InspectEnvelopeWeights( void );
	EXPORTSTUBS CValue InspectInitStateProp( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void InspectLastOperator( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void InspectLocks( const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS void InspectMaterial( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue InspectObj( const CString& in_inputobjs, const CString& in_keywords, const CString& in_title, const CValue& /*number*/ in_mode, bool in_throw );
	EXPORTSTUBS void InspectPropVolume( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void InspectSnapProperties( void );
	EXPORTSTUBS void InspectSpringPropertiesProc( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void InspectTransformProperties( void );
	EXPORTSTUBS void InspectUserData( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void InstallAddon( const CString& in_filename, const CValue& /*number*/ in_installpath );
	EXPORTSTUBS void InstallCustomPreferences( const CValue& /*undefined*/ in_inputobjs, const CString& in_name );
	EXPORTSTUBS CValue Instance( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_nbitems, const CValue& /*number*/ in_hierarchy, const CValue& /*number*/ in_grouping, const CValue& /*number*/ in_properties, const CValue& /*number*/ in_animation, const CValue& /*number*/ in_constraints, const CValue& /*number*/ in_selection, const CValue& /*number*/ in_xfrom, const CString& in_sx, const CString& in_sy, const CString& in_sz, const CString& in_rx, const CString& in_ry, const CString& in_rz, const CString& in_tx, const CString& in_ty, const CString& in_tz, const CString& in_trackxform );
	EXPORTSTUBS CValue Instantiate( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_nbitems, siDupParent in_hierarchy, siDupGroup in_grouping, siDupSelection in_selection, siDupTransform in_xfrom, const CValue& in_sx, const CValue& in_sy, const CValue& in_sz, const CValue& in_rx, const CValue& in_ry, const CValue& in_rz, const CValue& in_tx, const CValue& in_ty, const CValue& in_tz, const CValue& in_trackxform);
	EXPORTSTUBS void InvertPaintStencil( void );
	EXPORTSTUBS void InvertSelection( const CValue& /*undefined*/ in_selfilter, siComponentVisibilityMode in_checkcomponentvisibility, bool in_checkobjectselectability );
	EXPORTSTUBS CValue IsAnimated( const CValue& /*undefined*/ in_inputobj, siSourceType in_sourcemask, siBranchFlag in_branchflag, const CRef& /*object*/ in_animcomponents, bool in_local );
	EXPORTSTUBS CValue IslandHealUVW( const CValue& /*undefined*/ in_textureprojection, const CValue& /*undefined*/ in_targetboundary, const CValue& /*undefined*/ in_sourceislands, bool in_allowscaling, const CValue& /*number*/ in_interpolation );
	EXPORTSTUBS void IsolateAll( bool in_all, const CValue& /*number*/ in_view );
	EXPORTSTUBS void IsolateSelected( bool in_all, const CValue& /*number*/ in_view );
	EXPORTSTUBS void Key2DShapePoints( const CValue& /*undefined*/ in_shape, const CValue& /*undefined*/ in_index );
	EXPORTSTUBS void KeyAllBoneRotations( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void LastFrame( void );
	EXPORTSTUBS CValue LastKey( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_time );
	EXPORTSTUBS void LastPaintShapeKey( const CValue& /*undefined*/ in_shape );
	EXPORTSTUBS void LaunchFlipbookForPass( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void LightAssociate( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void LinkDeform( const CValue& /*undefined*/ in_cluster, const CValue& /*undefined*/ in_parameter_list, bool in_linkwithori );
	EXPORTSTUBS void LinkDeformWithOri( const CValue& /*undefined*/ in_cluster, const CValue& /*undefined*/ in_parameter_list, bool in_linkwithori );
	EXPORTSTUBS CValue LoadActionPreset( const CValue& /*undefined*/ in_model, const CValue& /*undefined*/ in_filename, const CString& in_name, const CValue& /*number*/ in_actionstorage );
	EXPORTSTUBS CValue LoadActor( void );
	EXPORTSTUBS void LoadDefaultRig( const CString& in_whichrig );
	EXPORTSTUBS void LoadPreset( const CString& in_presetobj, const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS void LocalAssignFlexEnv( const CValue& /*undefined*/ in_subcomp, const CString& in_connectionset, const CValue& /*number*/ in_nbdeformersperpoint );
	EXPORTSTUBS void Lock( const CValue& /*undefined*/ in_inputobjs, siLockLevel in_level );
	EXPORTSTUBS CValue MagicWandPaintMask( const CValue& /*number*/ in_seedx, const CValue& /*number*/ in_seedy, const CValue& /*number*/ in_selectionaction, bool in_antialiased, const CValue& /*number*/ in_feather, const CRef& /*object*/ in_value );
	EXPORTSTUBS CValue Make2PointSlide( const CString& in_prefix, const CString& in_guidepoint1, const CString& in_guidepoint2, const CString& in_parent1, const CString& in_parent2, const CString& in_upvector, const CString& in_boundingvolume );
	EXPORTSTUBS void MakeAllUnselectable( void );
	EXPORTSTUBS CValue MakeArm( const CString& in_armparent, const CString& in_guideobjectcollection, const CString& in_prefix, const CString& in_armrootconstrainingobj, const CValue& /*number*/ in_nbforearmdivisions, const CValue& /*number*/ in_nbbicepdivisions, const CValue& /*number*/ in_shadowtype, const CString& in_shadowparent, const CString& in_handroot, bool in_negativescale );
	EXPORTSTUBS CValue MakeBelly( const CString& in_hipobject, const CString& in_vertebraobject, const CString& in_guideobjectcollection, const CValue& /*number*/ in_forwardrotationperc );
	EXPORTSTUBS CValue MakeBicepRoll( const CString& in_bicep, const CString& in_prefix, const CValue& /*number*/ in_nbdivisions );
	EXPORTSTUBS CValue MakeBiped( const CValue& /*number*/ in_torsotype, const CValue& /*number*/ in_torsostretch, const CValue& /*number*/ in_torsodivisions, const CValue& /*number*/ in_icontype, bool in_makebelly, const CValue& /*number*/ in_bellyslide, const CValue& /*number*/ in_bellycenterpercentage, const CValue& /*number*/ in_headtype, const CValue& /*number*/ in_headstretch, const CValue& /*number*/ in_headdivisions, bool in_ears, const CValue& /*number*/ in_rotationorder, const CValue& /*number*/ in_armsymmetry, const CValue& /*number*/ in_armattachment, const CValue& /*number*/ in_fingertype, bool in_forearmroll, const CValue& /*number*/ in_forearmdivisions, bool in_biceproll, const CValue& /*number*/ in_bicepdivisions, bool in_thighroll, const CValue& /*number*/ in_thighdivisions, bool in_armpitslide, bool in_hipslide, bool in_thighslide, bool in_elbowsjoint, bool in_kneejoint, const CValue& /*number*/ in_shadowtype, const CValue& /*number*/ in_shadowhands, bool in_selectusingui );
	EXPORTSTUBS CValue MakeBipedDogLeg( const CValue& /*number*/ in_torsotype, const CValue& /*number*/ in_torsostretch, const CValue& /*number*/ in_torsodivisions, const CValue& /*number*/ in_icontype, bool in_makebelly, const CValue& /*number*/ in_bellyslide, const CValue& /*number*/ in_bellycenterpercentage, const CValue& /*number*/ in_headtype, const CValue& /*number*/ in_headstretch, const CValue& /*number*/ in_headdivisions, bool in_ears, const CValue& /*number*/ in_rotationorder, const CValue& /*number*/ in_armsymmetry, const CValue& /*number*/ in_armattachment, const CValue& /*number*/ in_fingertype, bool in_forearmroll, const CValue& /*number*/ in_forearmdivisions, bool in_biceproll, const CValue& /*number*/ in_bicepdivisions, bool in_thighroll, const CValue& /*number*/ in_thighdivisions, bool in_armpitslide, bool in_hipslide, bool in_thighslide, bool in_elbowsjoint, const CValue& /*number*/ in_shadowtype, const CValue& /*number*/ in_shadowhands, bool in_selectusingui );
	EXPORTSTUBS CValue MakeControlSplines( const CValue& /*undefined*/ in_curvecollection, const CValue& /*number*/ in_nbdivisions, const CValue& /*number*/ in_scale, const CString& in_parent, const CValue& /*number*/ in_pointmarkertype, const CValue& /*number*/ in_pathmarkertype, const CValue& /*number*/ in_offsetmarkertype, const CValue& /*number*/ in_pointcolor, const CValue& /*number*/ in_pathcolor, const CValue& /*number*/ in_offsetcolor, bool in_inputfromui );
	EXPORTSTUBS CValue MakeCorridor( void );
	EXPORTSTUBS CValue MakeDogLeg( const CString& in_model, const CString& in_parent, const CString& in_footparent, const CString& in_guideobjectcollection, const CString& in_shortprefix, const CString& in_fullprefix, const CString& in_sliders, const CValue& /*number*/ in_nbthighdivisions, const CValue& /*number*/ in_shadowtype, const CString& in_shadowparent );
	EXPORTSTUBS CValue MakeDoor( void );
	EXPORTSTUBS CValue MakeFoot( const CString& in_model, const CString& in_parent, const CString& in_shortprefix, const CString& in_fullprefix, const CString& in_guideobjectcollection, const CString& in_sliders, bool in_extension, const CValue& /*number*/ in_shadowtype, const CString& in_shadowparent );
	EXPORTSTUBS CValue MakeForearmRoll( const CString& in_bicep, const CString& in_forearm, const CString& in_armeff, const CString& in_handeff, const CString& in_handbone, const CString& in_prefix, const CValue& /*number*/ in_nbdivisions, const CValue& /*number*/ in_rolloffset );
	EXPORTSTUBS CValue MakeHand( const CString& in_handparent, const CString& in_fingerguidecollection, const CString& in_bladeguidecollection, const CString& in_handguidecollection, const CString& in_prefix, const CValue& /*number*/ in_fingerbonetype, const CValue& /*number*/ in_shadowtype, const CString& in_shadowparent, bool in_negativescale );
	EXPORTSTUBS CValue MakeHead( const CString& in_parent, const CString& in_guideobjectcollection, const CString& in_prefix, const CValue& /*number*/ in_assemblytype, const CValue& /*number*/ in_headtype, const CValue& /*number*/ in_nbdivisions, const CValue& /*number*/ in_stretchtype, const CString& in_sliders, const CString& in_earguidecollection, const CValue& /*number*/ in_shadowtype, const CString& in_shadowparent );
	EXPORTSTUBS CValue MakeHip( const CString& in_guideobj, const CValue& /*number*/ in_topx, const CValue& /*number*/ in_topy, const CValue& /*number*/ in_topz, const CValue& /*number*/ in_sidex, const CValue& /*number*/ in_sidey, const CValue& /*number*/ in_sidez );
	EXPORTSTUBS CValue MakeJointCompression( const CString& in_prefix, const CString& in_upperbone, const CString& in_lowerbone, const CString& in_guideobjectcollection, const CString& in_rolldivisioncollection );
	EXPORTSTUBS CValue MakeLeg( const CString& in_model, const CString& in_parent, const CString& in_prefix, const CString& in_guideobjectcollection, bool in_upvectorbehindleg, const CValue& /*number*/ in_nbthighdivisions, const CValue& /*number*/ in_shadowtype, const CString& in_shadowparent );
	EXPORTSTUBS void MakeLocal( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_propagationtype );
	EXPORTSTUBS void MakeLocalMaterialsForHierarchy( const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS CValue MakeLoop( void );
	EXPORTSTUBS void MakeModelLocal( const CValue& /*undefined*/ in_clip );
	EXPORTSTUBS CValue MakeQuadruped( const CValue& /*number*/ in_torsotype, const CValue& /*number*/ in_torsostretch, const CValue& /*number*/ in_torsodivisions, const CValue& /*number*/ in_icontype, bool in_makebelly, const CValue& /*number*/ in_bellyslide, const CValue& /*number*/ in_bellycenterpercentage, const CValue& /*number*/ in_headtype, const CValue& /*number*/ in_headstretch, const CValue& /*number*/ in_headdivisions, bool in_ears, const CValue& /*number*/ in_maketail, const CValue& /*number*/ in_taildivisions, bool in_frontroll, const CValue& /*number*/ in_frontrolldivisions, bool in_backroll, const CValue& /*number*/ in_backrolldivisions, const CValue& /*number*/ in_shadowtype, bool in_selectusingui );
	EXPORTSTUBS CValue MakeRigIcon( const CString& in_parent, const CValue& /*number*/ in_type, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y, const CValue& /*number*/ in_z, const CValue& /*number*/ in_xlength, const CValue& /*number*/ in_ylength, const CValue& /*number*/ in_zlength, const CValue& /*number*/ in_color, const CString& in_name, const CValue& /*number*/ in_xoffset, const CValue& /*number*/ in_yoffset, const CValue& /*number*/ in_zoffset );
	EXPORTSTUBS CValue MakeRoom( void );
	EXPORTSTUBS void MakeRotationsContinuous( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue MakeShadowChain( const CString& in_chain, const CString& in_shadowparent, bool in_si3dstylechain, const CValue& /*number*/ in_iconscale, const CValue& /*number*/ in_shadowtype );
	EXPORTSTUBS CValue MakeShadowSpine( const CString& in_spline, const CString& in_base, const CString& in_vertebra, const CString& in_topvertebra, const CString& in_shadowparent, const CString& in_chesttop, const CValue& /*number*/ in_iconscale, const CValue& /*number*/ in_shadowtype );
	EXPORTSTUBS CValue MakeSkill( void );
	EXPORTSTUBS CValue MakeSpine( const CString& in_model, const CString& in_parent, const CValue& /*number*/ in_nbvertebrae, const CValue& /*number*/ in_spinetype, bool in_stretchy, const CString& in_spinebaseobject, const CString& in_spinetopobject, const CString& in_bottomdepthobject, const CString& in_topdepthobject, const CString& in_chesttop, const CString& in_sliders, const CValue& /*number*/ in_shadowtype, const CString& in_shadowparent );
	EXPORTSTUBS CValue MakeTail( const CString& in_parent, const CValue& /*undefined*/ in_guideobjectcollection, const CValue& /*number*/ in_nbtailbones, const CValue& /*number*/ in_shadowtype, const CString& in_shadowparent );
	EXPORTSTUBS CValue MakeThighSlide( const CString& in_prefix, const CString& in_guideobjectcollection, const CString& in_upperparent, const CString& in_lowerparent );
	EXPORTSTUBS CValue MakeTorso( const CString& in_parent, const CValue& /*number*/ in_nbdivisions, const CValue& /*number*/ in_stretchtype, const CString& in_guideobjectcollection, const CValue& /*number*/ in_controltype, const CValue& /*number*/ in_spinetype, const CString& in_sliders, const CValue& /*number*/ in_shadowtype, const CString& in_shadowparent, const CValue& /*number*/ in_negativescale );
	EXPORTSTUBS void ManipulateTool( const CString& in_clsid );
	EXPORTSTUBS void MatchTransform( const CValue& /*undefined*/ in_inputobjs, const CString& in_targetobj, const CString& in_type, bool in_localreference );
	EXPORTSTUBS CValue MatchUVW( const CValue& /*undefined*/ in_textureprojection, const CValue& /*undefined*/ in_subcomp, const CValue& /*number*/ in_tolerance );
	EXPORTSTUBS CValue MergeClips( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void MergeMixer( const CValue& /*undefined*/ in_filename, const CValue& /*undefined*/ in_parent, bool in_value );
	EXPORTSTUBS void MergeOrFreezeCharacter( const CValue& /*undefined*/ in_ob1, const CValue& /*undefined*/ in_ob2, const CValue& /*undefined*/ in_bcreatemodel );
	EXPORTSTUBS CValue MergeScene( const CString& in_filename, const CString& in_name, const CString& in_parent, const CValue& /*number*/ in_shareoptions, const CString& in_createdobj );
	EXPORTSTUBS void MergeSimulationEnvironments( const CValue& /*undefined*/ in_simulationenvironments );
	EXPORTSTUBS void MeshSubdivideWithCenter( const CString& in_presetobj, const CString& in_connectionset, const CValue& /*number*/ in_connecttype, siOperationMode in_immediatemode, siGeneratorInputsDisposalMode in_genopinputsdisposal );
	EXPORTSTUBS void ModifyUVSetByContourStretching( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_textureprojection, const CValue& /*number*/ in_contourstretchingmethod, bool in_maintainaspect, const CValue& /*undefined*/ in_cornerpoints );
	EXPORTSTUBS void Move2DShape( const CValue& /*undefined*/ in_shape, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y );
	EXPORTSTUBS void Move2DShapeLHandle( const CValue& /*undefined*/ in_shape, const CValue& /*number*/ in_index, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y );
	EXPORTSTUBS void Move2DShapePin( const CValue& /*undefined*/ in_shape, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y );
	EXPORTSTUBS void Move2DShapePoint( const CValue& /*undefined*/ in_shape, const CValue& /*number*/ in_index, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y );
	EXPORTSTUBS void Move2DShapeRHandle( const CValue& /*undefined*/ in_shape, const CValue& /*number*/ in_index, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y );
	EXPORTSTUBS void MoveClipToTrack( const CValue& /*undefined*/ in_model, const CValue& /*undefined*/ in_clip, const CValue& /*undefined*/ in_compound, const CValue& /*undefined*/ in_track, const CValue& /*undefined*/ in_time );
	EXPORTSTUBS void MoveComponent( const CRef& /*object*/ in_inputobjs, const CRef& /*object*/ in_deletedobjs, const CRef& /*object*/ in_createdobjs, bool in_proptagonly, const CRef& /*object*/ in_propinputobjs );
	EXPORTSTUBS void MoveCtr2Vertices( const CValue& /*undefined*/ in_inputobjs, bool in_boundingbox );
	EXPORTSTUBS void MoveJoint( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y, const CValue& /*number*/ in_z, bool in_movejointbranch, bool in_movejointbone );
	EXPORTSTUBS void MoveOperatorAfter( const CValue& /*undefined*/ in_object, const CValue& /*undefined*/ in_operatortomove, const CValue& /*undefined*/ in_operatorreference );
	EXPORTSTUBS void MoveOperatorBefore( const CValue& /*undefined*/ in_object, const CValue& /*undefined*/ in_operatortomove, const CValue& /*undefined*/ in_operatorreference );
	EXPORTSTUBS void MovePaintShapeHandle( const CValue& /*undefined*/ in_shape, const CValue& /*number*/ in_point, const CValue& /*number*/ in_handle, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y, const CValue& /*number*/ in_mode );
	EXPORTSTUBS void MovePointTool( const CString& in_clsid );
	EXPORTSTUBS void MoveTextureLayers( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_offset );
	EXPORTSTUBS void MoveToFolder( const CValue& /*undefined*/ in_target, const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void MoveToLayer( const CValue& /*undefined*/ in_target, const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void MoveToLibrary( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_target );
	EXPORTSTUBS void MoveToPartition( const CValue& /*undefined*/ in_target, const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_source );
	EXPORTSTUBS CValue MultiAttachRigidBodiesTool( const CString& in_name, const CValue& /*undefined*/ in_bodies );
	EXPORTSTUBS CValue NavigateNode( const CValue& /*undefined*/ in_source, const CValue& /*number*/ in_navdirection, bool in_navloop, const CValue& /*number*/ in_navfilter, const CValue& /*number*/ in_navsubfilter, const CRef& /*object*/ in_outputobj );
	EXPORTSTUBS void NewHelperBoneRig( const CValue& /*undefined*/ in_rig );
	EXPORTSTUBS void NewScene( const CString& in_projectpathname, bool in_confirm );
	EXPORTSTUBS void NextFrame( void );
	EXPORTSTUBS CValue NextKey( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_time, const CValue& /*number*/ in_tolerance );
	EXPORTSTUBS void NextModifiedPaintClipFrame( const CValue& /*undefined*/ in_paintclip );
	EXPORTSTUBS void NextPaintShapeKey( const CValue& /*undefined*/ in_shape, const CValue& /*undefined*/ in_time );
	EXPORTSTUBS void ObjExport( const CString& in_filename, const CValue& /*number*/ in_fileperobject, bool in_fileperframe, const CValue& /*number*/ in_startframe, const CValue& /*number*/ in_endframe, const CValue& /*number*/ in_stepframe, bool in_polymsh, bool in_surfmsh, bool in_crvlist, bool in_cloud, bool in_coordinatesystem, const CValue& /*number*/ in_tesselation, bool in_material, bool in_uv, bool in_usernormal );
	EXPORTSTUBS void ObjImport( const CString& in_filename, const CValue& /*number*/ in_group, const CValue& /*number*/ in_hrc, bool in_material, bool in_uv, bool in_usernormal );
	EXPORTSTUBS void OffloadAction( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void OffsetValueMap( const CValue& /*undefined*/ in_inputobjs, siEffectInputType in_type, const CValue& /*undefined*/ in_time, const CValue& /*undefined*/ in_value );
	EXPORTSTUBS void OpenAnimationEditor( const CString& in_animationview, const CString& in_inputobjs );
	EXPORTSTUBS void OpenAttachments( const CValue& /*undefined*/ in_target );
	EXPORTSTUBS void OpenNetView( const CValue& /*undefined*/ in_url, bool in_reuse, const CValue& /*number*/ in_flags );
	EXPORTSTUBS void OpenScene( const CValue& /*undefined*/ in_scenefilename, bool in_confirm, bool in_applyauxiliarydata );
	EXPORTSTUBS CValue OpenTransientExplorer( const CValue& /*undefined*/ in_initobjects, siTransientExplorerFilter in_filter, const CValue& /*number*/ in_expandlevel, bool in_sort, bool in_multiselect, const CRef& /*object*/ in_value );
	EXPORTSTUBS void OpenXSIExplorer( void );
	EXPORTSTUBS void OverrideLightShader( const CValue& /*undefined*/ in_presetobj, const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS void PaintPushTool( void );
	EXPORTSTUBS void PaintRasterLine( const CValue& /*number*/ in_x1, const CValue& /*number*/ in_y1, const CValue& /*number*/ in_p1, const CValue& /*number*/ in_x2, const CValue& /*number*/ in_y2, const CValue& /*number*/ in_p2 );
	EXPORTSTUBS void PaintSelectTool( const CString& in_clsid, const CString& in_cmdid, bool in_keyboardprocess );
	EXPORTSTUBS void PaintShapeManipTool( void );
	EXPORTSTUBS void PaintTool( const CString& in_clsid, const CString& in_cmdid, bool in_keyboardprocess );
	EXPORTSTUBS CValue PaintVertexColors( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_polynodes, const CValue& /*undefined*/ in_colors, const CValue& /*number*/ in_mode, const CRef& /*object*/ in_outputobj );
	EXPORTSTUBS void PaintVertexColorTool( const CString& in_clsid, const CString& in_cmdid, bool in_keyboardprocess );
	EXPORTSTUBS CValue PaintWeights( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_indices, const CValue& /*undefined*/ in_weights, const CValue& /*number*/ in_flags, const CValue& /*number*/ in_deformer, const CRef& /*object*/ in_outputobj );
	EXPORTSTUBS void ParamBracketing( void );
	EXPORTSTUBS void ParentObj( const CValue& /*undefined*/ in_parent, const CValue& /*undefined*/ in_children );
	EXPORTSTUBS void PartialOffloadAction( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_startframe, const CValue& /*number*/ in_endframe, bool in_remember );
	EXPORTSTUBS void Paste( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue PasteAction( const CValue& /*undefined*/ in_source, const CValue& /*undefined*/ in_target, const CValue& /*number*/ in_copystart, const CValue& /*number*/ in_copyend, const CValue& /*number*/ in_startframe, const CValue& /*number*/ in_endframe, bool in_ripple );
	EXPORTSTUBS void PasteAllAnimation( const CValue& /*undefined*/ in_inputobjs, bool in_useposition );
	EXPORTSTUBS void PasteAnimation( const CValue& /*undefined*/ in_inputobjs, bool in_useposition );
	EXPORTSTUBS void PasteFxOp( const CValue& /*undefined*/ in_fxtree );
	EXPORTSTUBS void PasteKeys( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_startframe, const CValue& /*number*/ in_endframe, bool in_ripple, const CValue& /*number*/ in_offset, bool in_merge );
	EXPORTSTUBS void PasteUVW( const CValue& /*undefined*/ in_textureprojection, const CValue& /*undefined*/ in_subcomp );
	EXPORTSTUBS void PathRetime( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_s3d_cmdarg_start1, const CValue& /*number*/ in_s3d_cmdarg_end1, const CValue& /*number*/ in_s3d_cmdarg_start2, const CValue& /*number*/ in_s3d_cmdarg_end2 );
	EXPORTSTUBS void PickElement( const CValue& /*undefined*/ in_selfilter, const CString& in_leftmessage, const CString& in_middlemessage, const CRef& /*object*/ in_pickedelement, const CValue& /*number*/ in_buttonpressed, const CValue& /*number*/ in_selregionmode, const CValue& /*number*/ in_modifierpressed );
	EXPORTSTUBS void PickObject( const CString& in_leftmessage, const CString& in_middlemessage, const CString& in_pickedelement, const CRef& /*object*/ in_buttonpressed, const CValue& /*number*/ in_modifierpressed );
	EXPORTSTUBS void PickPosition( const CString& in_leftmessage, const CString& in_middlemessage, const CValue& /*number*/ in_posx, const CValue& /*number*/ in_posy, const CValue& /*number*/ in_posz, const CValue& /*number*/ in_buttonpressed );
	EXPORTSTUBS void PlaybackStop( void );
	EXPORTSTUBS void PlayBackwards( void );
	EXPORTSTUBS void PlayBackwardsFromEnd( void );
	EXPORTSTUBS void PlayForwards( void );
	EXPORTSTUBS void PlayForwardsFromStart( void );
	EXPORTSTUBS void PlayFrame( void );
	EXPORTSTUBS void PlayRealTime( void );
	EXPORTSTUBS void PlayRealTimeFromStart( void );
	EXPORTSTUBS void PlotAndApplyAction( const CValue& /*undefined*/ in_model, const CString& in_inputobj, const CValue& /*undefined*/ in_name, const CValue& /*undefined*/ in_startframe, const CValue& /*undefined*/ in_endframe, const CValue& /*undefined*/ in_stepframe, const CValue& /*undefined*/ in_fcurve_kind, const CValue& /*undefined*/ in_defaultsegkind, const CValue& /*undefined*/ in_fit_fcurve, const CValue& /*undefined*/ in_fit_tolerance, const CValue& /*undefined*/ in_processcontrots, const CValue& /*undefined*/ in_apply, const CValue& /*undefined*/ in_paste, const CValue& /*undefined*/ in_delete, const CString& in_title );
	EXPORTSTUBS void PlotConstrainedTransforms( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_name, const CValue& /*undefined*/ in_startframe, const CValue& /*undefined*/ in_endframe, const CValue& /*undefined*/ in_stepframe, const CValue& /*undefined*/ in_fcurve_kind, const CValue& /*undefined*/ in_defaultsegkind, const CValue& /*undefined*/ in_fit_fcurve, const CValue& /*undefined*/ in_fit_tolerance, const CValue& /*undefined*/ in_processcontrots, const CValue& /*undefined*/ in_apply, const CValue& /*undefined*/ in_paste, const CValue& /*undefined*/ in_delete, const CString& in_title );
	EXPORTSTUBS void PlotCurve( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_name, const CValue& /*undefined*/ in_startframe, const CValue& /*undefined*/ in_endframe, const CValue& /*undefined*/ in_stepframe );
	EXPORTSTUBS void PlotShape( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_name, const CValue& /*undefined*/ in_startframe, const CValue& /*undefined*/ in_endframe, const CValue& /*undefined*/ in_stepframe, const CValue& /*undefined*/ in_applykeys, const CValue& /*undefined*/ in_mode, const CValue& /*undefined*/ in_content, const CValue& /*undefined*/ in_refmode, const CValue& /*undefined*/ in_singlesource, const CRef& /*object*/ in_keylist, const CRef& /*object*/ in_cliplist );
	EXPORTSTUBS CValue PlotToAction( const CValue& /*undefined*/ in_model, const CValue& /*undefined*/ in_inputobj, const CString& in_name, const CValue& /*number*/ in_startframe, const CValue& /*number*/ in_endframe, const CValue& /*number*/ in_stepframe, const CValue& /*number*/ in_fcurve_kind, const CValue& /*number*/ in_defaultsegkind, bool in_fit_fcurve, const CValue& /*number*/ in_fit_tolerance, bool in_processcontrots );
	EXPORTSTUBS void PrevFrame( void );
	EXPORTSTUBS CValue PrevKey( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_time, const CValue& /*number*/ in_tolerance );
	EXPORTSTUBS void PrevModifiedPaintClipFrame( const CValue& /*undefined*/ in_paintclip );
	EXPORTSTUBS void PrevPaintShapeKey( const CValue& /*undefined*/ in_shape, const CValue& /*undefined*/ in_time );
	EXPORTSTUBS void PropertyTransfer( const CValue& /*undefined*/ in_target, const CValue& /*undefined*/ in_propobj );
	EXPORTSTUBS void RandomizeParameters( const CValue& /*undefined*/ in_params, const CValue& /*number*/ in_percentage, bool in_relative, const CValue& /*number*/ in_seed );
	EXPORTSTUBS void ReconnectMixer( const CValue& /*undefined*/ in_model );
	EXPORTSTUBS void ReconnectModel( const CValue& /*undefined*/ in_model, const CString& in_externalcnxmappingtemplate, bool in_deleteunconnectedobjects );
	EXPORTSTUBS void RectanglePaintRaster( const CValue& /*number*/ in_x1, const CValue& /*number*/ in_y1, const CValue& /*number*/ in_x2, const CValue& /*number*/ in_y2, bool in_fromcenter );
	EXPORTSTUBS CValue RectangularPaintMask( const CValue& /*number*/ in_x1, const CValue& /*number*/ in_y1, const CValue& /*number*/ in_x2, const CValue& /*number*/ in_y2, bool in_fromcenter, const CValue& /*number*/ in_selectionaction, bool in_antialiased, const CValue& /*number*/ in_feather, const CRef& /*object*/ in_value );
	EXPORTSTUBS void Redo( void );
	EXPORTSTUBS void Refresh( const CValue& /*undefined*/ in_time );
	EXPORTSTUBS void RefreshCustomPreferences( void );
	EXPORTSTUBS void RefreshRegion( void );
	EXPORTSTUBS void RegenerateMaps( const CValue& /*undefined*/ in_properties );
	EXPORTSTUBS CValue RelaxUVW( const CValue& /*undefined*/ in_textureprojection, const CValue& /*undefined*/ in_subcomp );
	EXPORTSTUBS void ReloadAction( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void ReloadAddonLib( const CValue& /*undefined*/ in_filename );
	EXPORTSTUBS void ReloadAllAddonLibs( void );
	EXPORTSTUBS void RemoveAllAnimation( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_time, siBranchFlag in_branchflag, siSourceType in_sourcemask, siParameterFilter in_parametermask );
	EXPORTSTUBS void RemoveAllCns( const CValue& /*undefined*/ in_constrainedobj, const CValue& /*number*/ in_propagation );
	EXPORTSTUBS void RemoveAllProperties( const CValue& /*undefined*/ in_inputobjs, siBranchFlag in_branchflag );
	EXPORTSTUBS void RemoveAllShadersFromCnxPoint( const CValue& /*undefined*/ in_inputobjs, siShaderCnxPointType in_type );
	EXPORTSTUBS void RemoveAnimation( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_time );
	EXPORTSTUBS void RemoveCluster( const CString& in_inputobjs );
	EXPORTSTUBS void RemoveCns( const CValue& /*undefined*/ in_constrainedobj, const CValue& /*undefined*/ in_constrainingobj, bool in_forcedeletion );
	EXPORTSTUBS void RemoveCnsType( const CString& in_type, const CValue& /*undefined*/ in_constrainedobj );
	EXPORTSTUBS CValue RemoveCOG( void );
	EXPORTSTUBS void RemoveCustomParam( const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS void RemoveEffect( const CValue& /*undefined*/ in_clip );
	EXPORTSTUBS CValue RemoveExternalConstraints( const CValue& /*undefined*/ in_inputobj, const CString& in_operation );
	EXPORTSTUBS void RemoveFlexEnv( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void RemoveFlexEnvDeformer( const CValue& /*undefined*/ in_connectionset, bool in_interactive );
	EXPORTSTUBS CValue RemoveFloor( void );
	EXPORTSTUBS void RemoveFolder( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue RemoveFoot( void );
	EXPORTSTUBS void RemoveFromCluster( const CString& in_inputobjs );
	EXPORTSTUBS void RemoveFromContainer( const CString& in_target, const CString& in_inputobjs );
	EXPORTSTUBS void RemoveFromFolder( const CValue& /*undefined*/ in_target, const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void RemoveFromGroup( const CValue& /*undefined*/ in_target, const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void RemoveFromMarking( const CValue& /*undefined*/ in_pathlist );
	EXPORTSTUBS void RemoveFromPartition( const CValue& /*undefined*/ in_target, const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue RemoveFromSelection( const CValue& /*undefined*/ in_selectionlist, const CString& in_hierarchylevel );
	EXPORTSTUBS void RemoveGroup( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void RemoveInputFromOperator( const CValue& /*undefined*/ in_reference );
	EXPORTSTUBS CValue RemoveJointLimit( void );
	EXPORTSTUBS void RemoveKey( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_time, const CValue& /*number*/ in_tolerance );
	EXPORTSTUBS void RemoveLastPointInteriorToPolygon( const CValue& /*undefined*/ in_operator, const CValue& /*number*/ in_polygonid );
	EXPORTSTUBS void RemoveObjectsFromShader( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_target );
	EXPORTSTUBS void RemoveParTypeInstanceGroup( const CValue& /*undefined*/ in_partype );
	EXPORTSTUBS void RemovePointFromPolygon( const CValue& /*undefined*/ in_inputobj, const CValue& /*number*/ in_pointid, const CValue& /*number*/ in_polygonid );
	EXPORTSTUBS void RemoveProperties( const CValue& /*undefined*/ in_inputobjs, const CString& in_type, siBranchFlag in_branchflag );
	EXPORTSTUBS void RemoveProxyParam( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void RemoveRelativeValue( const CValue& /*undefined*/ in_inputobj, const CValue& /*number*/ in_index );
	EXPORTSTUBS void RemoveRigidBody( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue RemoveShaderFromCnxPoint( const CValue& /*undefined*/ in_source, const CValue& /*undefined*/ in_inputobjs, bool in_deleteonlastdisconnection );
	EXPORTSTUBS void RemoveTextureLayers( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_container );
	EXPORTSTUBS void RemoveUserParameter( const CValue& /*undefined*/ in_target, const CString& in_name );
	EXPORTSTUBS void RenamePropAndRebind( const CValue& /*undefined*/ in_properties, const CString& in_newname, bool in_updaterefs, bool in_updatewildcards, bool in_showui );
	EXPORTSTUBS void RenamePropAndRebind_Internal( const CValue& /*undefined*/ in_properties, const CString& in_propertyname, bool in_updaterefs, bool in_updatewildcards );
	EXPORTSTUBS void RenamePropAndRebindUI( const CValue& /*undefined*/ in_properties, const CString& in_newname, bool in_updaterefs, bool in_updatewildcards );
	EXPORTSTUBS void RenderAllPasses( bool in_passcentric );
	EXPORTSTUBS void RenderFxOp( const CValue& /*undefined*/ in_inputobj, bool in_interactive );
	EXPORTSTUBS void RenderPass( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_presetobj, const CValue& /*undefined*/ in_startframe, const CValue& /*undefined*/ in_endframe, const CValue& /*undefined*/ in_stepframe, bool in_disposerendering );
	EXPORTSTUBS void RenderRegionTool( const CString& in_clsid, bool in_keyboardprocess );
	EXPORTSTUBS CValue RenderSetup( void );
	EXPORTSTUBS void ReplaceShader( const CValue& /*undefined*/ in_source, const CValue& /*undefined*/ in_target );
	EXPORTSTUBS void ReplaceShaderWithPreset( const CValue& /*undefined*/ in_source, const CValue& /*undefined*/ in_presetobj );
	EXPORTSTUBS void ReplaceShapeKey( const CValue& /*undefined*/ in_inputobj, const CRef& /*object*/ in_outputobj );
	EXPORTSTUBS CValue ResetActor( const CValue& /*undefined*/ in_propobj, bool in_parameter );
	EXPORTSTUBS void ResetAllEffectCurves( const CValue& /*undefined*/ in_clip );
	EXPORTSTUBS void ResetAllHelperTriggers( const CValue& /*undefined*/ in_helper, bool in_confirm );
	EXPORTSTUBS void ResetAllViews( const CValue& /*number*/ in_view, bool in_allviews );
	EXPORTSTUBS void ResetEffectAtFrame( const CValue& /*undefined*/ in_clip, const CValue& /*undefined*/ in_time );
	EXPORTSTUBS CValue ResetFlexEnvPtsAssignment( const CValue& /*undefined*/ in_subcomp, const CValue& /*undefined*/ in_connectionset );
	EXPORTSTUBS void ResetHelperBoneRig( const CValue& /*undefined*/ in_rig, bool in_prompt );
	EXPORTSTUBS void ResetOffset( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_time );
	EXPORTSTUBS void ResetPaintColor( void );
	EXPORTSTUBS void ResetRenderFilePaths( const CValue& /*undefined*/ in_inputobjs, bool in_resettorelative, bool in_includepassname, bool in_includescenename, const CString& in_prefix, const CString& in_separatortoken );
	EXPORTSTUBS void ResetSelectedEffectCurves( const CValue& /*undefined*/ in_clip );
	EXPORTSTUBS void ResetTransform( const CValue& /*undefined*/ in_inputobjs, siCenterMode in_center, siTransformFilter in_type, siAxesFilter in_axesfilter );
	EXPORTSTUBS void RestoreDefaultPreference( const CString& in_preferencename );
	EXPORTSTUBS void RevertPaintClip( const CValue& /*undefined*/ in_paintclip );
	EXPORTSTUBS void RevertPaintClipFrame( const CValue& /*undefined*/ in_paintclip, const CValue& /*undefined*/ in_time );
	EXPORTSTUBS void RevertSelectedPaintClipFrame( const CValue& /*undefined*/ in_paintclip );
	EXPORTSTUBS void Rotate( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y, const CValue& /*number*/ in_z, siDeltaMode in_delta, siRefMode in_refmode, siCenterMode in_center, siAxesFilter in_axesfilter, const CValue& /*undefined*/ in_reference, bool in_splitlocalcomponents, bool in_proptagonly, bool in_pivot, const CValue& /*number*/ in_pivotx, const CValue& /*number*/ in_pivoty, const CValue& /*number*/ in_pivotz, const CValue& /*undefined*/ in_constructionmode );
	EXPORTSTUBS void RotateUVW( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_textureprojection, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y, const CValue& /*number*/ in_z, siDeltaMode in_delta, siUVWAxesFilter in_axesfilter, bool in_pivot, const CValue& /*number*/ in_pivotu, const CValue& /*number*/ in_pivotv, const CValue& /*number*/ in_pivotw, const CValue& /*number*/ in_aspectratio );
	EXPORTSTUBS void RotationTool( const CString& in_clsid );
	EXPORTSTUBS void RunPerformanceTest( const CValue& /*number*/ in_type, const CValue& /*undefined*/ in_filename, const CValue& /*number*/ in_duration );
	EXPORTSTUBS CValue SampleParameterValues( const CValue& /*undefined*/ in_inputobj, const CValue& /*number*/ in_samplingmethod, const CValue& /*number*/ in_nbsamples, const CValue& /*number*/ in_percentage, bool in_relative, const CValue& /*number*/ in_seed, const CString& in_capturemethod, const CString& in_capturename, const CValue& /*number*/ in_capturesize, bool in_retrieveresult, const CValue& /*number*/ in_resultid );
	EXPORTSTUBS void SaveActionKey( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_time, const CValue& /*undefined*/ in_value, const CValue& /*undefined*/ in_tolerance, const CString& in_source, const CValue& /*number*/ in_with_autokey_behavior );
	EXPORTSTUBS CValue SaveActor( void );
	EXPORTSTUBS CValue SaveDeformKey( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_clustershapekey );
	EXPORTSTUBS void SaveKey( const CString& in_inputobjs, const CValue& /*undefined*/ in_time, const CValue& /*undefined*/ in_value, const CValue& /*undefined*/ in_tolerance, const CString& in_source, const CValue& /*number*/ in_with_autokey_behavior );
	EXPORTSTUBS void SaveKeyAtMultipleFrames( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void SaveKeyOnPath( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_time, const CValue& /*undefined*/ in_x, const CValue& /*undefined*/ in_y, const CValue& /*undefined*/ in_z, bool in_locked );
	EXPORTSTUBS void SaveOffsetKeys( const CValue& /*undefined*/ in_inputobjs, siEffectInputType in_type, const CValue& /*undefined*/ in_time );
	EXPORTSTUBS void SavePaintClip( const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS void SavePaintShapeKey( const CValue& /*undefined*/ in_shape, const CValue& /*undefined*/ in_time );
	EXPORTSTUBS void SavePivotKey( const CValue& /*undefined*/ in_inputobjs, siTransformFilter in_type, const CValue& /*undefined*/ in_time );
	EXPORTSTUBS CValue SavePreset( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_presetname, const CString& in_presetpath, siPresetLocation in_presetlocation, bool in_overwrite, bool in_createthumbnail, const CString& in_description );
	EXPORTSTUBS void SaveRegionAs( const CString& in_filename );
	EXPORTSTUBS void SaveScene( void );
	EXPORTSTUBS void SaveSceneAs( const CValue& /*undefined*/ in_scenefilename, bool in_copyextfiles );
	EXPORTSTUBS void SaveSelectedPaintClipFrames( const CValue& /*undefined*/ in_paintclip );
	EXPORTSTUBS CValue SaveShapeKey( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_compound, const CValue& /*undefined*/ in_track, const CValue& /*undefined*/ in_time, const CValue& /*undefined*/ in_duration, const CValue& /*undefined*/ in_mode, const CValue& /*undefined*/ in_name, const CValue& /*undefined*/ in_overwrite, siShapeReferenceMode in_refmode );
	EXPORTSTUBS void Scale( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y, const CValue& /*number*/ in_z, siDeltaMode in_delta, siRefMode in_refmode, siCenterMode in_center, siAxesFilter in_axesfilter, const CValue& /*undefined*/ in_reference, bool in_splitlocalcomponents, bool in_proptagonly, bool in_pivot, const CValue& /*number*/ in_pivotx, const CValue& /*number*/ in_pivoty, const CValue& /*number*/ in_pivotz, const CValue& /*undefined*/ in_constructionmode );
	EXPORTSTUBS void Scale2DShape( const CValue& /*undefined*/ in_shape, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y );
	EXPORTSTUBS void ScaleAndOffset( const CValue& /*undefined*/ in_inputobjs, siSequenceType in_type, const CValue& /*number*/ in_offset, const CValue& /*number*/ in_scale, const CValue& /*number*/ in_startframe, const CValue& /*number*/ in_endframe, const CValue& /*number*/ in_pivot, bool in_ripple, siSequenceMode in_mode, bool in_discrete_time );
	EXPORTSTUBS void ScaleUVW( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_textureprojection, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y, const CValue& /*number*/ in_z, siDeltaMode in_delta, siUVWAxesFilter in_axesfilter, bool in_pivot, const CValue& /*number*/ in_pivotu, const CValue& /*number*/ in_pivotv, const CValue& /*number*/ in_pivotw );
	EXPORTSTUBS void ScalingTool( const CString& in_clsid );
	EXPORTSTUBS void SceneRefresh( void );
	EXPORTSTUBS void SearchAndReplacePath( const CString& in_category, const CString& in_oldstring, const CString& in_newstring, bool in_casesensitive );
	EXPORTSTUBS CValue SelectActionsFromObjects( const CValue& /*undefined*/ in_inputobjs, bool in_consider_time, const CValue& /*undefined*/ in_time, bool in_keep_compound_actions, bool in_keep_inactive_actions );
	EXPORTSTUBS void SelectAdjacent( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_selfilter, bool in_extendselection );
	EXPORTSTUBS CValue SelectAll( const CString& in_affectselectionlist, bool in_checkobjectselectability );
	EXPORTSTUBS void SelectAllHelperBones( const CValue& /*undefined*/ in_rig );
	EXPORTSTUBS CValue SelectAllUsingFilter( const CValue& /*undefined*/ in_selfilter, siComponentVisibilityMode in_checkcomponentvisibility, bool in_affectselectionlist, bool in_checkobjectselectability );
	EXPORTSTUBS void SelectBoundaryEdgeLoop( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void SelectBranch( const CValue& /*undefined*/ in_checkobjectselectability );
	EXPORTSTUBS void SelectChain( const CValue& /*undefined*/ in_checkobjectselectability );
	EXPORTSTUBS CValue SelectChildNodes( const CString& in_selectionlist, const CValue& /*undefined*/ in_affectselectionlist, bool in_checkobjectselectability );
	EXPORTSTUBS void SelectConstrainedObjects( const CValue& /*undefined*/ in_constrainingobj );
	EXPORTSTUBS void SelectConstrainingObjects( const CValue& /*undefined*/ in_constrainedobj );
	EXPORTSTUBS void SelectDeformersFromEnvelope( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void SelectEdgeFilter( void );
	EXPORTSTUBS void SelectEdgeLoop( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue SelectExternalConstraints( const CValue& /*undefined*/ in_inputobj, const CString& in_operation );
	EXPORTSTUBS void SelectFilter( const CValue& /*undefined*/ in_selfilter );
	EXPORTSTUBS void SelectGeneratorInputs( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void SelectGeometryComponents( const CValue& /*undefined*/ in_selectionlist );
	EXPORTSTUBS CValue SelectMembers( const CValue& /*undefined*/ in_selectionlist, bool in_affectselectionlist, bool in_checkobjectselectability );
	EXPORTSTUBS void SelectModel( const CValue& /*undefined*/ in_checkobjectselectability );
	EXPORTSTUBS void SelectNeighborObj( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_navigdirection, const CString& in_hierarchylevel, bool in_addtoselection );
	EXPORTSTUBS void SelectNSidedPolygons( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_value, bool in_exactedgecount );
	EXPORTSTUBS void SelectObj( const CValue& /*undefined*/ in_selectionlist, const CString& in_hierarchylevel, bool in_checkobjectselectability );
	EXPORTSTUBS void SelectObjectFilter( void );
	EXPORTSTUBS CValue SelectObjectsFromAction( const CValue& /*undefined*/ in_inputobj, bool in_onlyposeoffset );
	EXPORTSTUBS void SelectPaintClipFrames( const CValue& /*undefined*/ in_paintclip, const CValue& /*undefined*/ in_frames );
	EXPORTSTUBS void SelectPaintShapePoint( const CValue& /*undefined*/ in_shape, const CValue& /*undefined*/ in_indices );
	EXPORTSTUBS void SelectParallelEdgeLoop( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void SelectPolygonFilter( void );
	EXPORTSTUBS void SelectSampledPointFilter( void );
	EXPORTSTUBS CValue SelectShapeKey( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_sourceobj, siShapeReferenceMode in_refmode, bool in_relational, bool in_applykeys );
	EXPORTSTUBS void SelectTree( const CValue& /*undefined*/ in_checkobjectselectability );
	EXPORTSTUBS void SelectUVRow( void );
	EXPORTSTUBS void SelectVertexFilter( void );
	EXPORTSTUBS void Sequence( const CValue& /*undefined*/ in_inputobjs, siSequenceType in_type, const CValue& /*number*/ in_offset, const CValue& /*number*/ in_scale, const CValue& /*number*/ in_startframe, const CValue& /*number*/ in_endframe, const CValue& /*number*/ in_pivot, siSequenceMode in_mode );
	EXPORTSTUBS void Set2DShapeRotation( const CValue& /*undefined*/ in_shape, const CValue& /*number*/ in_angle );
	EXPORTSTUBS void SetActiveElements( const CValue& /*undefined*/ in_selectionlist );
	EXPORTSTUBS void SetAndToggleActiveElements( const CValue& /*undefined*/ in_selectionlist );
	EXPORTSTUBS void SetAndToggleSelection( const CValue& /*undefined*/ in_selectionlist, const CString& in_hierarchylevel, bool in_checkobjectselectability );
	EXPORTSTUBS void SetBoneMaxRotLimit( const CValue& /*undefined*/ in_inputobjs, bool in_domin );
	EXPORTSTUBS void SetBoneMinRotLimit( const CValue& /*undefined*/ in_inputobjs, bool in_domin );
	EXPORTSTUBS void SetBoneRotationToPrefRotation( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue SetCOG( void );
	EXPORTSTUBS CValue SetCollisionOnly( void );
	EXPORTSTUBS CValue SetCopyShapeCluster( void );
	EXPORTSTUBS void SetCurrentEnvironment( const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS void SetCurrentLayer( const CValue& /*undefined*/ in_value );
	EXPORTSTUBS void SetCurrentMaterialLibrary( const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS void SetCurrentParType( const CValue& /*undefined*/ in_value );
	EXPORTSTUBS void SetCurrentPass( const CValue& /*undefined*/ in_value );
	EXPORTSTUBS void SetCurrentReferencePlane( const CValue& /*undefined*/ in_value );
	EXPORTSTUBS void SetCurveType( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_interpolation );
	EXPORTSTUBS CValue SetDefault( void );
	EXPORTSTUBS void SetDefaultWeight( const CValue& /*undefined*/ in_inputobj, siWeightPresets in_mode, const CValue& /*number*/ in_extra );
	EXPORTSTUBS void SetDisplayMode( const CValue& /*undefined*/ in_inputobjs, const CString& in_displaymode );
	EXPORTSTUBS void SetDropMessage( const CString& in_message );
	EXPORTSTUBS CValue SetEnvelopeRefPoses( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void SetEventObstacle( const CValue& /*undefined*/ in_target, const CValue& /*undefined*/ in_source );
	EXPORTSTUBS void SetExpr( const CValue& /*undefined*/ in_inputobj, const CString& in_exprstr, const CRef& /*object*/ in_exprobj );
	EXPORTSTUBS CValue SetFoot( void );
	EXPORTSTUBS void SetFxOpAttrib( const CValue& /*undefined*/ in_op, const CString& in_attrib, const CValue& /*undefined*/ in_value );
	EXPORTSTUBS void SetFxOpCnxFlag( const CValue& /*undefined*/ in_fxop, const CString& in_connection, const CString& in_flagname, bool in_value );
	EXPORTSTUBS void SetFxOpPos( const CValue& /*undefined*/ in_fxop, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y );
	EXPORTSTUBS void SetFxTrackerSearchArea( const CValue& /*undefined*/ in_fxop, const CValue& /*undefined*/ in_time, const CValue& /*number*/ in_tracker, const CValue& /*number*/ in_x1, const CValue& /*number*/ in_y1, const CValue& /*number*/ in_x2, const CValue& /*number*/ in_y2 );
	EXPORTSTUBS void SetFxTrackerTemplateArea( const CValue& /*undefined*/ in_fxop, const CValue& /*undefined*/ in_time, const CValue& /*number*/ in_tracker, const CValue& /*number*/ in_x1, const CValue& /*number*/ in_y1, const CValue& /*number*/ in_x2, const CValue& /*number*/ in_y2 );
	EXPORTSTUBS void SetFxTrackerTrackedPoint( const CValue& /*undefined*/ in_fxop, const CValue& /*undefined*/ in_time, const CValue& /*number*/ in_tracker, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y );
	EXPORTSTUBS void SetHelperTriggerOri( const CValue& /*undefined*/ in_helper, const CValue& /*number*/ in_index );
	EXPORTSTUBS CValue SetHome( void );
	EXPORTSTUBS void SetImageSource( const CValue& /*undefined*/ in_source, const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void SetInstanceDataValue( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_value );
	EXPORTSTUBS void SetKey( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_time, const CValue& /*undefined*/ in_value, const CValue& /*number*/ in_tolerance, const CValue& /*undefined*/ in_prevvalue, bool in_haskey );
	EXPORTSTUBS void SetKeyUsingMarkingSet( const CValue& /*undefined*/ in_inputobjs, bool in_branch );
	EXPORTSTUBS void SetMappingRule( const CValue& /*undefined*/ in_mappingtemplate, const CString& in_from, const CString& in_to, const CValue& /*number*/ in_index, const CValue& /*number*/ in_active, const CValue& /*number*/ in_poseoffset );
	EXPORTSTUBS void SetMarking( const CValue& /*undefined*/ in_pathlist );
	EXPORTSTUBS void SetNeutralPose( const CValue& /*undefined*/ in_inputobjs, siTransformFilter in_type, bool in_reset );
	EXPORTSTUBS void SetPaintBrush( const CString& in_brush );
	EXPORTSTUBS void SetPaintColor( const CValue& /*number*/ in_red, const CValue& /*number*/ in_green, const CValue& /*number*/ in_blue, const CValue& /*number*/ in_alpha );
	EXPORTSTUBS void SetPaintMaskStore( const CValue& /*undefined*/ in_fxop );
	EXPORTSTUBS void SetPaintMergeStore( const CValue& /*undefined*/ in_fxop );
	EXPORTSTUBS void SetPaintShapeHandle( const CValue& /*undefined*/ in_shape, const CValue& /*number*/ in_point, const CValue& /*number*/ in_lhx, const CValue& /*number*/ in_lhy, const CValue& /*number*/ in_lrx, const CValue& /*number*/ in_lry );
	EXPORTSTUBS void SetPaintStore( const CValue& /*undefined*/ in_fxop );
	EXPORTSTUBS void SetParameterColor( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_value );
	EXPORTSTUBS void SetParticleInitState( const CValue& /*undefined*/ in_inputobj, const CValue& /*number*/ in_overwrite );
	EXPORTSTUBS void SetParticleType( const CValue& /*undefined*/ in_target, const CValue& /*undefined*/ in_source );
	EXPORTSTUBS void SetParTypeInstanceGroup( const CValue& /*undefined*/ in_partype, const CValue& /*undefined*/ in_group );
	EXPORTSTUBS void SetReference( const CValue& /*undefined*/ in_target, const CValue& /*undefined*/ in_value, const CValue& /*undefined*/ in_time );
	EXPORTSTUBS void SetReferencePlane( const CValue& /*undefined*/ in_target, const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS CValue SetRefPlaneFromSymmetrizePolygonOp( const CString& in_refplane, const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void SetRelativeValues( const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS void SetResolutionOfRefModels( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_resolution );
	EXPORTSTUBS void SetRGB( void );
	EXPORTSTUBS void SetRigidBodyInitState( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void SetSelFilter( const CValue& /*undefined*/ in_selfilter );
	EXPORTSTUBS CValue SetSymmetrizePolygonOpRefPlane( const CValue& /*undefined*/ in_inputobjs, const CString& in_refplane );
	EXPORTSTUBS void SetThumbnail( const CValue& /*undefined*/ in_inputobjs, const CString& in_pathname );
	EXPORTSTUBS void SetThumbnailFromRegion( const CValue& /*undefined*/ in_inputobjs, const CString& in_filename, bool in_overwrite );
	EXPORTSTUBS CValue SetTransformRefMode( const CValue& /*number*/ in_mode );
	EXPORTSTUBS void SetTransientReferencePlane( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void SetupTestScene( void );
	EXPORTSTUBS void SetUserKeyword( const CValue& /*undefined*/ in_inputobjs, const CString& in_keywords );
	EXPORTSTUBS CValue SetUserPref( const CString& in_target, const CValue& /*number*/ in_value );
	EXPORTSTUBS CValue SetValue( const CString& in_target, const CValue& /*value*/ in_value, const CValue& /*undefined*/ in_time );
	EXPORTSTUBS CValue SetVisualOnly( void );
	EXPORTSTUBS void ShadeObject( const CValue& /*number*/ in_shademodeid );
	EXPORTSTUBS void Show3DContextMenu( void );
	EXPORTSTUBS CValue ShowConcaveEdges( const CValue& /*number*/ in_arg0 );
	EXPORTSTUBS void ShowHelperBoneTool( void );
	EXPORTSTUBS void ShowNextOGLProjection( void );
	EXPORTSTUBS void ShowPreviousOGLProjection( void );
	EXPORTSTUBS void ShowSwiftMenu( const CValue& /*number*/ in_target );
	EXPORTSTUBS void ShowValveSourceHelp( const CValue& /*undefined*/ in_relativepath );
	EXPORTSTUBS CValue SIAddArrayElement( const CValue& /*undefined*/ in_object );
	EXPORTSTUBS void SIAddCustomParam( const CValue& /*undefined*/ in_inputobj, const CString& in_scriptname, siVariantType in_vartype, const CValue& /*undefined*/ in_defaultvalue, const CValue& /*number*/ in_minvalue, const CValue& /*number*/ in_maxvalue, const CValue& /*number*/ in_classification, const CValue& /*number*/ in_capabilities, const CValue& /*number*/ in_suggmin, const CValue& /*number*/ in_suggmax, const CString& in_paramname, const CString& in_description );
	EXPORTSTUBS void SIAddCustomParameter( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_scriptname, siVariantType in_vartype, const CValue& /*undefined*/ in_defaultvalue, const CValue& /*undefined*/ in_minvalue, const CValue& /*undefined*/ in_maxvalue, const CValue& /*number*/ in_classification, const CValue& /*undefined*/ in_capabilities, const CValue& /*undefined*/ in_suggmin, const CValue& /*undefined*/ in_suggmax, const CValue& /*undefined*/ in_paramname, const CValue& /*undefined*/ in_description );
	EXPORTSTUBS void SIAddEntryToOverride( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_type );
	EXPORTSTUBS void SIAddImageClip( const CValue& /*undefined*/ in_source, const CString& in_name, const CRef& /*object*/ in_clip );
	EXPORTSTUBS CValue SIAddImageOp( const CValue& /*undefined*/ in_presetobj, const CValue& /*undefined*/ in_clip );
	EXPORTSTUBS void SIAddImageSource( const CValue& /*undefined*/ in_filename, const CString& in_name, const CRef& /*object*/ in_source );
	EXPORTSTUBS CValue SIAddImageSourceOp( const CValue& /*undefined*/ in_clip, const CValue& /*undefined*/ in_source );
	EXPORTSTUBS void SIAddModelClip( const CValue& /*undefined*/ in_source, const CString& in_name, const CRef& /*object*/ in_clip );
	EXPORTSTUBS void SIAddModelSource( const CString& in_filename, const CString& in_name, const CRef& /*object*/ in_source, const CValue& /*number*/ in_resolution );
	EXPORTSTUBS void SIAddParameterEntryToOverride( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_value, const CString& in_path );
	EXPORTSTUBS void SIAddParticleEvent( const CString& in_target, const CString& in_source, const CRef& /*object*/ in_output );
	EXPORTSTUBS void SIAddParticleForce( const CString& in_target, const CString& in_inputobj );
	EXPORTSTUBS void SIAddParticleGoal( const CString& in_target, const CString& in_inputobj, const CRef& /*object*/ in_output );
	EXPORTSTUBS void SIAddPointOnCurve( const CValue& /*undefined*/ in_inputobj, const CValue& /*number*/ in_insertposition, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y, const CValue& /*number*/ in_z, bool in_local, const CValue& /*number*/ in_curvetype );
	EXPORTSTUBS void SIAddPointOnCurveAtEnd( const CValue& /*undefined*/ in_inputobj, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y, const CValue& /*number*/ in_z, bool in_local, const CValue& /*number*/ in_curvetype );
	EXPORTSTUBS void SIAddPointOnCurveAtStart( const CValue& /*undefined*/ in_inputobj, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y, const CValue& /*number*/ in_z, bool in_local, const CValue& /*number*/ in_curvetype );
	EXPORTSTUBS void SIAddProp( const CValue& /*undefined*/ in_presetobj, const CValue& /*undefined*/ in_inputobjs, siPropagationType in_propagationtype, const CString& in_propertyname, const CRef& /*object*/ in_value );
	EXPORTSTUBS void SIAddPropEx( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_property, siPropagationType in_propagationtype );
	EXPORTSTUBS void SIAddShaderEntryToOverride( const CValue& /*undefined*/ in_presetobj, const CValue& /*undefined*/ in_inputobj, const CString& in_path, const CString& in_name );
	EXPORTSTUBS void SIAddToCluster( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_subcomp, const CRef& /*object*/ in_outputobj );
	EXPORTSTUBS void SIAddToGroup( const CValue& /*undefined*/ in_target, const CValue& /*undefined*/ in_inputobjs, const CRef& /*object*/ in_outputobj );
	EXPORTSTUBS void SIAddToGroupLowLevel( const CRef& /*object*/ in_target, const CRef& /*object*/ in_inputobjs, const CRef& /*object*/ in_outputobj );
	EXPORTSTUBS CValue SIAppendBone( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_ex, const CValue& /*number*/ in_ey, const CValue& /*number*/ in_ez, bool in_pin, bool in_alignroottofirstbone );
	EXPORTSTUBS CValue SIApplyCns( const CValue& /*undefined*/ in_presetobj, const CValue& /*undefined*/ in_constrainedobj, const CValue& /*undefined*/ in_constrainingobj, bool in_compensation );
	EXPORTSTUBS CValue SIApplyConstraint( const CValue& /*undefined*/ in_presetobj, const CValue& /*undefined*/ in_constrainedobj, const CValue& /*undefined*/ in_constrainingobj, bool in_compensation, const CValue& /*undefined*/ in_offset1x, const CValue& /*undefined*/ in_offset1y, const CValue& /*undefined*/ in_offset1z, const CValue& /*undefined*/ in_offset2x, const CValue& /*undefined*/ in_offset2y, const CValue& /*undefined*/ in_offset2z );
	EXPORTSTUBS CValue SIApplyDeformByCage( const CValue& /*undefined*/ in_connectionset, bool in_interactive, const CValue& /*undefined*/ in_constructionmode );
	EXPORTSTUBS CValue SIApplyDeformBySpine( const CValue& /*undefined*/ in_connectionset, bool in_interactive, const CValue& /*undefined*/ in_constructionmode );
	EXPORTSTUBS CValue SIApplyFlexEnv( const CValue& /*undefined*/ in_connectionset, bool in_interactive, bool in_assignnewdeformers, const CValue& /*undefined*/ in_constructionmode );
	EXPORTSTUBS void SIApplyFlexEnvWithWeight( const CValue& /*undefined*/ in_connectionset, bool in_interactive, const CValue& /*undefined*/ in_envelopeweights, const CValue& /*undefined*/ in_constructionmode );
	EXPORTSTUBS CValue SIApplyShader( const CValue& /*undefined*/ in_presetobj, const CValue& /*undefined*/ in_inputobjs, const CString& in_name, const CValue& /*number*/ in_propagationtype );
	EXPORTSTUBS CValue SIApplyShaderToCnxPoint( const CValue& /*undefined*/ in_presetobj, const CValue& /*undefined*/ in_inputobjs, const CString& in_name, bool in_value );
	EXPORTSTUBS void SIAssembleNurbsMesh( const CValue& /*undefined*/ in_inputobj, const CValue& /*number*/ in_tolerance, bool in_copyusercluster, bool in_copymaterial, bool in_centergeomcenter, const CRef& /*object*/ in_outputobj );
	EXPORTSTUBS void SIAssignMaterial( const CValue& /*undefined*/ in_objects, const CValue& /*undefined*/ in_material );
	EXPORTSTUBS CValue SIBasicTransferClusterPropertiesAcrossGenOp( const CValue& /*undefined*/ in_operator, const CValue& /*undefined*/ in_cluster, const CValue& /*undefined*/ in_clusterpropstotransfer, const CString& in_clusterpropertyname );
	EXPORTSTUBS CValue SIBasicTransferClustersAcrossGenOp( const CValue& /*undefined*/ in_operator, const CValue& /*undefined*/ in_object, const CValue& /*undefined*/ in_clusterstotransfer, const CString& in_clustername );
	EXPORTSTUBS void SICameraTextureProj( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_propertyname, const CValue& /*undefined*/ in_primobjtexture, const CRef& /*object*/ in_3dobjcamera );
	EXPORTSTUBS CValue SIConnectShaderToCnxPoint( const CValue& /*undefined*/ in_source, const CValue& /*undefined*/ in_inputobjs, bool in_deleteonlastdisconnection );
	EXPORTSTUBS void SIConnectShaderWithBlendsInsp( const CString& in_presetobj, const CString& in_mixer, const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void SIConnectToProjection( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_propertyname, const CValue& /*undefined*/ in_textureprojection );
	EXPORTSTUBS void SIConnectToSupport( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_propertyname, const CValue& /*undefined*/ in_primobjtexture, const CRef& /*object*/ in_3dobjtexture );
	EXPORTSTUBS void SIConvert( const CValue& /*undefined*/ in_target, const CValue& /*undefined*/ in_source, const CRef& /*object*/ in_createdobj, const CRef& /*object*/ in_outputobj );
	EXPORTSTUBS void SICreateCluster( const CString& in_type, const CString& in_name, const CValue& /*undefined*/ in_3dobject, const CValue& /*number*/ in_mode, const CRef& /*object*/ in_value );
	EXPORTSTUBS CValue SICreateCurve( const CString& in_name, const CValue& /*number*/ in_degree, const CValue& /*number*/ in_curvetype );
	EXPORTSTUBS void SICreateEmptyPartition( const CValue& /*undefined*/ in_target, const CString& in_name, siPartitionType in_type, const CRef& /*object*/ in_value );
	EXPORTSTUBS CValue SICreateGroup( const CString& in_name, const CValue& /*undefined*/ in_parent );
	EXPORTSTUBS void SICreateImageClip( const CValue& /*undefined*/ in_filename, const CString& in_name, const CRef& /*object*/ in_clip );
	EXPORTSTUBS CValue SICreateImageClip2( const CValue& /*undefined*/ in_filename, const CString& in_name, const CRef& /*object*/ in_clip );
	EXPORTSTUBS void SICreateLayer( const CString& in_presetobj, const CString& in_name, const CRef& /*object*/ in_value );
	EXPORTSTUBS CValue SICreateMaterial( const CValue& /*undefined*/ in_presetobj, const CString& in_name, const CValue& /*undefined*/ in_library, const CValue& /*undefined*/ in_objects, bool in_assigntolist, bool in_initialize );
	EXPORTSTUBS CValue SICreateMaterialDD( const CValue& /*undefined*/ in_presetobj, const CString& in_name, const CValue& /*undefined*/ in_library, const CValue& /*undefined*/ in_objects, bool in_assigntolist, bool in_initialize );
	EXPORTSTUBS void SICreateModel( const CValue& /*undefined*/ in_inputobj, const CString& in_name, const CValue& /*undefined*/ in_parent, const CRef& /*object*/ in_value );
	EXPORTSTUBS void SICreateModelClip( const CValue& /*undefined*/ in_filename, const CString& in_name, const CRef& /*object*/ in_clip );
	EXPORTSTUBS void SICreatePartition( const CString& in_target, const CString& in_name, const CString& in_inputobjs, const CRef& /*object*/ in_value );
	EXPORTSTUBS void SICreatePass( const CString& in_presetobj, const CString& in_name, const CRef& /*object*/ in_value );
	EXPORTSTUBS CValue SICreateRefPlane( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue SICreateSkeleton( const CValue& /*number*/ in_rx, const CValue& /*number*/ in_ry, const CValue& /*number*/ in_rz, const CValue& /*number*/ in_ex, const CValue& /*number*/ in_ey, const CValue& /*number*/ in_ez, const CValue& /*number*/ in_nx, const CValue& /*number*/ in_ny, const CValue& /*number*/ in_nz, const CValue& /*number*/ in_viewtype, const CRef& /*object*/ in_bone, const CRef& /*object*/ in_effector, const CValue& /*number*/ in_skeletontype, bool in_alignroottofirstbone );
	EXPORTSTUBS void SICreateTextureBasicGeo( const CString& in_presetobj, const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_supportname, const CValue& /*undefined*/ in_propertyname, const CValue& /*undefined*/ in_parent, siTxtProjType in_projectiontype, siTxtProjPlane in_projectionplane, bool in_visibility, const CValue& /*undefined*/ in_textureprojection, const CRef& /*object*/ in_3dobjtexture, const CRef& /*object*/ in_properties, siTxtProjFitMethod in_fitting );
	EXPORTSTUBS void SICreateTextureProj( const CString& in_presetobj, const CValue& /*undefined*/ in_inputobj, const CString& in_name, const CValue& /*undefined*/ in_parent, const CRef& /*object*/ in_3dobjtexture, const CRef& /*object*/ in_primobjtexture, const CString& in_propertyname );
	EXPORTSTUBS void SICreateTexturePureImplicit( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_propertyname );
	EXPORTSTUBS void SICreateTextureSpatial( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_propertyname, const CRef& /*object*/ in_createdobj );
	EXPORTSTUBS void SICreateTextureUVDomain( const CValue& /*undefined*/ in_presetobj, const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_supportname, const CValue& /*undefined*/ in_propertyname, bool in_visibility, const CRef& /*object*/ in_outputobjs, const CRef& /*object*/ in_properties );
	EXPORTSTUBS void SIDeletePointOnCurve( const CValue& /*undefined*/ in_inputobj, const CValue& /*number*/ in_insertposition );
	EXPORTSTUBS CValue SIDuplicate( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_nbitems, siBranchFlag in_propagationtype, const CString& in_history, const CString& in_hierarchy, const CString& in_grouping, const CString& in_properties, const CString& in_animation, const CString& in_constraints, const CString& in_texturesupports );
	EXPORTSTUBS void SIExportDotXSIFile( const CValue& /*undefined*/ in_model, const CValue& /*undefined*/ in_filename );
	EXPORTSTUBS void SIExportIges( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_filename );
	EXPORTSTUBS CValue SIFilter( const CValue& /*undefined*/ in_inputobjs, const CString& in_type, bool in_include, siFilterMode in_mode );
	EXPORTSTUBS void SIFindUniqueTextureName( const CValue& /*undefined*/ in_inputobj, const CString& in_propertyname );
	EXPORTSTUBS CValue SIGetHelpPath( void );
	EXPORTSTUBS CValue SIGetMaterialShader( const CValue& /*undefined*/ in_inputobjs, siMaterialPorts in_port );
	EXPORTSTUBS CValue SIGetModel( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue SIGetPreset( const CString& in_path, const CString& in_family );
	EXPORTSTUBS void SIGetPrim( const CValue& /*undefined*/ in_presetobj, const CString& in_name, const CValue& /*undefined*/ in_parent, bool in_addtoscene, const CRef& /*object*/ in_value, const CRef& /*object*/ in_primitive );
	EXPORTSTUBS void SIGetPrimCamera( const CValue& /*undefined*/ in_presetobj, const CString& in_name, const CString& in_interestname, const CValue& /*undefined*/ in_parent, const CRef& /*object*/ in_3dobjcamera, const CRef& /*object*/ in_3dobjcamerainterest, const CRef& /*object*/ in_primobjcamera, const CRef& /*object*/ in_primobjcamerainterest );
	EXPORTSTUBS CValue SIGetPrimLattice( const CValue& /*undefined*/ in_presetobj, const CValue& /*undefined*/ in_inputobjs, const CString& in_name, const CValue& /*undefined*/ in_parent, const CRef& /*object*/ in_primobj );
	EXPORTSTUBS void SIGetPrimLight( const CValue& /*undefined*/ in_presetobj, const CString& in_name, const CString& in_parent, const CRef& /*object*/ in_3dobject, const CRef& /*object*/ in_3dobjspotinterest, const CRef& /*object*/ in_primobj, const CRef& /*object*/ in_primobjspotinterest );
	EXPORTSTUBS void SIGetPrimSpotLight( const CValue& /*undefined*/ in_presetobj, const CString& in_name, const CString& in_interestname, const CString& in_parent, const CRef& /*object*/ in_3dobjspot, const CRef& /*object*/ in_3dobjspotinterest, const CRef& /*object*/ in_primobjspot, const CRef& /*object*/ in_primobjspotinterest );
	EXPORTSTUBS CValue SIGetPrimVolumeDeform( const CValue& /*undefined*/ in_presetobj, const CValue& /*undefined*/ in_inputobjs, const CString& in_name, const CValue& /*undefined*/ in_parent, const CRef& /*object*/ in_primobj );
	EXPORTSTUBS void SIGetRigidCns( const CValue& /*undefined*/ in_presetobj, const CString& in_filename, const CString& in_name, const CValue& /*undefined*/ in_parent, bool in_addtoscene, const CRef& /*object*/ in_value, const CRef& /*object*/ in_primitive );
	EXPORTSTUBS CValue SIGetShaderOnCnxPoint( const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS CValue SIGetTextureUVDomains( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void SIHideObjects( const CValue& /*undefined*/ in_target, const CString& in_propertyname );
	EXPORTSTUBS void SIImportDotXSIFile( const CValue& /*undefined*/ in_filename, const CValue& /*undefined*/ in_parent );
	EXPORTSTUBS void SIImportIges( const CValue& /*undefined*/ in_filename, const CValue& /*undefined*/ in_parent, const CRef& /*object*/ in_value );
	EXPORTSTUBS void SIImportMatLib( const CValue& /*undefined*/ in_filename, const CValue& /*number*/ in_shareoptions, const CRef& /*object*/ in_value );
	EXPORTSTUBS void SIImportModel( const CValue& /*undefined*/ in_filename, const CValue& /*undefined*/ in_parent, const CRef& /*object*/ in_value, const CString& in_name, const CValue& /*number*/ in_shareoptions );
	EXPORTSTUBS void SIInspectUserData( const CValue& /*undefined*/ in_userdatamap, const CValue& /*undefined*/ in_subcomp );
	EXPORTSTUBS CValue SIInstantiate( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_nbitems, const CString& in_name );
	EXPORTSTUBS void SILoadPreset( const CString& in_filename, const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS void SILocalAssignFlexEnv( const CValue& /*undefined*/ in_subcomp, const CValue& /*undefined*/ in_connectionset, bool in_interactive, const CValue& /*number*/ in_nbdeformersperpoint );
	EXPORTSTUBS CValue SIMakeLocal( const CValue& /*undefined*/ in_inputobjs, siPropagationType in_propagationtype );
	EXPORTSTUBS void SIMatchSubComponent( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_subcomp, bool in_result );
	EXPORTSTUBS void SIMergeScene( const CValue& /*undefined*/ in_filename, const CString& in_name, const CValue& /*undefined*/ in_parent, const CValue& /*number*/ in_shareoptions, const CRef& /*object*/ in_createdobj );
	EXPORTSTUBS CValue SIModifyFlexEnvWght( const CValue& /*undefined*/ in_propobj, const CString& in_name, const CValue& /*undefined*/ in_subcomp, const CValue& /*number*/ in_mode, const CValue& /*number*/ in_value, bool in_normalize );
	EXPORTSTUBS void SIObjExport( const CRef& /*object*/ in_object, const CString& in_filename, const CValue& /*number*/ in_coordinatesystem, bool in_tesselation, bool in_material, bool in_uv, bool in_usernormal );
	EXPORTSTUBS void SIRebindByNameUserData( const CValue& /*undefined*/ in_material, const CRef& /*object*/ in_source_user_data_collection, const CRef& /*object*/ in_target_user_data_collection );
	EXPORTSTUBS void SIRemoveArrayElement( const CValue& /*undefined*/ in_object, const CValue& /*number*/ in_index );
	EXPORTSTUBS void SIRemoveEntryFromOverride( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void SIRemoveFromCluster( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_subcomp );
	EXPORTSTUBS void SIRemoveFromGroup( const CValue& /*undefined*/ in_target, const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void SIRenderPass( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_presetobj, const CValue& /*undefined*/ in_startframe, const CValue& /*undefined*/ in_endframe, const CValue& /*undefined*/ in_stepframe, bool in_disposerendering );
	EXPORTSTUBS void SISetCurvePoints( const CValue& /*undefined*/ in_inputobj, const CString& in_points, bool in_local );
	EXPORTSTUBS void SISetResolutionOfRefModels( const CValue& /*undefined*/ in_target, const CValue& /*number*/ in_resolution );
	EXPORTSTUBS CValue SISmoothEnvWght( const CValue& /*undefined*/ in_propobj, const CValue& /*undefined*/ in_subcomp );
	EXPORTSTUBS CValue SIStoreAction( const CValue& /*undefined*/ in_model, const CValue& /*undefined*/ in_inputobj, const CValue& /*number*/ in_mode, const CString& in_name, bool in_removeanim, bool in_consider_time, const CValue& /*number*/ in_startframe, const CValue& /*number*/ in_endframe, bool in_ripple );
	EXPORTSTUBS CValue SIStoreEnvironmentCacheToMixer( const CValue& /*undefined*/ in_environmentcache, const CString& in_name, bool in_addclip );
	EXPORTSTUBS void SIStoreProp( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS void SISwapArrayElements( const CValue& /*undefined*/ in_object, const CValue& /*number*/ in_indexa, const CValue& /*number*/ in_indexb );
	EXPORTSTUBS CValue SISymEnvWeight( const CValue& /*undefined*/ in_propobj, const CValue& /*undefined*/ in_subcomp, const CValue& /*undefined*/ in_mappingtemplate );
	EXPORTSTUBS void SITogglePolygonVisibility( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void SITransferCenter( const CValue& /*undefined*/ in_inputobj, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y, const CValue& /*number*/ in_z );
	EXPORTSTUBS void siTrimWith( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_trimwithcrvindexarray, bool in_trimwithglobaltolocalbool );
	EXPORTSTUBS void SIUIRenderInspectedPasses( void );
	EXPORTSTUBS void SIUnAssignMaterial( const CValue& /*undefined*/ in_objects );
	EXPORTSTUBS void SIUnhideObjects( const CValue& /*undefined*/ in_target, const CString& in_propertyname );
	EXPORTSTUBS void SketchCurveTool( const CString& in_clsid );
	EXPORTSTUBS CValue SMDExport( void );
	EXPORTSTUBS CValue SMDImport( const CValue& /*number*/ in_arg0 );
	EXPORTSTUBS void SnapOffsetToPointForSlicePolygons( const CValue& /*undefined*/ in_operator, const CValue& /*undefined*/ in_target );
	EXPORTSTUBS CValue SplitEdge( const CValue& /*undefined*/ in_connectionset, const CValue& /*number*/ in_ratio, bool in_edgeparallelloop, bool in_edgeconnect, siOperationMode in_immediatemode, const CValue& /*number*/ in_newpointid );
	EXPORTSTUBS void SplitEdgeTool( const CString& in_clsid );
	EXPORTSTUBS CValue SplitPolygon( const CString& in_connectionset, const CValue& /*number*/ in_tanx, const CValue& /*number*/ in_tany, const CValue& /*number*/ in_tanz, siSplitPolygonType in_splitpolygontype, siOperationMode in_immediatemode, const CValue& /*number*/ in_newpointid );
	EXPORTSTUBS void StartChannelCapture( void );
	EXPORTSTUBS void StartFxTracking( void );
	EXPORTSTUBS void StepFxTracking( void );
	EXPORTSTUBS void StopChannelCapture( void );
	EXPORTSTUBS CValue StoreAction( const CString& in_model, const CString& in_inputobj, const CValue& /*number*/ in_mode, const CString& in_name, bool in_removeanim, const CValue& /*number*/ in_startframe, const CValue& /*number*/ in_endframe, bool in_consider_time, bool in_ripple, bool in_addclip, const CValue& /*number*/ in_clipoffset );
	EXPORTSTUBS CValue StoreEnvironmentCachesToMixer( const CValue& /*undefined*/ in_environment, const CString& in_name, bool in_addclip );
	EXPORTSTUBS CValue StoreEnvironmentCacheToMixer( const CValue& /*undefined*/ in_environmentcache, const CString& in_name, bool in_addclip );
	EXPORTSTUBS void StoreGeomApproxProperties( const CValue& /*undefined*/ in_inputobjs, const CString& in_name );
	EXPORTSTUBS void StoreMaterialProperties( const CValue& /*undefined*/ in_inputobjs, const CString& in_name );
	EXPORTSTUBS CValue StoreShapeKey( const CValue& /*undefined*/ in_inputobj, const CValue& /*undefined*/ in_name, siShapeReferenceMode in_refmode, const CValue& /*undefined*/ in_frame, const CValue& /*number*/ in_duration, const CValue& /*number*/ in_sampling, siShapeContent in_content );
	EXPORTSTUBS void StoreVisibilityProperties( const CValue& /*undefined*/ in_inputobjs, const CString& in_name );
	EXPORTSTUBS void SubstituteOpInput( const CValue& /*undefined*/ in_reference, const CValue& /*undefined*/ in_new );
	EXPORTSTUBS void SwapOperators( const CValue& /*undefined*/ in_object, const CValue& /*undefined*/ in_operator1, const CValue& /*undefined*/ in_operator2 );
	EXPORTSTUBS void SwapPaintColors( void );
	EXPORTSTUBS void SwapRelationMasterAndSlaveClip( const CValue& /*undefined*/ in_relation );
	EXPORTSTUBS void SwitchToolbar( const CValue& /*number*/ in_target );
	EXPORTSTUBS void SwitchToView( const CString& in_viewname );
	EXPORTSTUBS void SyClearCache( void );
	EXPORTSTUBS void SyClearState( void );
	EXPORTSTUBS void SyClearVelocityState( void );
	EXPORTSTUBS void SyCollideGetMesh( void );
	EXPORTSTUBS void SyCreateAir( void );
	EXPORTSTUBS void SyCreateCloth( void );
	EXPORTSTUBS void SyCreateCollideMesh( void );
	EXPORTSTUBS void SyCreateDamp( void );
	EXPORTSTUBS void SyCreateGravity( void );
	EXPORTSTUBS void SyCreateNail( void );
	EXPORTSTUBS void SyCreatePin( void );
	EXPORTSTUBS void SyCreateSelfCollide( void );
	EXPORTSTUBS void SyCreateSpring( void );
	EXPORTSTUBS void SyCreateWind( void );
	EXPORTSTUBS void SyGetCollidePnts( void );
	EXPORTSTUBS void SyGetCollidePols( void );
	EXPORTSTUBS void SyGetMassMap( void );
	EXPORTSTUBS void SyGetNail( void );
	EXPORTSTUBS void SyGetPin( void );
	EXPORTSTUBS void SyGetSelfCollidePols( void );
	EXPORTSTUBS void SyGetSpringMap( void );
	EXPORTSTUBS CValue SymEnvWeight( const CValue& /*undefined*/ in_propobj, const CValue& /*undefined*/ in_subcomp, const CValue& /*undefined*/ in_mappingtemplate, const CValue& /*number*/ in_symmetryaxis );
	EXPORTSTUBS void SyPinGetMesh( void );
	EXPORTSTUBS void SySetCollidePnts( void );
	EXPORTSTUBS void SySetCollidePols( void );
	EXPORTSTUBS void SySetMassMap( void );
	EXPORTSTUBS void SySetNail( void );
	EXPORTSTUBS void SySetPin( void );
	EXPORTSTUBS void SySetSelfCollidePols( void );
	EXPORTSTUBS void SySetSpringMap( void );
	EXPORTSTUBS void SySetState( void );
	EXPORTSTUBS CValue System( const CString& in_pathname, const CValue& /*number*/ in_value );
	EXPORTSTUBS void Tag( const CValue& /*undefined*/ in_inputobjs, siTags in_level );
	EXPORTSTUBS void TagForDelete( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS CValue TagObject( const CValue& /*undefined*/ in_inputobj, const CString& in_tagstr );
	EXPORTSTUBS CValue TagStepMarks( const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS void TerminateAddEdgeWithInteriorPoints( const CValue& /*undefined*/ in_operator, const CValue& /*number*/ in_polygonid, const CValue& /*number*/ in_edgeid, const CValue& /*number*/ in_ratio );
	EXPORTSTUBS void TestPluginHost( bool in_destroy );
	EXPORTSTUBS void TestRenTasks( const CValue& /*number*/ in_inputobj );
	EXPORTSTUBS void ToggleActiveElements( const CValue& /*undefined*/ in_selectionlist );
	EXPORTSTUBS void ToggleAlphaCompose( void );
	EXPORTSTUBS void ToggleAlphaOnly( void );
	EXPORTSTUBS void ToggleAreaLights( void );
	EXPORTSTUBS CValue ToggleBooleanUserPref( const CString& in_userpref );
	EXPORTSTUBS CValue ToggleBooleanUserPrefProc( const CString& in_userpref );
	EXPORTSTUBS void ToggleContinuousDraw( const CString& in_paramname, const CString& in_inputobjs );
	EXPORTSTUBS void ToggleCurrentLayerProperty( const CString& in_propname );
	EXPORTSTUBS void ToggleFreezeRefresh( void );
	EXPORTSTUBS void ToggleGhosting( const CValue& /*undefined*/ in_target );
	EXPORTSTUBS void ToggleMuteSolo( const CValue& /*number*/ in_target, const CValue& /*number*/ in_mode );
	EXPORTSTUBS void TogglePaintShapePointSelection( const CValue& /*undefined*/ in_shape, const CValue& /*undefined*/ in_indices );
	EXPORTSTUBS void ToggleParameterValue( const CValue& /*undefined*/ in_inputobjects, const CString& in_parameters );
	EXPORTSTUBS void TogglePinObjectInPosition( const CValue& /*undefined*/ in_constrainedobj );
	EXPORTSTUBS void ToggleProjectionTool( const CString& in_clsid );
	EXPORTSTUBS void TogglePropVolume( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void ToggleRegionVisibility( const CValue& /*number*/ in_value );
	EXPORTSTUBS void ToggleSelectability( const CValue& /*undefined*/ in_inputobjects, const CString& in_parameter );
	EXPORTSTUBS void ToggleSelection( const CValue& /*undefined*/ in_selectionlist, const CString& in_hierarchylevel, bool in_checkobjectselectability );
	EXPORTSTUBS void ToggleSelectionTracking( void );
	EXPORTSTUBS void ToggleSnap0D( const CString& in_property );
	EXPORTSTUBS void ToggleSnap1D( const CString& in_property );
	EXPORTSTUBS void ToggleSnap2D( const CString& in_property );
	EXPORTSTUBS void ToggleSnapAllObjects( const CString& in_property );
	EXPORTSTUBS void ToggleSnapBoundaries( const CString& in_property );
	EXPORTSTUBS void ToggleSnapCenters( const CString& in_property );
	EXPORTSTUBS void ToggleSnapCurveObjects( const CString& in_property );
	EXPORTSTUBS void ToggleSnapCurves( const CString& in_property );
	EXPORTSTUBS void ToggleSnapEdges( const CString& in_property );
	EXPORTSTUBS void ToggleSnapFaces( const CString& in_property );
	EXPORTSTUBS void ToggleSnapGrid( const CString& in_property );
	EXPORTSTUBS void ToggleSnapHairObjects( const CString& in_property );
	EXPORTSTUBS void ToggleSnapIntersections( const CString& in_property );
	EXPORTSTUBS void ToggleSnapKnots( const CString& in_property );
	EXPORTSTUBS void ToggleSnapLatticeObjects( const CString& in_property );
	EXPORTSTUBS void ToggleSnapMeshObjects( const CString& in_property );
	EXPORTSTUBS void ToggleSnapMidpoints( const CString& in_property );
	EXPORTSTUBS void ToggleSnapNullObjects( const CString& in_property );
	EXPORTSTUBS void ToggleSnapParticleObjects( const CString& in_property );
	EXPORTSTUBS void ToggleSnapPoints( const CString& in_property );
	EXPORTSTUBS void ToggleSnapSurfaceObjects( const CString& in_property );
	EXPORTSTUBS void ToggleSnapSurfaces( const CString& in_property );
	EXPORTSTUBS void ToggleSnapUknotcurves( const CString& in_property );
	EXPORTSTUBS void ToggleSnapVknotcurves( const CString& in_property );
	EXPORTSTUBS void ToggleValue( const CString& in_paramname, const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void ToggleVisibility( const CValue& /*undefined*/ in_target, const CString& in_propertyname, bool in_threestate );
	EXPORTSTUBS void ToggleVisibilityOfTextureUVDomains( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_type );
	EXPORTSTUBS CValue TransferAllPropertiesAcrossGenOp( const CValue& /*undefined*/ in_operator, const CValue& /*undefined*/ in_object, const CString& in_propertytransfertype, bool in_shareproperty );
	EXPORTSTUBS CValue TransferClusterPropertiesAcrossGenOp( const CValue& /*undefined*/ in_operator, const CValue& /*undefined*/ in_object, const CValue& /*undefined*/ in_clusterpropstotransfer, const CString& in_clusterpropertyname, bool in_rebindclusterproperties );
	EXPORTSTUBS CValue TransferPropertiesAcrossGenOp( const CValue& /*undefined*/ in_operator, const CValue& /*undefined*/ in_object, const CValue& /*undefined*/ in_propertiestotransfer, const CString& in_propertyname, bool in_shareproperty, bool in_transferclusterproperties );
	EXPORTSTUBS void Translate( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y, const CValue& /*number*/ in_z, siDeltaMode in_delta, siRefMode in_refmode, siCenterMode in_center, siAxesFilter in_axesfilter, bool in_snap, const CString& in_snapreference, siAxesFilter in_snapfilter, bool in_splitlocalcomponents, bool in_proptagonly, bool in_pivot, const CValue& /*number*/ in_pivotx, const CValue& /*number*/ in_pivoty, const CValue& /*number*/ in_pivotz, const CValue& /*undefined*/ in_constructionmode );
	EXPORTSTUBS void TranslatePaintShapePoint( const CValue& /*undefined*/ in_shape, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y, siDeltaMode in_delta );
	EXPORTSTUBS void TranslateTool( const CString& in_clsid );
	EXPORTSTUBS void TranslateUVW( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_textureprojection, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y, const CValue& /*number*/ in_z, siDeltaMode in_delta, siUVWAxesFilter in_axesfilter, bool in_splitlocalcomponents );
	EXPORTSTUBS void TrimAfter( const CValue& /*undefined*/ in_clip, siCutClipOptions in_mode, const CValue& /*undefined*/ in_time );
	EXPORTSTUBS void TrimBefore( const CValue& /*undefined*/ in_clip, siCutClipOptions in_mode, const CValue& /*undefined*/ in_time );
	EXPORTSTUBS void TrimWith( const CValue& /*undefined*/ in_inputobjs, const CValue& /*undefined*/ in_trimwithsrfcrv );
	EXPORTSTUBS void UIApplyShaderToCnxPoints( const CRef& /*object*/ in_inputobj, const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_x, const CValue& /*number*/ in_y );
	EXPORTSTUBS void UIAssembleNurbsMesh( void );
	EXPORTSTUBS void UIMapButton( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void UnAssignMaterial( const CValue& /*undefined*/ in_inputobjs );
	EXPORTSTUBS void Undo( void );
	EXPORTSTUBS void UnghostAll( void );
	EXPORTSTUBS void UnhideAll( const CString& in_propertyname );
	EXPORTSTUBS void UnhideAllPolygonClusters( void );
	EXPORTSTUBS void UnhideAllPolygons( void );
	EXPORTSTUBS void UnhideTextureUVDomains( const CValue& /*undefined*/ in_inputobjs, const CValue& /*number*/ in_type );
	EXPORTSTUBS void UnInstallAddon( const CString& in_filename );
	EXPORTSTUBS void UnloadAddonLib( const CValue& /*undefined*/ in_filename );
	EXPORTSTUBS void UnloadAllAddonLibs( void );
	EXPORTSTUBS void UnloadAllCOMLibs( void );
	EXPORTSTUBS void Unlock( const CValue& /*undefined*/ in_inputobjs, siLockLevel in_level, const CString& in_password, bool in_removeall );
	EXPORTSTUBS void Untag( const CValue& /*undefined*/ in_inputobjs, siTags in_level );
	EXPORTSTUBS void UpdateConnectOnOp( const CValue& /*undefined*/ in_operator, const CValue& /*number*/ in_groupindex, const CValue& /*number*/ in_groupinstanceindex, const CValue& /*undefined*/ in_inputobjs, bool in_alreadyrefined, bool in_forcedisconnect );
	EXPORTSTUBS void UpdateParticleTypeConnections( const CValue& /*undefined*/ in_inputobj );
	EXPORTSTUBS void UpdateReferencedModel( const CValue& /*undefined*/ in_clip );
	EXPORTSTUBS CValue UpgradeShaders( void );
	EXPORTSTUBS CValue ValveCopyShapeKey( void );
	EXPORTSTUBS CValue ValveFixBrokenFootRoll( void );
	EXPORTSTUBS CValue ValveRemoveCenterOp( void );
	EXPORTSTUBS CValue ValveSetCopyShapeCluster( void );
	EXPORTSTUBS void VirtualSliderTool( const CString& in_clsid );
	EXPORTSTUBS CValue VMFExport( const CValue& /*number*/ in_arg0 );
	EXPORTSTUBS CValue VMFImport( void );
	EXPORTSTUBS CValue WeightExport( const CValue& /*number*/ in_arg0 );
	EXPORTSTUBS CValue WeightImport( const CValue& /*number*/ in_arg0 );
	EXPORTSTUBS CValue WeldPoints( const CValue& /*undefined*/ in_connectionset, siOperationMode in_immediatemode );
};
};
#endif //_CMDSTUBS_H_