#include <CrytekRTS.h>
#include <xsi_application.h>
#include <xsi_property.h>
#include <xsi_model.h>

XSI_RTS_Attribute __gExplicitAttributes [] = 
{
   XSI_RTS_ATTRIBUTE_POSITION, ePOSITION,
   XSI_RTS_ATTRIBUTE_COLOR, eCOLOR0,
   0, eMAX_STANDARD_VERTEX_ATTRIBUTE,
};

#ifdef _WIN32
#ifndef XSI_STATIC_LINK
#ifdef unix
extern "C"
#endif
BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
			break;
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
			break;
		case DLL_PROCESS_DETACH:
			break;
    }
    return TRUE;
}
#endif
#endif //_WIN32

ShaderParamDefinition	CrytekVertexColor_Params[1] = 
{
	"channel", XSI_RTS_SCALAR
};

RTSHADER_API ULONG RTS_GetVersion()
{
	return XSI_RTSHADER_VERSION;	
}

#define NB_SHADERS 1

ShaderDefinition g_Shaders[NB_SHADERS] = 
{
	"Crytek.CrytekVertexColor.1",		"CrytekRTS.dll",		"CrytekVertexColor",		1,	CrytekVertexColor_Params,
};

extern "C" RTSHADER_API int RTS2_GetNumberOfShaders()
{
	return NB_SHADERS;
}

extern "C" RTSHADER_API ShaderDefinition *RTS2_GetShaderDefinition(int in_nIndex)
{
	return &g_Shaders[in_nIndex];
}


RTSHADER_API bool CrytekVertexColor_Init
(
	IRTSExecutionState				*in_pExecState,					//! The execute state
	void							*in_pParams,					//! The property page parameters
	void							**io_pShaderInstanceData		//! The shader instance data
)
{
	return true;
}


RTSHADER_API XSI_RTS_Attribute* CrytekVertexColor_GetAttributeList
(
 	IRTSExecutionState				*in_pExecState,					//! The execute state
	void							*in_pParams,
	void							**io_pInstanceData		
)
{
	return __gExplicitAttributes;
}


RTSHADER_API bool CrytekVertexColor_Execute		
(
	IRTSExecutionState				*in_pExecState,			//! The execute state
	void							*in_pParams,			// The property page parameters
	XSI_RTS_Primitive				*in_pPrimitive,			// The geometry information
	void							*in_pAttributes,		// The attribute data
	XSI_RTS_Attribute_Size			*in_pAttributesSize,	// the sizes
	void							**io_pInstanceData		// The shader instance data
)
{
	::glDisable(GL_LIGHTING);

	ExplicitAttributesData* in_pAttributesData = (ExplicitAttributesData*)in_pAttributes;

	if ( in_pPrimitive->m_Type == RTS_PT_TRIANGLE_MESH 
		&& in_pAttributesData->m_pColors 
		&& (in_pAttributesSize[0].m_eSize == XSI_RTS_FLOAT_3) 
		&& (in_pAttributesSize[1].m_eSize == XSI_RTS_FLOAT_4) )
	{
		CrytekVertexColorAttributes* ppg = (CrytekVertexColorAttributes*)in_pParams;

		int l_Channel = 0;

		//From CrytekDisplayOptions
		if (ppg->Channel == -1)
		{
			XSI::Application app;
			XSI::Property prop = app.GetActiveSceneRoot().GetProperties().GetItem( L"CrytekDisplayOptions" ) ;
							
			if (!prop.IsValid())
			{
				prop = app.GetActiveSceneRoot().AddProperty( L"CrytekDisplayOptions" ) ;
			}

			l_Channel = prop.GetParameterValue(L"Channel");
		}
		else
		{
			l_Channel = ppg->Channel;
		}

		ULONG i, j;

		for (i = 0; i < in_pPrimitive->m_ulNbIndices/3;  i++)
		{
			glBegin(GL_TRIANGLES);

			for (j = 0; j < 3; j++)
			{
				UINT l_uiIndex = 0;

				switch(in_pPrimitive->m_iIndicesWidth)
				{
				case 4:
					l_uiIndex = ((UINT*)in_pPrimitive->m_pIndices)[in_pPrimitive->m_ulBaseOffset+i*3+j];
					break;

				case 2:
					l_uiIndex = ((USHORT*)in_pPrimitive->m_pIndices)[in_pPrimitive->m_ulBaseOffset+i*3+j];
					break;

				case 1:
					l_uiIndex = ((unsigned char*)in_pPrimitive->m_pIndices)[in_pPrimitive->m_ulBaseOffset+i*3+j];
					break;
				}

				// Colors
				switch(l_Channel)
				{
				case RED_CHANNEL:
					glColor4f(in_pAttributesData->m_pColors[l_uiIndex*4], 0, 0, 1);
					break;
				case GREEN_CHANNEL:
					glColor4f(0, in_pAttributesData->m_pColors[l_uiIndex*4+1], 0, 1);
					break;
				case BLUE_CHANNEL:
					glColor4f(0, 0, in_pAttributesData->m_pColors[l_uiIndex*4+2], 1);
					break;
				case ALPHA_CHANNEL:
					glColor4f(in_pAttributesData->m_pColors[l_uiIndex*4+3], in_pAttributesData->m_pColors[l_uiIndex*4+3], in_pAttributesData->m_pColors[l_uiIndex*4+3], 1);
					break;
				case ALL_CHANNEL:
					glColor4f(in_pAttributesData->m_pColors[l_uiIndex*4], in_pAttributesData->m_pColors[l_uiIndex*4+1], in_pAttributesData->m_pColors[l_uiIndex*4+2], 1);
					break;
				}

				glVertex3fv
				(
					&(in_pAttributesData->m_pPositions[l_uiIndex*3])
				);
			}

			glEnd();
		}
	}
	else
	{
		in_pExecState->DrawGeometry ( Any,
						in_pPrimitive, 
						__gExplicitAttributes,
						in_pAttributes,
						in_pAttributesSize);
	}

	::glEnable(GL_LIGHTING);

	return true;
}

RTSHADER_API bool CrytekVertexColor_GetRequirements
(
	IRTSExecutionState				*in_pExecState,					//! The execute state
	void							*in_pParams,					//! The property page parameters
	XSI_RTS_Primitive				*in_pGeom,						//! The geometry information
	void							**io_pShaderInstanceData,		//! The shader instance data
	ULONG							in_lFlag,						//! The flag to check
	ULONG							*out_pValue						//! The returned value
)
{
	(*out_pValue) = 0;
	return true;
}

RTSHADER_API bool CrytekVertexColor_Term
(
	IRTSExecutionState				*in_pExecState,					//! The execute state
	void							*in_pParams,					//! The property page parameters
	void							**io_pShaderInstanceData		//! The shader instance data
)
{
	return true;
}
