#ifndef CRYTEK_RTS_H
#define CRYTEK_RTS_H

#ifdef _WIN32
#include <windows.h>
#endif

#include <assert.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <gl/glext.h>
#include <XSI_OGLHelper.h>

#ifdef linux
#undef GL_VERSION_1_2
#undef __glext_h_
#undef GL_ARB_multitexture

#include <malloc.h>
#ifndef BYTE
#define BYTE unsigned char
#endif
#ifndef DWORD
#define DWORD ULONG
#endif
#endif

#define RED_CHANNEL		0
#define GREEN_CHANNEL	1
#define BLUE_CHANNEL	2
#define ALPHA_CHANNEL	3
#define ALL_CHANNEL		4

typedef struct 
{
	LONG						Channel;
} CrytekVertexColorAttributes;

// Attribute structure
typedef struct tagExplicitAttributesData
{
	float*	m_pPositions;
	float*	m_pColors;
} ExplicitAttributesData;

#ifdef __cplusplus

extern "C"
{
RTSHADER_API ULONG RTS_GetVersion();

RTSHADER_API bool CrytekVertexColor_Init	
(
	IRTSExecutionState				*in_pExecState,					//! The execute state
	void							*in_pParams,					//! The property page parameters
	void							**io_pShaderInstanceData		//! The shader instance data
);


RTSHADER_API bool CrytekVertexColor_Execute	
(
	IRTSExecutionState				*in_pExecState,					//! The execute state
	void							*in_pParams,					// The property page parameters
	XSI_RTS_Primitive				*in_pPrimitive,					// The geometry information
	void							*in_pAttributes,				// The attribute data
	XSI_RTS_Attribute_Size			*in_pAttributesSize,			// the sizes
	void							**io_pInstanceData				// The shader instance data
);

RTSHADER_API bool CrytekVertexColor_GetRequirements	
(
	IRTSExecutionState				*in_pExecState,					//! The execute state
	void							*in_pParams,					//! The property page parameters
	XSI_RTS_Primitive				*in_pGeom,						//! The geometry information
	void							**io_pShaderInstanceData,		//! The shader instance data
	ULONG					in_lFlag,								//! The flag to check
	ULONG					*out_pValue								//! The returned value
);

RTSHADER_API bool CrytekVertexColor_Term
(
	IRTSExecutionState				*in_pExecState,					//! The execute state
	void							*in_pParams,					//! The property page parameters
	void							**io_pShaderInstanceData		//! The shader instance data
);

RTSHADER_API XSI_RTS_Attribute* CrytekVertexColor_GetAttributeList
(
 	IRTSExecutionState				*in_pExecState,					//! The execute state
	void							*in_pParams,
	void							**io_pInstanceData		
);
}

#endif // __cplusplus

#endif // CRYTEK_RTS_H
