// XenonConsoleDlg.cpp : implementation file
//

#include "stdafx.h"

#include "XenonConsole.h"
#include "XenonConsoleDlg.h"
#include ".\xenonconsoledlg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#endif


/*
// CAboutDlg dialog used for App About
class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()
*/

// CXenonConsoleDlg dialog



CXenonConsoleDlg::CXenonConsoleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CXenonConsoleDlg::IDD, pParent)
{
	m_pdmConnection = 0;
	m_pdmnSession = 0;
	m_isVars = false;
	m_pCh = pCommands;

	m_curInList = -1;

	strcpy(pCommands,"map;quit;");

	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CXenonConsoleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMMAND, m_Command);
	DDX_Control(pDX, IDC_CONS, m_Cons);
}

BEGIN_MESSAGE_MAP(CXenonConsoleDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDCANCEL, OnBnClickedCancel)
	ON_BN_CLICKED(IDOK, OnBnClickedOk)
	ON_WM_SIZE()
	ON_WM_CREATE()
END_MESSAGE_MAP()



void CXenonConsoleDlg::OnSize(UINT nType, int cx, int cy )
{
	RECT r;
	GetClientRect(&r);

	if(IsWindow(m_Command.m_hWnd))
	{
		WINDOWPLACEMENT wp;
		m_Command.GetWindowPlacement(&wp);
		int h = wp.rcNormalPosition.bottom - wp.rcNormalPosition.top;
		wp.rcNormalPosition.right = cx-m_CommandX;
		wp.rcNormalPosition.top = cy-m_CommandY;
		wp.rcNormalPosition.bottom = wp.rcNormalPosition.top + h;
		m_Command.SetWindowPlacement(&wp);
	}

	if(IsWindow(m_Cons.m_hWnd))
	{
		WINDOWPLACEMENT wp;
		m_Cons.GetWindowPlacement(&wp);
		wp.rcNormalPosition.right = cx-m_CommandX;
		wp.rcNormalPosition.bottom = cy-m_ConsoleY;
		m_Cons.SetWindowPlacement(&wp);
	}

	CDialog::OnSize(nType, cx, cy);
}


BOOL CXenonConsoleDlg::PreTranslateMessage(MSG* pMsg)
{
	if(pMsg->message == WM_KEYDOWN && GetFocus() == &m_Command)
	{
		if(pMsg->wParam == VK_ESCAPE)
		{
			m_Command.SetWindowText("");
			return true;
		}
		if(pMsg->wParam == VK_UP)
		{
			m_curInList--;
			
			if(m_curInList<-1)
				m_curInList = (int)m_commList.size() - 1;

			if(m_curInList>=0)
			{
				const char * pCom = (m_commList[m_curInList]).c_str();

				m_Command.SetWindowText(pCom);
				m_Command.SetSel((int)strlen(pCom),-1, FALSE);
			}
			else if(m_curInList==-1)
			{
				m_Command.SetWindowText("");
			}

			return true;
		}

		if(pMsg->wParam == VK_DOWN)
		{
			m_curInList++;
			
			if(m_curInList<0)
				m_curInList = -1;

			if(m_curInList < (int)m_commList.size())
			{
				const char * pCom = (m_commList[m_curInList]).c_str();

				m_Command.SetWindowText(pCom);
				m_Command.SetSel((int)strlen(pCom),-1, FALSE);
			}
			else
			{
				m_curInList = -1;
				m_Command.SetWindowText("");
			}
			return true;
		}

		if(pMsg->wParam == VK_TAB)
		{
			if(!m_isVars)
				InitVars();
			CString str;
			m_Command.GetWindowText(str);

			if(!str.GetLength())
				return false;
			
			if(!m_FindBegin.GetLength())
				m_FindBegin = str;

			char pCom[64];
			char * pC = pCom;

			for(int i= 0; i<2; i++)
			{
				while(*m_pCh)
				{
					if(*m_pCh==';')
					{
						*pC++ = ' ';
						*pC = 0;
						if(!strnicmp (pCom, m_FindBegin, m_FindBegin.GetLength()))
						{
							m_Command.SetWindowText(pCom);
							m_Command.SetSel(strlen(pCom),-1, FALSE);
							m_pCh ++;
							return true;
						}
						pC = pCom;
					}
					else
						*pC++ = *m_pCh;
					
					m_pCh++;
				}
				m_pCh = pCommands;
			}
			return true;
		}
	}
	
	if(pMsg->message == WM_KEYDOWN)
	{
		m_pCh = pCommands;
		m_FindBegin ="";
	}
	return CDialog::PreTranslateMessage(pMsg);
}



DWORD __stdcall ExtNotifyFunc( const CHAR* strNotification )
{
	CXenonConsoleDlg * dlg = (CXenonConsoleDlg *) AfxGetApp()->GetMainWnd();
	if(!dlg)
		return E_FAIL;

	// Skip over dumb prefix and ! mark.
	while (*strNotification && *strNotification != '!')
		strNotification++;
	if (!*strNotification)
		return S_OK;
	strNotification++;

	dlg->Print(strNotification);
	return S_OK;
}


bool CXenonConsoleDlg::OpenConnection()
{
	// Open our connection
	HRESULT hr = DmOpenConnection( &m_pdmConnection );
	if( FAILED( hr ) )
	{
		//MessageBox( "DmOpenConnection", "Error", MB_OK | MB_ICONERROR );
		Print("$4Xenon Console Error: DmOpenConnection failed.");
		return false;
	}

	// Make sure we'll be able to receive notifications
	hr = DmOpenNotificationSession( 0, &m_pdmnSession);
	if( FAILED( hr ) )
	{
		MessageBox( "DmOpenNotificationSession", "Error", MB_OK | MB_ICONERROR );
		return false;
	}

	hr = DmRegisterNotificationProcessor( m_pdmnSession, "FXEN", ExtNotifyFunc );
	if( FAILED( hr ) )
	{
		MessageBox( "DmRegisterNotificationProcessor", "Error", MB_OK | MB_ICONERROR );
		return false;
	}


	// Send initial connect command to the External Command Processor so it knows we're here
	{
		DWORD dwResponseLen = MAX_PATH;
		CHAR  strResponse[MAX_PATH];

		hr = DmSendCommand( m_pdmConnection, "XCON!__connect__", strResponse, &dwResponseLen );
		if( FAILED(hr) )
		{
			//MessageBox( "Couldn't connect to the application", "Error", MB_OK | MB_ICONERROR );
			Print("$4Xenon Console Error: Couldn't connect to the application.");
			return false;
		}
		else
			Print("$3Xenon Console: Connected to the application.");
	}
	return true;
}


void CXenonConsoleDlg::CloseConnection()
{
	if(m_pdmConnection)
		DmCloseConnection( m_pdmConnection );
	m_pdmConnection = 0;

	if(m_pdmnSession)
		DmCloseNotificationSession( m_pdmnSession );
	m_pdmnSession = 0;
}


// CXenonConsoleDlg message handlers

BOOL CXenonConsoleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	/*
	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}
	/**/

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	m_Command.SetFocus();

	//char xbdmFile[MAX_PATH];
	//strcpy(xbdmFile, getenv("XEDK"));
	//strcat(xbdmFile, "\\bin\\win32\\xbdm.dll");

	RECT r;
	GetClientRect(&r);
	WINDOWPLACEMENT wp;
	m_Command.GetWindowPlacement(&wp);
	m_CommandX = (r.right - r.left) - wp.rcNormalPosition.right;
	m_CommandY = (r.bottom - r.top) - wp.rcNormalPosition.top;

	m_Cons.GetWindowPlacement(&wp);
	m_ConsoleY = (r.bottom - r.top) - wp.rcNormalPosition.bottom;

	//m_Cons.SetLimitText(UINT_MAX);

	HMODULE hXBDM = LoadLibrary("xbdm.dll");
	if (!hXBDM)
	{
		MessageBox( "Couldn't load xbdm.dll", "Error", MB_OK | MB_ICONERROR );
		return TRUE;
	}

	if(OpenConnection())
		InitVars();

	return TRUE;  // return TRUE  unless you set the focus to a control
}


void CXenonConsoleDlg::InitVars()
{
	// Get names of all variables (and commands) from game
	DWORD dwResponseLen = ALL_COMMANDS_SIZE;

	char Xcomm[1024] = "XCON!__getvars__";
	char getString[2048];

	char * ch = 0;
	while(!FAILED(DmSendCommand( m_pdmConnection, Xcomm, getString, &dwResponseLen )))
	{
		int len = (int)strlen(getString);
		if(len == 0)
			break;

		int lenCom = (int)strlen(pCommands);

		if(lenCom + len >= ALL_COMMANDS_SIZE )
			break;

		strcpy(&pCommands[lenCom], &getString[5]); // 5 - skip error code

		getString[len-1] = 0; // remove komu z krapkoy at the end
		ch = strrchr(getString, ';');
		if(!ch)
			break;

		dwResponseLen = ALL_COMMANDS_SIZE;
		sprintf(Xcomm, "XCON!__getvars__%s", ch+1);
		m_isVars = true;
	}
}


void CXenonConsoleDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	/*
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	/**/
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CXenonConsoleDlg::OnPaint() 
{
	m_Cons.SetBackgroundColor(FALSE,RGB(255,255,255));
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CXenonConsoleDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CXenonConsoleDlg::OnBnClickedCancel()
{
	CloseConnection();
	OnCancel();
}

void CXenonConsoleDlg::OnBnClickedOk()
{
	m_curInList = -1;
	CString str;
	m_Command.GetWindowText(str);

	if(!str.GetLength())
		return;

	char strRemoteCmd[1024];
	strcpy(strRemoteCmd, "XCON!");
	strcat(strRemoteCmd, str);

	// Send the command to the Xbox
	//*
	DWORD dwResponseLen = MAX_PATH;
	CHAR  strResponse[MAX_PATH];

	HRESULT hr = DmSendCommand( m_pdmConnection, strRemoteCmd, strResponse, &dwResponseLen );
	if( FAILED(hr) )
	{
		// if failed reconnect and try again
		Print("> "+str);
		CloseConnection();
		if(OpenConnection())
		{
			hr = DmSendCommand( m_pdmConnection, strRemoteCmd, strResponse, &dwResponseLen );
			if( FAILED(hr) )
				Print("$4Xenon Console Error: DmSendCommand failed.");
		}
	}
	/**/

	m_Command.SetWindowText("");

	if(m_commList.size()==0 || strcmp (m_commList[m_commList.size()-1].c_str(), str))
	{
		m_commList.push_back(std::string(str));
	}

	//Print(str);
}


void CXenonConsoleDlg::SetColor(int code)
{
	COLORREF col = RGB(0, 0, 0);
	COLORREF bgCol = RGB(255, 255, 255);

	switch(code)
	{
		case 0:
			col = RGB(0, 0, 0);
			break;
		case 2:
			col = RGB(64, 64, 255);
			break;
		case 3:
			col = RGB(0, 127, 0);
			break;
		case 4:
			col = RGB(255, 0, 0);
			break;
		case 5:
			col = RGB(0, 127, 127);
			break;
		case 6:
			col = RGB(127, 127, 0);
			//bgCol = RGB(255, 255, 127);
			break;
		case 7:
			col = RGB(127, 0, 127);
			break;
		case 8:
			col = RGB(255, 0, 0);
			break;
		case 9:
			col = RGB(255, 255, 255);
			bgCol = RGB(0, 0, 0);
			break;
	}

	CHARFORMAT2 chf;
	m_Cons.GetDefaultCharFormat(chf);
	chf.dwMask = CFM_COLOR | CFM_BACKCOLOR;
	chf.dwEffects = 0;
	chf.crTextColor = col;
	chf.crBackColor = bgCol;
	m_Cons.SetSelectionCharFormat(chf);
}


void CXenonConsoleDlg::Print(const char * pString)
{
	SetColor(0);
	m_Cons.SetSel(INT_MAX,INT_MAX);
	m_Cons.ReplaceSel(m_nlStr);

	const char * ch;
	const char * ch1 = pString;
	char out[5120];
	
	while (ch = strchr(ch1, '$'))
	{
		strncpy(out, ch1, ch-ch1);
		out[ch-ch1] = 0;
		m_Cons.SetSel(INT_MAX,INT_MAX);
		m_Cons.ReplaceSel(out);
		ch1 = ch+1;
		if(*ch1)
		{
			char col[2];
			col[0] = *ch1;
			col[1] = 0;
			int code = atoi(col);
			SetColor(code);
			ch1++;
		}
	}

	m_Cons.SetSel(INT_MAX,INT_MAX);
	m_Cons.ReplaceSel(ch1);

	// scroll down
	long nSt, nEnd;
	m_Cons.GetSel(nSt, nEnd);
	CPoint pt = m_Cons.PosFromChar(nEnd);
	RECT rc;
	m_Cons.GetClientRect(&rc);
	for(int i=0; rc.bottom < pt.y+10 && i<1024; i++)
	{
		m_Cons.LineScroll(1);
		pt = m_Cons.PosFromChar(nEnd);
	}
	
	m_nlStr = "\r\n";
}

void CXenonConsoleDlg::OnSkinChanged()
{
	OnSysColorChange();
	RedrawWindow(0, 0, RDW_INVALIDATE|RDW_UPDATENOW|RDW_ERASE|RDW_ALLCHILDREN);		

	XTPPaintManager()->RefreshMetrics();

}

void CXenonConsoleDlg::LoadCrySkin()
{
	CXTPPaintManager::SetTheme(xtpThemeNativeWinXP);
	BOOL bLoaded = XTPSkinManager()->LoadSkin( "..\\Editor\\Styles\\CryDark.cjstyles" );

	// Apply skin, including metrics, coloring and frame
	XTPSkinManager()->SetApplyOptions(xtpSkinApplyMetrics|xtpSkinApplyColors|xtpSkinApplyFrame|xtpSkinApplyMenus);

	// Apply skin to all new windows and threads

	XTPSkinManager()->SetAutoApplyNewWindows(TRUE);

	XTPSkinManager()->SetAutoApplyNewThreads(TRUE);

	// Apply skin to current thread and window

	XTPSkinManager()->EnableCurrentThread();

	XTPSkinManager()->ApplyWindow(this->GetSafeHwnd());

	bool test = XTPSkinManager()->IsColorFilterExists();
	// Redraw everything

	XTPSkinManager()->RedrawAllControls();

	OnSkinChanged();
}

int CXenonConsoleDlg::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	LoadCrySkin();
	return 0;
}

// ----------------------------------------------------

BEGIN_MESSAGE_MAP(CEditCtrl, CRichEditCtrl)
	ON_WM_CONTEXTMENU()
	ON_WM_PAINT()
END_MESSAGE_MAP()

CEditCtrl::CEditCtrl():CRichEditCtrl()
{
}

void CEditCtrl::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	CMenu menu;
	if (menu.CreatePopupMenu())
	{
		menu.AppendMenu(MF_STRING,		RC_IDM_CLEARALL,	"Clear all"	);
		menu.TrackPopupMenu(TPM_LEFTALIGN|TPM_LEFTBUTTON, point.x, point.y, this);
	}
}

BOOL CEditCtrl::OnCommand(WPARAM wParam, LPARAM lParam) 
{
	if(LOWORD(wParam)==RC_IDM_CLEARALL)
	{
		SetSel(0,INT_MAX);
		ReplaceSel(_T(""));
	}

	return true;
}