// XenonConsoleDlg.h : header file
//

#include "afxwin.h"

#include <vector>
#include <string>
#include <XTToolkitPro.h>

using namespace std;


#pragma once

#define ALL_COMMANDS_SIZE 50000


class CEditCtrl : public CRichEditCtrl
{
	enum
	{
		RC_IDM_CLEARALL,
	};

public:
	CEditCtrl();
	~CEditCtrl(){};

protected:
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);

	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	DECLARE_MESSAGE_MAP()
};

// CXenonConsoleDlg dialog
class CXenonConsoleDlg : public CDialog
{
// Construction
public:
	CXenonConsoleDlg(CWnd* pParent = NULL);	// standard constructor


	void Print(const char * pString);

// Dialog Data
	enum { IDD = IDD_XENONCONSOLE_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	BOOL PreTranslateMessage(MSG* pMsg);


// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	bool OpenConnection();
	void CloseConnection();
	void SetColor(int code);
	void InitVars();

	afx_msg void OnSkinChanged();
	afx_msg void LoadCrySkin();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnSize(UINT nType, int cx, int cy );
	afx_msg void OnBnClickedCancel();
	afx_msg void OnBnClickedOk();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	DECLARE_MESSAGE_MAP()
public:

	CEdit m_Command;
	int m_CommandX;
	int m_CommandY;

	vector <string> m_commList;
	int m_curInList;

	CString m_consoleStr;
	CEditCtrl m_Cons;
	int m_ConsoleY;
	CString m_nlStr;
	bool m_isVars;

	PDM_CONNECTION m_pdmConnection;
	PDMN_SESSION m_pdmnSession;

	char pCommands[ALL_COMMANDS_SIZE];
	char * m_pCh;

	CString m_FindBegin;
};
