//#include "stdafx.h"
#include "DebugHelper.h"
#include <DbgHelp.h>
#include <Winbase.h>
using namespace DebugHelper;
#pragma comment( lib, "dbghelp.lib" )

namespace
{
	void FreeConvertedString(char* str)
	{
		System::Runtime::InteropServices::Marshal::FreeHGlobal((IntPtr)str);
	}

	char* ConvertString(String^ str)
	{
		return (char*)(void*) System::Runtime::InteropServices::Marshal::StringToHGlobalAnsi(str);
	}

	static GUID ConvertByteArrayToGuid(Guid^ guid)
	{
		GUID result;
		cli::array<System::Byte>^ guidData = guid->ToByteArray();
		result.Data1 = BitConverter::ToUInt32(guidData, 0);
		result.Data2 = BitConverter::ToInt16(guidData, 4);
		result.Data3 = BitConverter::ToInt16(guidData, 6);
		for(int index = 0; index < 8; ++index){
			result.Data4[index] = guidData[index + 8];
		}
		return result;

	}

}

SymbolServer::SymbolServer(String^ symbolSearchPath)
{
	// Enable DbgHelp debug messages, make sure that DbgHelp only loads symbols that
	// exactly match, and do deferred symbol loading for greater efficiency.
	SymSetOptions( SYMOPT_DEBUG | SYMOPT_EXACT_SYMBOLS | SYMOPT_DEFERRED_LOADS );
	m_currentProcessHandler = GetCurrentProcess();

	char* fullPath = ConvertString(symbolSearchPath);
	BOOL result = SymInitialize( m_currentProcessHandler, fullPath, FALSE);
	FreeConvertedString(fullPath);
}

//PFINDFILEINPATHCALLBACK 
BOOL CALLBACK FindFileInPathProc(PCSTR fileName, PVOID context)
{
	// context is the string of the GUID
	const char *GUIDStr = (const char *)context;
	//printf("FindFileInPathProc() fileName=%s; GUID=%s", fileName, GUIDStr);

	if (strstr(fileName, GUIDStr))
	{
		return FALSE;
	}

	return TRUE;
}

bool^ SymbolServer::FindFileInPath(String^ path, Guid^ guid, long age, String^% foundPath)
{
	char resultPath[2000];
	char* pdbFilepath = ConvertString(path);
	GUID guidWrap= ConvertByteArrayToGuid(guid);

	// this is returning the wrong path for xamd.pdb - F827C231-C773-4124-9E C7-09 01 E4 16 68 8D
	// yet returning C:\Program Files (x86)\Microsoft Xbox 360 SDK\bin\xbox\symsrv\xamd.pdb\BEFBEF7AFA154812B69A711F706A47861\xamd.pdb
	SymSetOptions(SYMOPT_EXACT_SYMBOLS);
	System::String^ guidString = guid->ToString();
	guidString = guidString->ToUpper();
	char *guidStr = ConvertString(guidString);
	int strSize = strlen(guidStr)+1;
	char *finalString = new char[strSize];
	int numWritten=0;

	for (unsigned int i=0; i<strlen(guidStr); i++)
	{
		if (guidStr[i] != '-')
		{
			//assert(numWritten < strSize);
			finalString[numWritten] = guidStr[i];
			numWritten++;
		}
	}
	//assert(numWritten<strSize);
	finalString[numWritten]=0;

	bool result = (SymFindFileInPath(m_currentProcessHandler, 0, pdbFilepath , &guidWrap, age, 0, SSRVOPT_GUIDPTR, resultPath, FindFileInPathProc, (PVOID)finalString)==TRUE);
	
	FreeConvertedString(guidStr);
	delete[] finalString;

	foundPath = gcnew String(resultPath);
	FreeConvertedString(pdbFilepath);
	return result;

}
SymbolServer::~SymbolServer()
{
	SymCleanup(m_currentProcessHandler);
}
