using System;
using System.Collections.Generic;
using System.Text;
using System.Configuration;

namespace CrashHandler
{
    public class Settings
    {
        public Settings(String errorLogName)
        {
            this.errorLogName = errorLogName;

            #region Saved Settings
            Configuration configuration = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None);
            KeyValueConfigurationCollection settings = configuration.AppSettings.Settings;

			/*
            soapServiceTimeoutInSeconds = int.Parse(settings["SoapServiceTimeoutInSeconds"].Value);
            jiraServer = settings["JiraServer"].Value;
            project = settings["Project"].Value;
            username = settings["Username"].Value;
            password = settings["Password"].Value;
            assignee = settings["Assignee"].Value;
            normalIssueType = settings["NormalIssueType"].Value;
            editorIssueType = settings["EditorIssueType"].Value;

            logFileName = settings["LogFileName"].Value;
            minSizeInKBToZipAttachments = long.Parse(settings["MinSizeInKBToZipAttachments"].Value);
            maximumAttachmentSizeInKb = long.Parse(settings["MaximumAttachmentSizeInKb"].Value);
            jpgCompressionQuality = long.Parse(settings["JpgCompressionQuality"].Value);
            extraAttachments = settings["ExtraAttachments"].Value.Split(new char[] { ';' }, StringSplitOptions.RemoveEmptyEntries);

            programMaintainerName = settings["ProgramMaintainerName"].Value;
            programMaintainerEmail = settings["ProgramMaintainerEmail"].Value.Split(';');
            emailSenderEmailAddress = programMaintainerEmail[0];
            emailSenderName = programMaintainerName;

            smtpHost = settings["SmtpHost"].Value;

            #endregion

            platformXbox = settings["PlatformXbox"].Value;
            platformPS3 = settings["PlatformPS3"].Value;
            platformPC = settings["PlatformPC"].Value;

            #region XboxSettings
            pdbSymbolsLookupFolders = settings["pdbSymbolsLookupFolders"] == null ? String.Empty : settings["pdbSymbolsLookupFolders"].Value;

            KeyValueConfigurationElement key = settings["SameFileTimeToleranceInMinutes"];
            if(key == null  || !int.TryParse(key.Value, out sameFileTimeToleranceInMinutes))
            {
                sameFileTimeToleranceInMinutes = 3;
            }
            xboxBackupFolder = settings["xboxBackupFolder"] == null ? "SubmittedCrashBackup" : settings["xboxBackupFolder"].Value;
            maximumErrorLogAgeInHours = settings["maximumErrorLogAgeInHours"] == null ? 2 : int.Parse(settings["maximumErrorLogAgeInHours"].Value);
			 * 
			 */
            symbolServerPath = settings["symbolServerPath"] == null ? String.Empty : settings["symbolServerPath"].Value;
            String ntSymbolPath = "C:\\Program Files (x86)\\Microsoft Xbox 360 SDK\\bin\\xbox\\symsrv"; //Environment.GetEnvironmentVariable("_NT_SYMBOL_PATH");
            if(!String.IsNullOrEmpty(symbolServerPath) && !String.IsNullOrEmpty(ntSymbolPath)){
                symbolServerPath = symbolServerPath + ";" + ntSymbolPath;
            } 
            else if(String.IsNullOrEmpty(symbolServerPath)&& !String.IsNullOrEmpty(ntSymbolPath))
            {
                symbolServerPath = ntSymbolPath;
            }
            #endregion

        }


		/*
        readonly private String jiraServer;
        public string JiraServer
        {
            get {
                return jiraServer;
            }
        }

        readonly private int soapServiceTimeoutInSeconds;
        public int SoapServiceTimeoutInSeconds
        {
            get { return soapServiceTimeoutInSeconds; }
        }

        readonly private string project;
        public string Project
        {
            get { return project; }
        }

        readonly private string username;
        public string Username
        {
            get { return username; }
        }

        readonly private string password;
        public string Password
        {
            get { return password; }
        }

        readonly private string assignee;
        public string Assignee
        {
            get { return assignee; }
        }

        readonly private string normalIssueType;
        public string NormalIssueType
        {
            get { return normalIssueType; }
        }


        readonly private string editorIssueType;
        public string EditorIssueType
        {
            get { return editorIssueType; }
        }

        readonly private long jpgCompressionQuality;
        public long JpgCompressionQuality
        {
            get { return jpgCompressionQuality; }
        }

        readonly private string logFileName;
        public string LogFileName
        {
            get { return logFileName; }
        }

        readonly private long minSizeInKBToZipAttachments;
        public long MinSizeInKBToZipAttachments
        {
            get { return minSizeInKBToZipAttachments; }
        }

        readonly private long maximumAttachmentSizeInKb;
        public long MaximumAttachmentSizeInKb
        {
            get { return maximumAttachmentSizeInKb; }
        }

        readonly private string[] extraAttachments;
        public string[] ExtraAttachments
        {
            get { return extraAttachments; }
        }

        readonly private string emailSenderName;
        public string EmailSenderName
        {
            get { return emailSenderName; }
        }

        readonly private string emailSenderEmailAddress;
        public string EmailSenderEmailAddress
        {
            get { return emailSenderEmailAddress; }
        }

        readonly private string programMaintainerName;
        public string ProgramMaintainerName
        {
            get { return programMaintainerName; }
        }

        readonly private string[] programMaintainerEmail;
        public string[] ProgramMaintainerEmail
        {
            get { return programMaintainerEmail; }
        }

        readonly private string smtpHost;
        public string SmtpHost
        {
            get { return smtpHost; }
        }

        readonly private string platformXbox;
        public string PlatformXbox
        {
            get { return platformXbox; }
        }

        readonly private string platformPS3;
        public string PlatformPS3
        {
            get { return platformPS3; }
        }

        readonly private string platformPC;
        public string PlatformPC
        {
            get { return platformPC; }
        }

        readonly private String pdbSymbolsLookupFolders;
        public string PdbSymbolsLookupFolders{
            get { return pdbSymbolsLookupFolders; }
        }

        readonly private int sameFileTimeToleranceInMinutes;
        public int SameFileTimeToleranceInMinutes{
            get { return sameFileTimeToleranceInMinutes; }
        }

		 */

        readonly private String errorLogName;

        public String ErrorLogName{
            get { return errorLogName; }
        }
		
		/*
        readonly private String xboxBackupFolder;
        public String XboxBackupFolder{
            get { return xboxBackupFolder; }
        }

        readonly private int maximumErrorLogAgeInHours;
        public int MaximumErrorLogAgeInHours{
            get { return maximumErrorLogAgeInHours; }
        }
		 */

        readonly private String symbolServerPath;
        public String SymbolServerPath{
            get { return symbolServerPath; }
        }
    }
}
