﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace Xbox360CrashHandler
{
    static class StringHelper
    {
        public static readonly String EMPTY_LINE_REGEX = "^\\s*$";
        public static string[] GetNonEmptyLines(String aText)
        {
            return GetLines(aText, StringSplitOptions.RemoveEmptyEntries);
        }

        public static string[] GetAllLines(String aText)
        {
            return GetLines(aText, StringSplitOptions.None);
        }

        private static string[] GetLines(String aText, StringSplitOptions options)
        {
            return aText.Replace("\r", "").Split(new String[] { "\n" }, options);
        }

        public static String GetLinesBetweenPatterns(String aText, String startRegex, String endRegex, LineOptions options){
            String[] lines = GetAllLines(aText);
            StringBuilder foundLines = new StringBuilder();
            String separator = String.Empty;
            bool match = false;
            foreach (String line in lines)
            {
                if(match && Regex.IsMatch(line, endRegex, RegexOptions.IgnoreCase) )
                {
                    if(options == LineOptions.includeEnd || options == LineOptions.includeBoth){
                        foundLines.Append(separator);
                        foundLines.Append(line);
                    }
                    break;
                } 
                else if (match)
                {
                    foundLines.Append(separator);
                    foundLines.Append(line);
                    separator = Environment.NewLine;
                }
                else if(Regex.IsMatch(line, startRegex, RegexOptions.IgnoreCase))
                {
                    match = true;
                    if (options == LineOptions.includeStart || options == LineOptions.includeBoth)
                    {
                        foundLines.Append(line);
                        separator = Environment.NewLine;
                    }
                } 
            }
            String result = foundLines.ToString();
            if(result.Trim().Equals(String.Empty)) 
            {
                return aText;
            }
            return result;
        }

        public enum LineOptions{
            exclusive =0, 
            includeStart = 1,
            includeEnd = 2,
            includeBoth = 3
        }

    }
}
