using System;
//using System.Drawing;
//using System.Drawing.Imaging;
using System.IO;
using System.IO.Compression;
//using System.Windows.Forms;
using System.Collections.Generic;
using System.Net;
using System.Text.RegularExpressions;

namespace CrashHandler
{
    public class Util
    {
        public static byte[] GetFileData(string filePath)
        {
            byte[] fileData = null;

            using (FileStream fileStream = File.OpenRead(filePath))
            {
                fileData = new byte[fileStream.Length];
                fileStream.Read(fileData, 0, fileData.Length);
            }

            return fileData;
        }

        public static string GetFileText(string filePath)
        {
            using (StreamReader fileStream = new StreamReader(filePath))
            {
                return fileStream.ReadToEnd();
            }
        }

        public static string CreateCompressedFile(string folder, string fileName)
        {
            string outputFileName = fileName + ".gz";

            byte[] fileData = GetFileData(folder + fileName);

            using (FileStream outFile = File.OpenWrite(folder + outputFileName))
            {
                using (GZipStream compressedOuput = new GZipStream(outFile, CompressionMode.Compress))
                {
                    compressedOuput.Write(fileData, 0, fileData.Length);
                }
            }

            return outputFileName;
        }

		/*
        public static string ConvertToJpg(string attachmentDirectory, string attachmentName, long quality)
        {
            int index = attachmentName.LastIndexOf('.');
            string newAttachmentName = attachmentName.Substring(0, index) + ".jpg";

            Bitmap img = new Bitmap(attachmentDirectory + attachmentName);

            saveJpeg(attachmentDirectory + newAttachmentName, img, quality);

            return newAttachmentName;
        }
		*/

        public static String PrettyTimespan(TimeSpan t){
            if(t.TotalHours > 24){
                return Math.Floor(t.TotalDays) + " days and " + t.Hours + " hours";
            }
            return Math.Floor(t.TotalHours) + " hours";
        }

		/*
        private static void saveJpeg(string path, Bitmap img, long quality)
        {
            // Encoder parameter for image quality
            EncoderParameter qualityParam = new EncoderParameter(Encoder.Quality, quality);

            // Jpeg image codec
            ImageCodecInfo jpegCodec = getEncoderInfo("image/jpeg");

            if (jpegCodec == null)
                return;

            EncoderParameters encoderParams = new EncoderParameters(1);
            encoderParams.Param[0] = qualityParam;

            img.Save(path, jpegCodec, encoderParams);
        }

        private static ImageCodecInfo getEncoderInfo(string mimeType)
        {
            // Get image codecs for all image formats
            ImageCodecInfo[] codecs = ImageCodecInfo.GetImageEncoders();

            // Find the correct image codec
            for (int i = 0; i < codecs.Length; i++)
                if (codecs[i].MimeType == mimeType)
                    return codecs[i];
            return null;
        }

		*/

		/*
        public static IDictionary<String, String> GetNamedArgumentsWithProperties(String[] args)
        {
            String key = String.Empty;
            IDictionary<String, String> result = new Dictionary<String, String>();
            bool errors = false;

            foreach (String argument in args)
            {
                Match match = Regex.Match(argument, "(-[^=]*)=(.*)");

                if (match.Success)
                {
                    result.Add(match.Groups[1].Value, match.Groups[2].Value);
                }
                else
                {
                    MessageBox.Show("The following argument is not in the correct format" + argument);
                    errors = true;
                }
            }
            if (errors)
            {
                throw new ArgumentException("Invalid parameters");
            }
            return result;
        }
		 */

        public static string ReverseDNS(string ip, int timeout)
        {
            try
            {
                return Dns.GetHostEntry(ip).HostName;
            }
            catch (Exception)
            {
                // Error occurred, send back IP Address instead of hostname
                return ip;
            }
        }
        
        public static List<String> GetMatchingFolders(String path)
        {
            String root = Path.GetPathRoot(path);
            String[] subfolders = path.Substring(root.Length, path.Length - root.Length).Split(new char[]{Path.DirectorySeparatorChar, Path.AltDirectorySeparatorChar}, StringSplitOptions.RemoveEmptyEntries);
            List<String> result = new List<String>();
            result.Add(root);
            foreach(String folder in subfolders){
                result = NavigateFolderWithPattern(result, folder);
            }

            return result;
        }
        
        private static List<String> NavigateFolderWithPattern(List<String> folders, String pattern){
            List<String> result = new List<String>();
            foreach(String folder in folders){
                result.AddRange(Directory.GetDirectories(folder, pattern));
            }
            return result;
        }

        public static int CountStringOccurrences(String text, String pattern)
        {
            int count = 0;
            int index = 0;
            while ((index = text.IndexOf(pattern, index)) != -1)
            {
                index += pattern.Length;
                ++count;
            }
            return count;
        }

    }
}
