﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using CrashHandler;
using Xbox360CrashHandler;

namespace XenonStackParse
{
	class XenonStackParse
	{
		static void Main(string[] args)
		{
			string pdbFilePath = "";
			string errorLogInFileName = "error.log";
			string errorLogOutFileName = "error_parsed.log";

			if (args.Length == 0)
			{
				System.Console.Out.WriteLine("no parameters found. Using defaults. For help pass --help");
			}

			int i=0;
			while(i<args.Length)
			{
				string arg = args[i];
				arg.ToLower();
	
				if (arg == "--help" || arg == "--usage")
				{
					System.Console.Out.WriteLine("XenonStackParse -pdbpath <PDB filename> -errorloginput <Error log input filename> -errorlogoutput <Error log output filename>\n\n-pdbpath <PDB file path>\n\t- (optional) path to .pdb files to load - defaults to ''\n-errorloginput <Error log input filename>\n\t- (optional) error log file to load - defaults to error.log\n-errorlogoutput <Error log output filename>\n\t- (optional) error log file to save out - defaults to error_parsed.log");
					return;
				}
				else if (arg == "-pdbpath")
				{
					i++;
					if (i < args.Length)
					{
						pdbFilePath = args[i];
						System.Console.Out.WriteLine("-pdbpath setting pdbFilePath to " + pdbFilePath);
					}
					else
					{
						System.Console.Error.WriteLine("encountered a -pdbpath parameter but found no value to set the path to!");
						return;
					}
				}
				else if (arg == "-errorloginput")
				{
					i++;
					if (i < args.Length)
					{
						errorLogInFileName = args[i];
						System.Console.Out.WriteLine("-errorloginput setting errorLogInFileName to " + errorLogInFileName);
					}
					else
					{
						System.Console.Error.WriteLine("encountered an -errorloginput parameter but found no value to set the error log to!");
						return;
					}
				}
				else if (arg == "-errorlogoutput")
				{
					i++;
					if (i < args.Length)
					{
						errorLogOutFileName = args[i];
						System.Console.Out.WriteLine("-errorlogoutput setting errorLogOutFileName to " + errorLogOutFileName);
					}
					else
					{
						System.Console.Error.WriteLine("encountered an -errorlogoutput parameter but found no value to set the error log to!");
						return;
					}
				}
				else
				{
					System.Console.Error.WriteLine("encountered unknown argument - " + arg);
					return;
				}

				i++;
			}

			/*
			System.Console.Out.WriteLine("Main() called with " + args.Length + " arguments");
			for (int i=0; i<args.Length; i++)
			{
				System.Console.WriteLine("Main() argument[" + i + "]=" + args[i]);
				string arg = args[i];
				arg.ToLower();

				if (arg == "--help" || arg == "--usage")
				{
					System.Console.Out.WriteLine("XenonStackParse <PDB filename> <Error log filename>\n\n<PDB file path> - path to .pdb files to load\n<Error log filename> - (optional error log file to load. Default file is error.log");
					return;
				}
			}


			if (args.Length >= 1)
			{
				pdbFilePath = args[0];

				if (args.Length == 2)
				{
					errorLogFileName = args[1];
				}
			}
			*/

			System.Console.Out.WriteLine("using:\n.pdb file path=" + pdbFilePath + "\nerror log input filename=" + errorLogInFileName + "\nerror log output filename=" + errorLogOutFileName);
			
			XenonStackParse parser = new XenonStackParse(pdbFilePath, errorLogInFileName, errorLogOutFileName);
		}

        protected readonly Settings m_settings;
        protected readonly Log m_log;
        protected readonly ExceptionHandler m_exceptionHandler;

		XenonStackParse(string pdbFilePath, string errorLogInFileName, string errorLogOutFileName)
		{
            m_log = new Log("");
            m_exceptionHandler = new ExceptionHandler(m_log, m_settings);

            try
            {
                m_settings = new Settings(errorLogInFileName);
            }
            catch (Exception exception)
            {
                ExceptionHandler.StartupException("XenonStackParse encountered an exception loading settings: ", exception);
                Environment.Exit(1);
            }

            XboxCallStackDecoder decoder = new XboxCallStackDecoder(errorLogInFileName, m_log, "", pdbFilePath, m_settings, m_exceptionHandler); //, m_xboxFilesystem);
            System.IO.File.WriteAllText(errorLogOutFileName, decoder.GetCallStackTrace());

			//System.Diagnostics.Debug.WriteLine("Main() called");
		}
	}
}
