// stealthcopy.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "Xbdm.h"
#include <stdio.h>
#include <direct.h>
#include <io.h>
#include <string>
#include <xtl.h>
#include <xui.h>
#include <xuiapp.h>

HXUIOBJ progressBar;
HXUIOBJ text;

//--------------------------------------------------------------------------------------
// Scene implementation class.
//--------------------------------------------------------------------------------------
class CMyMainScene : public CXuiSceneImpl
{


protected:

	// Control and Element wrapper objects.
	CXuiControl m_progressBar;
	CXuiTextElement m_text1;

	// Message map.
	XUI_BEGIN_MSG_MAP()
		XUI_ON_XM_INIT( OnInit )
		XUI_ON_XM_NOTIFY_PRESS( OnNotifyPress )
		XUI_END_MSG_MAP()

		//----------------------------------------------------------------------------------
		// Performs initialization tasks - retreives controls.
		//----------------------------------------------------------------------------------
		HRESULT OnInit( XUIMessageInit* pInitData, BOOL& bHandled )
	{
		// Retrieve controls for later use.
		GetChildById( L"XuiText2", &m_text1 );
		GetChildById( L"XuiText2", &text );
		GetChildById( L"XuiProgressBar1", &m_progressBar );
		GetChildById( L"XuiProgressBar1", &progressBar );
		return S_OK;
	}

	//----------------------------------------------------------------------------------
	// Handler for the button press message.
	//----------------------------------------------------------------------------------
	HRESULT OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled )
	{
		// Determine which button was pressed,
		// and set the text accordingly.

		bHandled = TRUE;
		return S_OK;
	}

public:
	void ShowProgress(const char * message, int progress);
	// Define the class. The class name must match the ClassOverride property
	// set for the scene in the UI Authoring tool.
	XUI_IMPLEMENT_CLASS( CMyMainScene, L"MyMainScene", XUI_CLASS_SCENE )
};


//--------------------------------------------------------------------------------------
// Main XUI host class. It is responsible for registering scene classes and provide
// basic initialization, scene loading and rendering capability.
//--------------------------------------------------------------------------------------
class CMyApp : public CXuiModule
{
protected:
	// Override RegisterXuiClasses so that CMyApp can register classes.
	virtual HRESULT RegisterXuiClasses();

	// Override UnregisterXuiClasses so that CMyApp can unregister classes. 
	virtual HRESULT UnregisterXuiClasses();
};



CMyApp app;
int counter = 0;
int total = 0;

bool compare_file(const char * file, DWORD size_low, DWORD size_high )
{
	WIN32_FIND_DATA wfd;
	HANDLE hFind;
	hFind = FindFirstFile( file, &wfd );

	if( INVALID_HANDLE_VALUE != hFind )
	{
		FindClose( hFind );
		return wfd.nFileSizeHigh == size_high && wfd.nFileSizeLow == size_low;
	}

	return false;
}

void copyfile(const char * folderPath, const char * startFolder, bool justCount)
{

	WIN32_FIND_DATA wfd;
	HANDLE hFind;

	std::string newFolder = "e:\\";
	newFolder += startFolder;
	if (folderPath) {
		newFolder += folderPath;
	}
	mkdir(newFolder.c_str());

	std::string strFind("d:\\");
	if (folderPath) {
		strFind += folderPath;
		strFind += "\\";
	}
	const std::string srcFolder(strFind);
	strFind += "*";

	hFind = FindFirstFile( strFind.c_str(), &wfd );
	if( INVALID_HANDLE_VALUE == hFind )
	{
		OutputDebugString( "FindFirstFile failed." );
	}
	else
	{
		// Display each file and ask for the next.
		do
		{
			if (wfd.dwFileAttributes  & FILE_ATTRIBUTE_DIRECTORY) {
				std::string newDirName = folderPath ? folderPath : "";
				if (folderPath)
					newDirName += "\\";

				newDirName += wfd.cFileName;
				copyfile(newDirName.c_str(), startFolder, justCount);
			}
			else 
			{

				if (!justCount) {
					std::string oldName(srcFolder);
					oldName += wfd.cFileName;
					std::string newName(newFolder);

					if (folderPath)
						newName += "\\";
					newName += wfd.cFileName;

					if (_stricmp("default.xex", wfd.cFileName) != 0) {

						
						WCHAR fileName[128];
						memset(fileName,0,sizeof(fileName));
						MultiByteToWideChar(CP_UTF8, 0, 
						wfd.cFileName, strlen(wfd.cFileName), 
						fileName, 128 );

						XuiTextElementSetText(text, fileName);

						if (!compare_file(newName.c_str(), wfd.nFileSizeLow, wfd.nFileSizeHigh ))
							if (!CopyFile(oldName.c_str(), newName.c_str(), FALSE ))
							{
								OutputDebugString( "Error in copy:" );
								
							}
					}

				} 

				++counter;
				XuiProgressBarSetValue(progressBar, counter);


				
				//copy_single_file(wfd.cFileName);

				OutputDebugString( wfd.cFileName );
				OutputDebugString( "\n" );
			} 

		} while( FindNextFile( hFind, &wfd ) );

		// Close the find handle.
		FindClose( hFind );
	}

}
 

DWORD WINAPI ThreadFunc( LPVOID lpParam ) 
{
	counter = 0;
 	copyfile(0, "Crysis2\\", true);
	total = counter ? counter : 1;
	counter = 0;
	XuiProgressBarSetRange(progressBar, 0, total);

	copyfile(0, "Crysis2\\", false);
	XuiProgressBarSetRange(progressBar, 100, 100);

	XuiTextElementSetText(text, L"Please remove disk and restart XBOX");

	//app.Quit();
	return ERROR_SUCCESS; 

};




//--------------------------------------------------------------------------------------
// Name: RegisterXuiClasses
// Desc: Registers all the scene classes.
//--------------------------------------------------------------------------------------
HRESULT CMyApp::RegisterXuiClasses()
{
	return CMyMainScene::Register();
}


//--------------------------------------------------------------------------------------
// Name: UnregisterXuiClasses
// Desc: Unregisters all the scene classes.
//--------------------------------------------------------------------------------------
HRESULT CMyApp::UnregisterXuiClasses()
{
	CMyMainScene::Unregister();
	return S_OK;
}


//--------------------------------------------------------------------------------------
// Name: main
// Desc: Application entry point.
//--------------------------------------------------------------------------------------
VOID __cdecl main()
{
	// Declare an instance of the XUI framework application.


	// Initialize the application.    
	HRESULT hr = app.Init( XuiD3DXTextureLoader );
	if( FAILED( hr ) )
	{
		OutputDebugString( "Failed intializing application.\n" );
		return;
	}

	// Register a default typeface
	hr = app.RegisterDefaultTypeface( L"Arial Unicode MS", L"file://game:/media/xarialuni.ttf" );
	if( FAILED( hr ) )
	{
		OutputDebugString( "Failed to register default typeface.\n" );
		return;
	}

	// Load the skin file used for the scene.
	//app.LoadSkin( L"file://game:/media/simplescene.xzp#..\\..\\Media\\xui\\simple_scene_skin.xur" );
		app.LoadSkin( L"file://game:/media/simplescene.xzp#simple_scene_skin.xur" );

	// Load the scene.
		app.LoadFirstScene( L"file://game:/media/simplescene.xzp#", L"simple_scene.xur", NULL );


		hr = DmMapDevkitDrive();

		DWORD dwThreadId, dwThrdParam = 1; 
		HANDLE hThread; 


		hThread = CreateThread( 
			NULL,                        // (this parameter is ignored)
			0,                           // use default stack size  
			ThreadFunc,                  // thread function 
			&dwThrdParam,                // argument to thread function 
			0,                           // use default creation flags 
			&dwThreadId);                // returns the thread identifier 


	// Run the scene.    
	app.Run();



	while(true)
		;

	// Free resources, unregister custom classes, and exit.
	app.Uninit();

	//DmReboot(DMBOOT_TITLE);
}
