chars_per_line = 16
chars_per_space = 4

def asciidump(f):
	def nibble_char(n):
		if n < 10:
			return chr(ord('0') + n)
		else:
			return chr(ord('A') + n - 10)

	while True:
		s = f.read(chars_per_line)
		if len(s) == 0:
			break
		line = ''
		for i, c in enumerate(s):
			v = ord(c)
			line += nibble_char(v >> 8) + nibble_char(v & 0xF)
			if (i & (chars_per_space - 1)) == (chars_per_space - 1):
				line += ' '
		yield line

