#!/usr/bin/env python

from chunkfile import load_chunk_file, VersionError
import sys, os
import wx
from cStringIO import StringIO
import _winreg

# Process the command line.  Not much to do;
# just get the name of the project file if it's given. Simple.
projfile = 'Unnamed'
if len(sys.argv) > 1:
	projfile = sys.argv[1]

def MsgDlg(window, string, caption='wxProject', style=wx.YES_NO|wx.CANCEL):
	"""Common MessageDialog."""
	dlg = wx.MessageDialog(window, string, caption, style)
	result = dlg.ShowModal()
	dlg.Destroy()
	return result

def get_chunk_text(chunk, pos):
	outfile = StringIO()
	oldstdout = sys.stdout
	sys.stdout = outfile
	view_chunk(chunk, pos)
	sys.stdout = oldstdout
	value = outfile.getvalue()
	outfile.close()
	return value

def view_chunk(chunk, pos):
	try:
		name = chunk.get_name()
	except chunkfile.chunks.UnknownChunkError:
		name = '<Unkown Chunk>'

	print '%s' % name
	print 'id = 0x%.4X (%d)' % (chunk.id, chunk.id)
	print 'type = 0x%.8X' % chunk.typecode
	print 'pos = 0x%.8X (%d)' % (pos, pos)
	print 'version = 0x%.4X' % chunk.version
	print 'size = 0x%.8X (%d)' % (chunk.size, chunk.size)
	print ''

	if hasattr(chunk, "format"):
		try:
			chunk.format(pos)
		except VersionError:
			print '<CHUNK VERSION NOT UNDERSTOOD>'
	else:
		print '<CHUNK NOT UNDERSTOOD>'

class main_window(wx.Frame):
	"""wxProject MainFrame."""
	def __init__(self, parent, title):
		"""Create the wxProject MainFrame."""
		wx.Frame.__init__(self, parent, title=title, size=(500, 500),
						  style=wx.DEFAULT_FRAME_STYLE|wx.NO_FULL_REPAINT_ON_RESIZE)


		# Set up menu bar for the program.
		self.mainmenu = wx.MenuBar()				  # Create menu bar.

		# Make the 'File' menu.
		menu = wx.Menu()

		item = menu.Append(wx.ID_OPEN, '&Open', 'Open project')  # Append a new menu
		self.Bind(wx.EVT_MENU, self.OnProjectOpen, item)  # Create and assign a menu event.

		item = menu.Append(wx.ID_EXIT, 'E&xit', 'Exit program')
		self.Bind(wx.EVT_MENU, self.OnProjectExit, item)

		self.mainmenu.Append(menu, '&File')  # Add the file menu to the menu bar.

		# Attach the menu bar to the window.
		self.SetMenuBar(self.mainmenu)

		# Create the splitter window.
		splitter = wx.SplitterWindow(self, style=wx.NO_3D|wx.SP_3D)
		splitter.SetMinimumPaneSize(1)

		# Create the tree on the left.
		self.tree = wx.TreeCtrl(splitter, style=wx.TR_DEFAULT_STYLE)
		dt = FileDropTarget(self.tree, self)
		self.tree.SetDropTarget(dt)
		self.tree.Bind(wx.EVT_TREE_ITEM_ACTIVATED, self.OnTreeItemActivated)

		# Create the editor on the right.
		self.editor = wx.TextCtrl(splitter, style=wx.TE_MULTILINE)
		self.editor.SetDefaultStyle(wx.TextAttr(font=wx.Font(pointSize=10, family=wx.MODERN, style=wx.NORMAL, weight=wx.NORMAL)))
		self.editor.SetEditable(False)
		self.editor.Enable(0)

		# Install the tree and the editor.
		splitter.SplitVertically(self.tree, self.editor)
		splitter.SetSashPosition(180, True)

		# Some global state variables.
		self.root = None
		self.close = False

		self.Bind(wx.EVT_CLOSE, self.OnProjectExit)
		self.Show(True)

	# ----------------------------------------------------------------------------------------
	# Some nice little handlers.
	# ----------------------------------------------------------------------------------------

	def project_open(self, project_file):
		"""Open and process a wxProject file."""
		self.project_file = project_file
		try:
			self.chunk_file = load_chunk_file(self.project_file)
		except Exception, e:
			MsgDlg(self, 'Error loading file "%s":\n"%s"' % (self.project_file, e), 'Loading Error', wx.OK)
			return

		self.tree.DeleteAllItems()

		self.SetTitle(self.project_file)

		# create the file elements in the tree control.
		self.root = self.tree.AddRoot(self.project_file)
		#print dir(self.tree)
		self.activeitem = self.root
		for id, type, pos, name in self.chunk_file.iter_chunk_entries():
			pos, chunk = self.chunk_file.get_chunk(id)
			if not len(name):
				name = '<UNKNOWN_CHUNK>'
			#print 'id = %.4d	type = 0x%.8X	pos = 0x%.8X	%s' % (id, type, pos, name)
			item = self.tree.AppendItem(self.root, '(%d) %s' % (id, name))
			self.tree.SetPyData(item, (chunk, pos))
		self.tree.Expand(self.root)

		self.editor.Clear()
		self.editor.Enable(False)

	def CheckTreeRootItem(self):
		"""Is there any root item?"""
		if not self.root:
			MsgDlg(self, 'Please create or open a file before.', 'Error!', wx.OK)
			return False
		return True

	# ----------------------------------------------------------------------------------------
	# Event handlers from here on out.
	# ----------------------------------------------------------------------------------------

	def OnProjectOpen(self, event):
		hKey = _winreg.OpenKey (_winreg.HKEY_CURRENT_USER, r"Software\Crytek\Settings\chunkexplore", 0, _winreg.KEY_ALL_ACCESS)
		value, type = _winreg.QueryValueEx (hKey, "lastdir")
		"""Open a wxProject file."""
		dlg = wx.FileDialog(self, 'Choose a project to open', value, '', '*.*', wx.OPEN)
		if dlg.ShowModal() == wx.ID_OK:
			self.project_open(dlg.GetPath())
			dir = dlg.GetDirectory()
			_winreg.SetValueEx(hKey, "lastdir", 0, type, dir)
		dlg.Destroy()
		_winreg.CloseKey(hKey)

	def OnProjectExit(self, event):
		"""Quit the program."""
		if not self.close:
			self.close = True
			if self.close:
				self.Close()
		else:
			event.Skip()

	def OnTreeItemActivated(self, event, item=None):
		"""Tree item was activated: try to open this file."""
		if event:
			item = event.GetItem()
		self.activeitem = item
		if item != self.root:
			# load the current selected file
			self.editor.Enable(1)
			self.editor.Clear()
			chunk, pos = self.tree.GetPyData(item)
			self.editor.AppendText(get_chunk_text(chunk, pos))
			self.editor.SetInsertionPoint(0)
			self.editor.SetFocus()
		else:
			self.editor.Clear()
			self.editor.Enable(0)

class FileDropTarget(wx.FileDropTarget):
	def __init__(self, window, main):
		wx.FileDropTarget.__init__(self)
		self.window = window
		self.main = main
		#self.frame = self

	def OnDropFiles(self, x, y, filenames):
		self.main.project_open(filenames[0])

		
class App(wx.App):
	"""wxProject Application."""
	def OnInit(self):
		"""Create the wxProject Application."""
		frame = main_window(None, 'wxProject - ' + projfile)
		if projfile != 'Unnamed':
			frame.project_open(projfile)
		return True


if __name__ == '__main__':
	app = App(0)
	app.MainLoop()
