from chunk import Chunk, VersionError, DataReader
from chunk_utils import *
import struct

class BoneAnimChunk(Chunk):

	def format(self, pos):

		if self.version != 0x290:
			raise VersionError

		reader = DataReader(self.data)

		header = self.read_header(reader)
		header.format(pos)
		num_bones = header.find_field('nBones').value
		for bone_index in xrange(num_bones):
			self.read_bone(reader, bone_index).format(pos)

	def read_header(self, reader):

		field_defs = ([
				FieldDef('type', 'I', hex),
				FieldDef('version', 'i', hex),
				FieldDef('pos', 'i', hex),
				FieldDef('id', 'i', hex),
				FieldDef('nBones', 'i')
				])

		return read_fields('Bone Initial Pos Header', field_defs, reader)

	def read_bone(self, reader, bone_index):

		field_defs = ([
				FieldDef('BoneID', 'i'),
				FieldDef('ParentID', 'i'),
				FieldDef('nChildren', 'i'),
				FieldDef('ControllerID', 'I', hex),
				FieldDef('prop', '32s', null_termin),
				FieldDef('phys.nPhysGeom', 'i'),
				FlagsDef('phys.flags', 'i', ['angle0_locked', 'angle1_locked', 'angle2_locked', 'angle0_limit_reached', 'angle1_limit_reached', 'angle2_limit_reached', 'angle0_auto_kd', 'angle1_auto_kd', 'angle2_auto_kd', 'joint_no_gravity', 'joint_isolated_accelerations', 'joint_expand_hinge', 'angle0_gimbal_locked', 'angle1_gimbal_locked', 'angle2_gimbal_locked', 'joint_dashpot_reached', 'joint_ignore_impulses']),
				FieldDef('phys.min', '3f'),
				FieldDef('phys.max', '3f'),
				FieldDef('phys.spring_angle', '3f'),
				FieldDef('phys.spring_tension', '3f'),
				FieldDef('phys.damping', '3f'),
				FieldDef('phys.framemtx[0]', '3f'),
				FieldDef('phys.framemtx[1]', '3f'),
				FieldDef('phys.framemtx[2]', '3f')
				])

		return read_fields('Bone Entity (%d)' % bone_index, field_defs, reader)

