from chunk import Chunk, VersionError, DataReader
from chunk_utils import *
import struct

class BoneMeshChunk(Chunk):

	def format(self, pos):

		if self.version != 0x0744:
			raise VersionError

		reader = DataReader(self.data)

		header = self.read_header(reader)
		header.format(pos)
		num_vertices = header.find_field('nVerts').value
		for vertex_index in xrange(num_vertices):
			self.read_vertex(reader, vertex_index).format(pos)
		num_faces = header.find_field('nFaces').value
		for face_index in xrange(num_faces):
			self.read_face(reader, face_index).format(pos)
		num_texverts = header.find_field('nTVerts').value
		if num_texverts:
			for uv_index in xrange(num_texverts):
				self.read_uv(reader, uv_index).format(pos)
			for tex_face_index in xrange(num_faces):
				self.read_tex_face(reader, tex_face_index).format(pos)
		if header.find_field('flags1').flag_set('FLAG1_BONE_INFO'):
			for vertex_index in xrange(num_vertices):
				num_links_object = self.read_num_bone_links(reader, vertex_index)
				num_links_object.format(pos)
				num_links = num_links_object.find_field('num_links').value
				for link_index in xrange(num_links):
					self.read_bone_link(reader).format(pos)
		if header.find_field('flags2').flag_set('FLAG2_HAS_VERTEX_COLOR'):
			for vertex_index in xrange(num_vertices):
				self.read_vertex_colour(reader, vertex_index).format(pos)
		if header.find_field('flags2').flag_set('FLAG2_HAS_VERTEX_ALPHA'):
			for vertex_index in xrange(num_vertices):
				self.read_alpha(reader, vertex_index).format(pos)

	def read_header(self, reader):

		field_defs = ([
				FieldDef('type', 'I', hex),
				FieldDef('version', 'i', hex),
				FieldDef('pos', 'i', hex),
				FieldDef('id', 'i', hex),
				FlagsDef('flags1', 'B', ['FLAG1_BONE_INFO']),
				FlagsDef('flags2', 'B', ['FLAG2_HAS_VERTEX_COLOR', 'FLAG2_HAS_VERTEX_ALPHA']),
				FieldDef('nVerts', 'i'),
				FieldDef('nTVerts', 'i'),
				FieldDef('nFaces', 'i'),
				FieldDef('VertAnimID', 'i')])

		return read_fields('Bone Mesh Header', field_defs, reader)

	def read_vertex(self, reader, vertex_index):

		field_defs = ([
				FieldDef('position', '3f'),
				FieldDef('normal', '3f')
				])

		return read_fields('Vertex (%d)' % vertex_index, field_defs, reader)

	def read_face(self, reader, face_index):

		field_defs = ([
				FieldDef('indices', '3i'),
				FieldDef('mat_id', 'i'),
				FieldDef('smoothing group', 'i')
				])

		return read_fields('Face (%d)' % face_index, field_defs, reader)

	def read_uv(self, reader, tex_face_index):

		field_defs = ([
				FieldDef('uv', '2f')
				])

		return read_fields('UV (%d)' % tex_face_index, field_defs, reader)

	def read_tex_face(self, reader, tex_face_index):

		field_defs = ([
				FieldDef('indices', '3i')
				])

		return read_fields('TexFace (%d)' % tex_face_index, field_defs, reader)

	def read_num_bone_links(self, reader, bone_index):

		field_defs = ([
				FieldDef('num_links', 'I')
				])

		return read_fields('NumBoneLinks (%d)' % bone_index, field_defs, reader)

	def read_bone_link(self, reader):

		field_defs = ([
				FieldDef('bone_id', 'i'),
				FieldDef('offset', '3f'),
				FieldDef('blending', 'f')
				])

		return read_fields('BoneLink', field_defs, reader)

	def read_vertex_colour(self, reader, vertex_index):

		field_defs = ([
				FieldDef('rgb', '3B')
				])

		return read_fields('Vertex Colour (%d)' % vertex_index, field_defs, reader)

	def read_alpha(self, reader, vertex_index):

		field_defs = ([
				FieldDef('alpha', 'B')
				])

		return read_fields('Vertex Alpha (%d)' % vertex_index, field_defs, reader)

