from chunk import Chunk, VersionError, DataReader
from chunk_utils import *
import struct

class BoneNameListChunk(Chunk):

	def format(self, pos):

		if self.version == 0x744:

			reader = DataReader(self.data)

			header = self.read_header(reader)
			header.format(pos)
			num_bones = header.find_field('nEntities').value
			for bone_index in xrange(num_bones):
				self.read_bone(reader, bone_index).format(pos)

		elif self.version == 0x745:

			reader = DataReader(self.data)

			header = self.read_header_745(reader)
			header.format(pos)
			num_bones = header.find_field('numEntities').value
			for bone_index in xrange(num_bones):
				self.read_packed_bone(reader, bone_index).format(pos)

		else:
			raise VersionError

	def read_header(self, reader):

		field_defs = ([
				FieldDef('type', 'I', hex),
				FieldDef('version', 'i', hex),
				FieldDef('pos', 'i', hex),
				FieldDef('id', 'i', hex),
				FieldDef('nEntities', 'I')
				])

		return read_fields('Bone Name List Header', field_defs, reader)

	def read_header_745(self, reader):

		field_defs = ([
				FieldDef('numEntities', 'I')
				])

		return read_fields('Bone Name List Header', field_defs, reader)

	def read_bone(self, reader, bone_index):

		field_defs = ([
				FieldDef('name', '64s'),
				])

		return read_fields('Bone Name (%d)' % bone_index, field_defs, reader)

	def read_packed_bone(self, reader, bone_index):
		term = reader.find('\0')
		if term == -1:
			name = ''
		else:
			len = term - reader.position
			name = reader.read(len)
			reader.read(1)
		field_def = FieldDef('name', '')
		field = Field(field_def, name, 0)
		return DataObject(reader.position, 'Bone Name (%d)' % bone_index, [field])

