import chunktypes

class UnknownChunkError(Exception):
	pass

chunk_name_to_id_map = chunktypes.chunk_types

chunk_id_to_name_map = dict([(value, key) for key, value in chunktypes.chunk_types.iteritems()])

class VersionError(Exception):
	pass

class Chunk(object):

	def __init__(self, id, typecode, version, data):
		self.id = id
		self.typecode = typecode
		self.version = version
		self.data = data
		self.size = len(data)

	def get_name(self):
		try:
			return chunk_id_to_name_map[self.typecode]
		except KeyError:
			raise UnknownChunkError()

class DataReader(object):

	def __init__(self, data):
		self.data = data
		self.position = 0

	def read(self, size):
		value = self.data[self.position:self.position + size]
		self.position += size
		return value

	def find(self, string):
		return self.data.find(string, self.position)

