from chunk import Chunk, chunk_name_to_id_map, UnknownChunkError
from mesh_chunk import MeshChunk
from bone_initial_pos_chunk import BoneInitialPosChunk
from bone_name_list_chunk import BoneNameListChunk
from compiled_bones_chunk import CompiledBonesChunk
from node_chunk import NodeChunk
from datastream_chunk import DataStreamChunk
from mesh_subsets_chunk import MeshSubsetsChunk
from mtl_name_chunk import MtlNameChunk
from export_flags_chunk import ExportFlagsChunk
from morph_target_chunk import MeshMorphTargetChunk
from compiled_morph_targets_chunk import CompiledMorphTargetsChunk
from controller_chunk import ControllerChunk
from compiled_physical_bones_chunk import CompiledPhysicalBonesChunk
from compiled_physical_proxy_chunk import CompiledPhysicalProxiesChunk
from helper_chunk import HelperChunk
from mesh_physics_data_chunk import MeshPhysicsDataChunk
from bone_anim_chunk import BoneAnimChunk
from timing_chunk import TimingChunk
from bone_mesh_chunk import BoneMeshChunk

chunk_classes = (['Mesh', 'BoneInitialPos', 'BoneNameList', 'CompiledBones', 'Node',
		'DataStream', 'MeshSubsets', 'MtlName', 'ExportFlags', 'MeshMorphTarget',
		'CompiledMorphTargets', 'Controller', 'CompiledPhysicalBones', 'CompiledPhysicalProxies',
		'Helper', 'MeshPhysicsData', 'BoneAnim', 'Timing', 'BoneMesh'])
chunk_class_map = dict([(chunk_name_to_id_map[x], globals()[x + 'Chunk']) for x in chunk_classes])

def create_chunk(id, typecode, version, data):
	try:
		return chunk_class_map[typecode](id, typecode, version, data)
	except KeyError:
		return Chunk(id, typecode, version, data)

