from chunk import Chunk, VersionError, DataReader
from chunk_utils import *
import struct

class CompiledMorphTargetsChunk(Chunk):

	def format(self, pos):
		
		if self.version == 0x0800 or self.version == 0x0801:

			reader = DataReader(self.data)

			header = self.read_header(reader)
			header.format(pos)

			num_morph_targets = header.find_field('numMorphTargets').value
			for morph_target_index in xrange(num_morph_targets):
				morph_target_header = self.read_morph_target_header_v1(reader, morph_target_index)
				morph_target_header.format(pos)

				name_length = morph_target_header.find_field('NameLength').value
				self.read_morph_target_name(reader, name_length).format(pos)

				int_vertex_count = morph_target_header.find_field('numIntVertices').value
				for target_vertex_index in xrange(int_vertex_count):
					self.read_morph_target_int_vertex(reader, target_vertex_index).format(pos)

				ext_vertex_count = morph_target_header.find_field('numExtVertices').value
				for target_vertex_index in xrange(ext_vertex_count):
					self.read_morph_target_ext_vertex(reader, target_vertex_index).format(pos)

		else:
			raise VersionError

	def read_header(self, reader):

		field_defs = ([
				FieldDef('type', 'I', hex),
				FieldDef('version', 'i', hex),
				FieldDef('pos', 'i', hex),
				FieldDef('id', 'i', hex),
				FieldDef('numMorphTargets', 'I')
				])

		return read_fields('CompiledMorphTargets Header', field_defs, reader)

	def read_morph_target_header_v1(self, reader, morph_target_index):

		field_defs = ([
				FieldDef('MeshID', 'I', hex),
				FieldDef('NameLength', 'I'),
				FieldDef('numIntVertices', 'I'),
				FieldDef('numExtVertices', 'I')
				])

		return read_fields('SMeshMorphTargetHeader Header', field_defs, reader)

	def read_morph_target_header_v2(self, reader, morph_target_index):

		field_defs = ([
				FieldDef('MeshID', 'I', hex),
				FieldDef('NameLength', 'I'),
				FieldDef('numIntVertices', 'I'),
				FieldDef('numExtVertices', 'I'),
				FlagsDef('flags', 'I', ['FLAG_HAS_VERTEX_COLOR', 'FLAG_HAS_VERTEX_ALPHA'])
				])

		return read_fields('SMeshMorphTargetHeader Header', field_defs, reader)

	def read_morph_target_name(self, reader, string_length):
		field_defs = ([
			FieldDef('name', '%ds' % string_length, strz)
			])

		return read_fields('name', field_defs, reader)

	def read_morph_target_color(self, reader, target_vertex_index):

		field_defs = ([
				FieldDef('SMeshColor', 'BBBB'),
				])

		return read_fields('Color (%d)' % target_vertex_index, field_defs, reader)

	def read_morph_target_int_vertex(self, reader, target_vertex_index):

		field_defs = ([
				FieldDef('nVertexId', 'I'),
				FieldDef('ptVertex', '3f')
				])

		return read_fields('IntVertex (%d)' % target_vertex_index, field_defs, reader)

	def read_morph_target_ext_vertex(self, reader, target_vertex_index):

		field_defs = ([
				FieldDef('nVertexId', 'I'),
				FieldDef('ptVertex', '3f')
				])

		return read_fields('ExtVertex (%d)' % target_vertex_index, field_defs, reader)

