from chunk import Chunk, VersionError, DataReader
from chunk_utils import *
import struct

class CompiledPhysicalProxiesChunk(Chunk):

	def format(self, pos):

		if self.version != 0x800:
			raise VersionError

		reader = DataReader(self.data)

		header = self.read_header(reader)
		header.format(pos)
		num_proxies = header.find_field('numPhysicalProxies').value
		for proxy_index in xrange(num_proxies):
			proxy_header = self.read_proxy_header(reader, proxy_index)
			proxy_header.format(pos)

			num_points = proxy_header.find_field('numPoints').value
			for point_index in xrange(num_points):
				self.read_point(reader, point_index).format(pos)

			num_indices = proxy_header.find_field('numIndices').value
			for index_index in xrange(num_indices):
				self.read_index(reader, index_index).format(pos)

			num_materials = proxy_header.find_field('numMaterials').value
			for material_index in xrange(num_materials):
				self.read_material(reader, material_index).format(pos)

	def read_header(self, reader):

		field_defs = ([
				FieldDef('type', 'I', hex),
				FieldDef('version', 'i', hex),
				FieldDef('pos', 'i', hex),
				FieldDef('id', 'i', hex),
				FieldDef('numPhysicalProxies', 'I')
				])

		return read_fields('Compiled Physical Proxies Header', field_defs, reader)

	def read_proxy_header(self, reader, index):

		field_defs = ([
				FieldDef('ChunkID', 'I'),
				FieldDef('numPoints', 'I'),
				FieldDef('numIndices', 'I'),
				FieldDef('numMaterials', 'I')
				])

		return read_fields('SMeshPhysicalProxyHeader (%d)' % index, field_defs, reader)

	def read_point(self, reader, index):

		field_defs = ([
				FieldDef('point', '3f')
				])

		return read_fields('Point (%d)' % index, field_defs, reader)

	def read_index(self, reader, index):

		field_defs = ([
				FieldDef('index', 'H')
				])

		return read_fields('Index (%d)' % index, field_defs, reader)

	def read_material(self, reader, index):

		field_defs = ([
				FieldDef('material', 'B')
				])

		return read_fields('Material (%d)' % index, field_defs, reader)

