from chunk import Chunk, VersionError, DataReader
from chunk_utils import *
import struct

class ControllerChunk(Chunk):

	def format(self, pos):
		
		if self.version == 0x827:

			reader = DataReader(self.data)

			header = self.read_header_827(reader)
			header.format(pos)

			elementCount = header.find_field('numKeys').value
			for i in xrange(elementCount):
				self.read_crykeypqlog(reader, i).format(pos)

		elif self.version == 0x826:
			typeDefEntries = ([
					('CTRL_NONE', None),
					('CTRL_CRYBONE', None),
					('CTRL_LINEER1', None),
					('CTRL_LINEER3', None),
					('CTRL_LINEERQ ', None),
					('CTRL_BEZIER1', None),
					('CTRL_BEZIER3', None),
					('CTRL_BEZIERQ', None),
					('CTRL_TCB1', None),
					('CTRL_TCB3', ('TCB3', [FieldDef('BaseKey3', '3f'), FieldDef('t', 'f'), FieldDef('c', 'f'),
						FieldDef('b', 'f'), FieldDef('ein', 'f'), FieldDef('eout', 'f')])),
					('CTRL_TCBQ', ('TCBQ', [FieldDef('BasekeyQ', '4f'), FieldDef('t', 'f'), FieldDef('c', 'f'),
						FieldDef('b', 'f'), FieldDef('ein', 'f'), FieldDef('eout', 'f')])),
					('CTRL_BSPLINE_2O', None),
					('CTRL_BSPLINE_1O', None),
					('CTRL_BSPLINE_2C', None),
					('CTRL_BSPLINE_1C', None)])
			typeDefs = dict(typeDefEntries)

			reader = DataReader(self.data)

			header = self.read_header_826(reader, [x for x, y in typeDefEntries])
			header.format(pos)

			typeString = header.find_field('type').get_enum_string()
			if typeString in typeDefs and typeDefs[typeString]:
				keyHeader, fieldDefs = typeDefs[typeString]
				count = header.find_field('nKeys').value
				for key in xrange(count):
					read_fields('%s (%d)' % (keyHeader, key), fieldDefs, reader).format(pos)

		else:
			raise VersionError

	def read_header_827(self, reader):

		field_defs = ([
				FieldDef('numKeys', 'i'),
				FieldDef('nControllerId', 'I', hex),
				])

		return read_fields('Controller Header', field_defs, reader)

	def read_header_826(self, reader, type_strings):

		field_defs = ([
				FieldDef('type', 'I', hex),
				FieldDef('version', 'i', hex),
				FieldDef('pos', 'i', hex),
				FieldDef('id', 'i', hex),
				EnumDef('type', 'i', type_strings),
				FieldDef('nKeys', 'i'),
				FlagsDef('flags', 'I', ['CTRL_ORT_CYCLE', 'CTRL_ORT_LOOP']),
				FieldDef('nControllerId', 'I', hex),
				])

		return read_fields('Controller Header', field_defs, reader)


	def read_crykeypqlog(self, reader, index):

		field_defs = ([
				FieldDef('nTime', 'i'),
				FieldDef('vPos', '3f'),
				FieldDef('vRotLog', '3f'),
				])

		return read_fields('CryKeyPQLog (%d)' % index, field_defs, reader)

