from chunk import Chunk, VersionError, DataReader
from chunk_utils import *
import struct

class DataStreamChunk(Chunk):

	def format(self, pos):

		if self.version != 0x800:
			raise VersionError

		typeDefEntries = ([
				('CGF_STREAM_POSITIONS',  ('Position', [FieldDef('pos', '3f')])),
				('CGF_STREAM_NORMALS',  ('Normal', [FieldDef('normal', '3f')])),
				('CGF_STREAM_TEXCOORDS',  ('UV', [FieldDef('uv', '2f')])),
				('CGF_STREAM_COLORS',  ('Colour', [FieldDef('rgba', 'I', hex)])),
				('CGF_STREAM_COLORS2',  ('Colour 2', [FieldDef('rgba', 'I', hex)])),
				('CGF_STREAM_INDICES',  ('Index', [FieldDef('index', 'H')])),
				('CGF_STREAM_TANGENTS',  ('Tangent', [FieldDef('Tangent', '4h'), FieldDef('Binormal', '4h')])),
				('CGF_STREAM_SHCOEFFS',  ('SH Coeff', [FieldDef('coeffs', '8B')])),
				('CGF_STREAM_SHAPEDEFORMATION',  ('Shape Deformation', [FieldDef('thin', '3f'), FieldDef('fat', '3f'), FieldDef('index', 'I', hex)])),
				('CGF_STREAM_BONEMAPPING',  ('Bone Mapping', [FieldDef('boneIDs', 'I', hex), FieldDef('weights', 'I', hex)])),
				('CGF_STREAM_FACEMAP',  ('Stream Facemap', [FieldDef('mapping', 'H')]))])
		typeDefs = dict(typeDefEntries)

		reader = DataReader(self.data)

		header = self.read_header(reader, [x for x, y in typeDefEntries])
		header.format(pos)

		typeString = header.find_field('nStreamType').get_enum_string()
		elementHeader, fieldDefs = typeDefs[typeString]

		elementCount = header.find_field('nCount').value
		for elementIndex in xrange(elementCount):
			read_fields('%s (%d)' % (elementHeader, elementIndex), fieldDefs, reader).format(pos)

	def read_header(self, reader, type_strings):

		field_defs = ([
				FieldDef('type', 'I', hex),
				FieldDef('version', 'i', hex),
				FieldDef('pos', 'i', hex),
				FieldDef('id', 'i', hex),

				FieldDef('nFlags', 'i', hex),
				EnumDef('nStreamType', 'i', type_strings),

				FieldDef('nCount', 'i'),
				FieldDef('nElementSize', 'i'),
				FieldDef('reserved', '8s', hex_dump)
				])

		return read_fields('Data Stream Header', field_defs, reader)

	def read_elements(self, type, typeDefs):
		pass
