from chunk import Chunk, VersionError, DataReader
from chunk_utils import *
import struct

class ExportFlagsChunk(Chunk):

	def format(self, pos):
		
		if self.version == 0x1:

			reader = DataReader(self.data)

			header = self.read_header(reader)
			header.format(pos)

		else:
			raise VersionError

	def read_header(self, reader):

		field_defs = ([
				FieldDef('type', 'I', hex),
				FieldDef('version', 'i', hex),
				FieldDef('pos', 'i', hex),
				FieldDef('id', 'i', hex),
				FlagsDef('flags', 'i', ['MERGE_ALL_NODES']),
				FieldDef('rc_version', '4I'),
				FieldDef('rc_version_string', '16s', strz),
				FieldDef('reserved', '128s', hex_dump),
				])

		return read_fields('Export Flags Header', field_defs, reader)

