from chunk import Chunk, VersionError, DataReader
from chunk_utils import *
import struct

class HelperChunk(Chunk):

	def format(self, pos):
		
		if self.version == 0x744:

			reader = DataReader(self.data)

			header = self.read_header(reader)
			header.format(pos)

		else:
			raise VersionError

	def read_header(self, reader):

		field_defs = ([
				FieldDef('type', 'I', hex),
				FieldDef('version', 'i', hex),
				FieldDef('pos', 'i', hex),
				FieldDef('id', 'i', hex),
				EnumDef('type', 'i', ['HP_POINT', 'HP_DUMMY', 'HP_XREF', 'HP_CAMERA', 'HP_GEOMETRY']),
				FieldDef('size', '3f')
				])

		return read_fields('Helper', field_defs, reader)

