from chunk import Chunk, VersionError, DataReader
from chunk_utils import *
import struct

class MeshMorphTargetChunk(Chunk):

	def format(self, pos):
		
		if self.version == 0x1:

			reader = DataReader(self.data)

			header = self.read_header_v1(reader)
			header.format(pos)

			num_target_vertices = header.find_field('numMorphVertices').value
			for target_vertex_index in xrange(num_target_vertices):
				self.read_mesh_morph_target_vertex(reader, target_vertex_index).format(pos)

			string_length = self.size - reader.position
			self.read_name(reader, string_length).format(pos)

		elif self.version == 0x2:

			reader = DataReader(self.data)

			header = self.read_header_v2(reader)
			header.format(pos)

			name_length_field = self.read_name_length(reader)
			name_length_field.format(pos)
			name_length = name_length_field.find_field('length').value
			self.read_name(reader, name_length).format(pos)

			num_target_vertices = header.find_field('numMorphVertices').value
			for target_vertex_index in xrange(num_target_vertices):
				self.read_mesh_morph_target_vertex(reader, target_vertex_index).format(pos)

			if header.find_field('flags').flag_set('FLAG_HAS_VERTEX_COLOR'):
				for target_vertex_index in xrange(num_target_vertices):
					self.read_mesh_morph_target_colour(reader, target_vertex_index).format(pos)

			if header.find_field('flags').flag_set('FLAG_HAS_VERTEX_ALPHA'):
				for target_vertex_index in xrange(num_target_vertices):
					self.read_mesh_morph_target_alpha(reader, target_vertex_index).format(pos)

		else:
			raise VersionError

	def read_header_v1(self, reader):

		field_defs = ([
				FieldDef('nChunkIdMesh', 'I', hex),
				FieldDef('numMorphVertices', 'I')
				])

		return read_fields('MeshMorphTarget Header', field_defs, reader)

	def read_header_v2(self, reader):

		field_defs = ([
				FieldDef('nChunkIdMesh', 'I', hex),
				FieldDef('numMorphVertices', 'I'),
				FlagsDef('flags', 'I', ['FLAG_HAS_VERTEX_COLOR', 'FLAG_HAS_VERTEX_ALPHA'])
				])

		return read_fields('MeshMorphTarget Header', field_defs, reader)

	def read_mesh_morph_target_vertex(self, reader, target_vertex_index):

		field_defs = ([
				FieldDef('nVertexId', 'I'),
				FieldDef('ptVertex', '3f')
				])

		return read_fields('SMeshMorphTargetVertex (%d)' % target_vertex_index, field_defs, reader)

	def read_mesh_morph_target_colour(self, reader, target_vertex_index):

		field_defs = ([
				FieldDef('rgb', 'BBB')
				])

		return read_fields('CryIRGB (%d)' % target_vertex_index, field_defs, reader)

	def read_mesh_morph_target_alpha(self, reader, target_vertex_index):

		field_defs = ([
				FieldDef('alpha', 'B')
				])

		return read_fields('CryIRGB (%d)' % target_vertex_index, field_defs, reader)

	def read_name(self, reader, string_length):
		field_defs = ([
			FieldDef('name', '%ds' % string_length, strz)
			])

		return read_fields('name', field_defs, reader)

	def read_name_length(self, reader):
		field_defs = ([
			FieldDef('length', 'i')
			])
		return read_fields('name length', field_defs, reader)

