from chunk import Chunk, VersionError, DataReader
from chunk_utils import *
import struct

class MtlNameChunk(Chunk):

	def format(self, pos):
		
		if self.version == 0x800:

			reader = DataReader(self.data)

			header = self.read_header_800(reader)
			header.format(pos)

		else:
			raise VersionError

	def read_header_800(self, reader):

		field_defs = ([
				FieldDef('type', 'I', hex),
				FieldDef('version', 'i', hex),
				FieldDef('pos', 'i', hex),
				FieldDef('id', 'i', hex),
				FlagsDef('flags1', 'i', ['FLAG_MULTI_MATERIAL', 'FLAG_SUB_MATERIAL',
					'FLAG_SH_COEFFS', 'FLAG_SH_2SIDED', 'FLAG_SH_AMBIENT']),
				FieldDef('flags2', 'i'),
				FieldDef('name', '128s', strz),
				EnumDef('nPhysicalizeType', 'i', {-1: 'PHYS_GEOM_TYPE_NONE', 0: 'PHYS_GEOM_TYPE_DEFAULT',
					1: 'PHYS_GEOM_TYPE_NO_COLLIDE', 2: 'PHYS_GEOM_TYPE_OBSTRUCT'}),
				FieldDef('nSubMaterials', 'i'),
				FieldDef('nSubMatChunkId', '32i'),
				FieldDef('nAdvancedDataChunkId', 'i'),
				FieldDef('sh_opacity', 'f'),
				FieldDef('reserve', '128s', hex_dump)
				])

		return read_fields('Mesh Subsets Header', field_defs, reader)

