from chunk import Chunk, VersionError, DataReader
from chunk_utils import *
import struct

class NodeChunk(Chunk):

	def format(self, pos):

		reader = DataReader(self.data)

		header = self.read_header(reader)
		header.format(pos)
		prop_str_len = header.find_field('PropStrLen').value
		prop_str = reader.read(prop_str_len)
		print prop_str

	def get_node_name(self):

		reader = DataReader(self.data)
		header = self.read_header(reader)
		name = header.find_field('name').value
		return name

	def read_header(self, reader):

		field_defs = ([
				FieldDef('type', 'I', hex),
				FieldDef('version', 'i', hex),
				FieldDef('pos', 'i', hex),
				FieldDef('id', 'i', hex),
				FieldDef('name', '64s', strz),

				FieldDef('ObjectID', 'i'),
				FieldDef('ParentID', 'i'),
				FieldDef('nChildren', 'i'),
				FieldDef('MatID', 'i'),

				FieldDef('IsGroupHead', 'b'),
				FieldDef('IsGroupMember', 'b'),
				FieldDef('tm[0]', '4f'),
				FieldDef('tm[1]', '4f'),
				FieldDef('tm[2]', '4f'),
				FieldDef('tm[3]', '4f'),

				FieldDef('pos', '3f'),
				FieldDef('rot', '4f'),
				FieldDef('scl', '3f'),

				FieldDef('pos_cont_id', 'i'),
				FieldDef('rot_cont_id', 'i'),
				FieldDef('scl_cont_id', 'i'),

				FieldDef('PropStrLen', 'i')
				])

		return read_fields('Node Header', field_defs, reader)

	def read_bone(self, reader, bone_index):

		field_defs = ([
				FieldDef('transform row 1', '3f'),
				FieldDef('transform row 2', '3f'),
				FieldDef('transform row 3', '3f'),
				FieldDef('transform row 4', '3f')
				])

		return read_fields('Bone Initial Transform (%d)' % bone_index, field_defs, reader)

