from chunk import Chunk, VersionError, DataReader
from chunk_utils import *
import struct

class TimingChunk(Chunk):

	def format(self, pos):
		
		if self.version == 0x918:

			reader = DataReader(self.data)

			header = self.read_header(reader)
			header.format(pos)

		else:
			raise VersionError

	def read_header(self, reader):

		field_defs = ([
				FieldDef('type', 'I', hex),
				FieldDef('version', 'i', hex),
				FieldDef('pos', 'i', hex),
				FieldDef('id', 'i', hex),
				FieldDef('SecsPerTick', 'f'),
				FieldDef('TicksPerFrame', 'i'),
				FieldDef('global_range.name', '32s', strz),
				FieldDef('global_range.start', 'i'),
				FieldDef('global_range.end', 'i'),
				FieldDef('nSubRanges', 'i'),
				])

		return read_fields('Timing Header', field_defs, reader)

