////////////////////////////////////////////////////////////////////////////
//
//  CryEngine Source File.
//  Copyright (C), Crytek, 1999-2009.
// -------------------------------------------------------------------------
//  File name:   Config.cpp
//  Version:     v1.00
//  Created:     10/10/2009 by Alex McCarthy (refactored from StatsTool.cpp).
//  Description: Common code to parse configuration files
////////////////////////////////////////////////////////////////////////////

#ifndef __CONFIG_H__
#define __CONFIG_H__

#include "MapList.h"
#include "Job.h"

#include <string>

struct SLogger;

struct SConfig
{
	enum EPlatform
	{
		ePL_NONE,
		ePL_PS3,
		ePL_XBOX360,
	};

	enum ELoggingType
	{
		eLT_NONE,
		eLT_MEM_REPLAY,
		eLT_PERF_STATS,
	};

	enum EPollCVARAction
	{
		ePCA_NONE,
		ePCA_FINISH,
	};

	typedef std::vector<std::string> MailingList;

	// If a job list is passed in it will be populated with jobs containing individual configs
	bool ParseConfigFile( const char* const pConfig, SLogger* pLogger = NULL, JobList* const pJobList = NULL );
	SConfig();

	EPlatform ePlatform;
	ELoggingType eLoggingType;
	EPollCVARAction ePollCVARAction;
	std::string sTargetName;
	std::string sExecutable;
	std::string sArguments;
	std::string sMemoryStatsDir;
	std::string sPerfStatsDir;
	std::string sReportOutDir;
	std::string sPostprocessTool;
	std::string sConfluenceSpace;
	std::string sConfluencePage;
	std::string sConfluenceUser;
	std::string sConfluencePassword;
	std::string sGnuplotPath;
	std::string sPollCVARName;
	std::string sPipeName;
	std::string sSMTPServer;
	std::string sSMTPSender;
	std::string sSubjectSuffixFile;
	MailingList recipients;
	CMapList mapList;
	bool bVerbose;
	bool bOutputTTY;
	bool bPauseOnConnect;
	bool bPauseOnError;
	bool bTelnet;
	int iDelay;
	int iMaxErrors;
	int iPerfStatsPeriod;
	int iPollCVARValue;
	unsigned int uSMTPPort;
	unsigned int uTelnetPort;
};

#endif // __CONFIG_H__
