////////////////////////////////////////////////////////////////////////////
//
//  CryEngine Source File.
//  Copyright (C), Crytek, 1999-2010.
// -------------------------------------------------------------------------
//  File name:   Job.cpp
//  Version:     v1.00
//  Created:     26/01/2010 by Steve Barnett.
//  Description: Common code to build a list of jobs
////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include "Config.h"

SJob::SJob( const SConfig* const pConfig )
: m_pConfig( NULL )
, m_running( false )
, m_complete( false )
, m_failed( false )
, m_kill( false )
, m_errors( 0 )
{
	if ( pConfig )
	{
		m_pConfig = new SConfig( *pConfig );
	}
}

SJob::SJob( const SJob& other )
: m_pConfig( NULL )
, m_running( other.m_running )
, m_complete( other.m_complete )
, m_failed( other.m_failed )
, m_kill( other.m_kill )
, m_errors( other.m_errors )
, m_logs( other.m_logs )
{
	if ( other.m_pConfig )
	{
		m_pConfig = new SConfig( *other.m_pConfig );
	}
}

SJob::~SJob( void )
{
	delete m_pConfig;
}
