////////////////////////////////////////////////////////////////////////////
//
//  CryEngine Source File.
//  Copyright (C), Crytek, 1999-2010.
// -------------------------------------------------------------------------
//  File name:   Job.h
//  Version:     v1.00
//  Created:     26/01/2010 by Steve Barnett.
//  Description: Common code to build a list of jobs
////////////////////////////////////////////////////////////////////////////

#ifndef __JOB_H__
#define __JOB_H__

#include <vector>
#include "Logger.h"

struct SConfig;

struct SLog
{
	std::string m_logfile;
	SLogger m_logger;
};

struct SJob
{
	typedef std::vector<SLog> LogList;

	SConfig* m_pConfig;
	bool m_running;
	bool m_complete;
	bool m_failed;
	bool m_kill;
	int m_errors;
	LogList m_logs;

	SJob() : m_pConfig( NULL ), m_running( false ), m_complete( false ), m_failed( false ), m_kill( false ), m_errors( 0 ) {};
	SJob( const SConfig* const pConfig );
	SJob( const SJob& );
	~SJob( void );
};

typedef std::vector<SJob> JobList;

#endif
