////////////////////////////////////////////////////////////////////////////
//
//  CryEngine Source File.
//  Copyright (C), Crytek, 1999-2010.
// -------------------------------------------------------------------------
//  File name:   Logger.cpp
//  Version:     v1.00
//  Created:     02/03/2010 by Steve Barnett.
//  Description: Common code to build a list of jobs
////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include <stdarg.h>
#include <stdio.h>
#include <string.h>

#include "Logger.h"

void SLogger::LogError( const char* const pFormat, ... )
{
	char* const pBuf = new char[512];
	va_list ap;
	va_start( ap, pFormat );
	sprintf_s( pBuf, 512, "[Error] " );
	vsprintf_s( pBuf + strlen( pBuf ), 512, pFormat, ap );
	va_end( ap );
	++m_errors;
	m_output.push_back( std::string( pBuf ) );
	fprintf( stderr, pBuf );
}

void SLogger::LogWarning( const char* const pFormat, ... )
{
	char* const pBuf = new char[512];
	va_list ap;
	va_start( ap, pFormat );
	sprintf_s( pBuf, 512, "[Warning] " );
	vsprintf_s( pBuf + strlen( pBuf ), 512, pFormat, ap );
	va_end( ap );
	++m_warnings;
	m_output.push_back( std::string( pBuf ) );
	fprintf( stderr, pBuf );
}
