////////////////////////////////////////////////////////////////////////////
//
//  CryEngine Source File.
//  Copyright (C), Crytek, 1999-2010.
// -------------------------------------------------------------------------
//  File name:   Logger.h
//  Version:     v1.00
//  Created:     02/03/2010 by Steve Barnett.
//  Description: Common code to build a list of jobs
////////////////////////////////////////////////////////////////////////////

#ifndef __LOGGER_H__
#define __LOGGER_H__

#include <vector>
#include <string>

struct SLogger
{
	typedef std::vector<std::string> ErrorList;

	ErrorList m_output;
	int m_errors;
	int m_warnings;

	SLogger() : m_errors( 0 ), m_warnings( 0 ) {};

	void LogError( const char* const pFormat, ... );
	void LogWarning( const char* const pFormat, ... );
};

#endif
